/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include<konoha.h>
#define KNH_PKGNAME "math"

#ifdef KNH_USING_MATH
#define _USE_MATH_DEFINES     /* needed in Windows */
#include<math.h>    /* @using math -lm */
#endif

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [method] */

#ifdef KNH_USING_MATH
/* ------------------------------------------------------------------------ */
/* @method Float! Math.sin(Float! v) */

static
METHOD knh__Math_sin(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, sin(p_double(sfp[1])));
}

/* ------------------------------------------------------------------------ */
/* @method Float! Math.abs(Float! v) */

static
METHOD knh__Math_abs(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Float(ctx, sfp, fabs(p_double(sfp[1])));
}

#endif/*KNH_USING_MATH*/


static int testnum(int n) {
	return n;
}

/* ------------------------------------------------------------------------ */
/* @method Int! Math.succ(Int! n) */

static
METHOD knh__Math_testnum(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, testnum(p_int(sfp[1])));
}

/* ======================================================================== */
/* [KNHAPI] */

void knhmath_traverse(Ctx *ctx, knh_ftraverse ftr)
{
//	if(IS_SWEEP(ftr)) {
//
//	}
}

/* ------------------------------------------------------------------------ */

int knhmath_init(Ctx *ctx)
{
#ifdef KNH_USING_MATH
	KNH_NOTICE(ctx, "loading math..");
	konoha_addVirtualClass(ctx, "Math", 8);
	konoha_addMethod(ctx, "Float! Math.abs(Float! v)", knh__Math_abs);
	konoha_addMethod(ctx, "float Math.sin(float v)", knh__Math_sin);
	konoha_addFloatConst(ctx, "Math.PI", (knh_float_t)M_PI);
	konoha_addFloatConst(ctx, "Math.E", (knh_float_t)M_E);
	konoha_addMethod(ctx, "int Math.testnum(int n)", knh__Math_testnum);
	return 1;
#else
	return 0;
#endif
}

/* ------------------------------------------------------------------------ */

static knh_pkgmeta_t PKGDATA = {
	KONOHA_BUILDID, /* Don't change this */
	KNH_PKGNAME,    /* package name (not NULL) */
	"1.0",  /* package version (not NULL) */
	NULL,   /* additional information */
	KONOHA_URLBASE "package.math", /* URL */
	knhmath_init,
	knhmath_traverse,
	NULL
};

KNH_EXPORTS(knh_pkgmeta_t*) knhmath_load(Ctx *ctx)
{
	return &(PKGDATA);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

