/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#ifndef KONOHA_T_H_
#define KONOHA_T_H_

#include<stdio.h>
#include<limits.h>
#include<float.h>
#include<setjmp.h>

#include"konoha_config.h"

#if defined(KNH_USING_PTHREAD)
	#include<pthread.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ------------------------------------------------------------------------ */

#ifndef INLINE
#define INLINE             /*__inline__*/
#endif

#define PUBLIC
#define PRIVATE            static

#define METHOD             void  KNH_CC_FASTCALL
#define MAPPER             METHOD
#define ITRNEXT            METHOD

#ifdef KNH_USING_THREAD
#define KNH_MT_VOLATILE           volatile
#else
#define KNH_MT_VOLATILE
#endif

/* ------------------------------------------------------------------------ */

/* ------------------------------------------------------------------------ */
/* Bool(ean), knh_bool_t */
/* ------------------------------------------------------------------------ */

typedef int                      knh_bool_t;
typedef int                      knh_boolean_t;

/* ------------------------------------------------------------------------ */
/* Int, knh_int_t */
/* ------------------------------------------------------------------------ */

typedef signed long int           knh_int_t;    /* sizeof(knh_int_t) = sizeof(*p) */
#define KNH_INT_MAX               LONG_MAX
#define KNH_INT_MIN               LONG_MIN
#define KNH_INT_FMT               "%ld"
#define KNH_INT_FMTX              "%lx"
#define KNH_INT_BSIZE             (sizeof(knh_int_t))
#define KNH_INT_FMTSIZ            40

typedef unsigned long int         knh_uint_t;   /* sizeof(knh_uint_t) = sizeof(*p) */
#define KNH_UINT_MAX              ULONG_MAX
#define KNH_UINT_MIN              0
#define KNH_UINT_FMT              "%lu"

typedef knh_int_t                 knh_index_t;
typedef size_t                    knh_size_t;
typedef size_t                    bsize_t;
typedef knh_int_t                 int_byte_t;

#define KONOHA_SYSTEM_BIT        (sizeof(knh_int_t) * CHAR_BIT))

/* ------------------------------------------------------------------------ */
/* knh_flag_t */
/* ------------------------------------------------------------------------ */

typedef short                     knh_short_t;
typedef unsigned short            knh_ushort_t;

/* ------------------------------------------------------------------------ */
/* knh_flag_t */
/* ------------------------------------------------------------------------ */

typedef knh_ushort_t              knh_flag_t;    /* flag field */

#define KNH_FLAG_T0     ((knh_flag_t)(1 << 15))
#define KNH_FLAG_T1     ((knh_flag_t)(1 << 14))
#define KNH_FLAG_T2     ((knh_flag_t)(1 << 13))
#define KNH_FLAG_T3     ((knh_flag_t)(1 << 12))
#define KNH_FLAG_T4     ((knh_flag_t)(1 << 11))
#define KNH_FLAG_T5     ((knh_flag_t)(1 << 10))
#define KNH_FLAG_T6     ((knh_flag_t)(1 << 9))
#define KNH_FLAG_T7     ((knh_flag_t)(1 << 8))
#define KNH_FLAG_T8     ((knh_flag_t)(1 << 7))
#define KNH_FLAG_T9     ((knh_flag_t)(1 << 6))
#define KNH_FLAG_T10    ((knh_flag_t)(1 << 5))
#define KNH_FLAG_T11    ((knh_flag_t)(1 << 4))
#define KNH_FLAG_T12    ((knh_flag_t)(1 << 3))
#define KNH_FLAG_T13    ((knh_flag_t)(1 << 2))
#define KNH_FLAG_T14    ((knh_flag_t)(1 << 1))
#define KNH_FLAG_T15    ((knh_flag_t)(1 << 0))

#define KNH_FLAG15    ((knh_flag_t)(1 << 15))
#define KNH_FLAG14    ((knh_flag_t)(1 << 14))
#define KNH_FLAG13    ((knh_flag_t)(1 << 13))
#define KNH_FLAG12    ((knh_flag_t)(1 << 12))
#define KNH_FLAG11    ((knh_flag_t)(1 << 11))
#define KNH_FLAG10    ((knh_flag_t)(1 << 10))
#define KNH_FLAG09     ((knh_flag_t)(1 << 9))
#define KNH_FLAG08     ((knh_flag_t)(1 << 8))
#define KNH_FLAG07     ((knh_flag_t)(1 << 7))
#define KNH_FLAG06     ((knh_flag_t)(1 << 6))
#define KNH_FLAG05     ((knh_flag_t)(1 << 5))
#define KNH_FLAG04     ((knh_flag_t)(1 << 4))
#define KNH_FLAG03     ((knh_flag_t)(1 << 3))
#define KNH_FLAG02     ((knh_flag_t)(1 << 2))
#define KNH_FLAG01     ((knh_flag_t)(1 << 1))
#define KNH_FLAG00     ((knh_flag_t)(1 << 0))

#define KNH_FLAG9      ((knh_flag_t)(1 << 9))
#define KNH_FLAG8      ((knh_flag_t)(1 << 8))
#define KNH_FLAG7      ((knh_flag_t)(1 << 7))
#define KNH_FLAG6      ((knh_flag_t)(1 << 6))
#define KNH_FLAG5      ((knh_flag_t)(1 << 5))
#define KNH_FLAG4      ((knh_flag_t)(1 << 4))
#define KNH_FLAG3      ((knh_flag_t)(1 << 3))
#define KNH_FLAG2      ((knh_flag_t)(1 << 2))
#define KNH_FLAG1      ((knh_flag_t)(1 << 1))
#define KNH_FLAG0      ((knh_flag_t)(1 << 0))

#define KNH_FLAG_SET(f,op)     (f) = ((f)|(op))
#define KNH_FLAG_UNSET(f,op)   (f) = ((f)&(~(op)))
#define KNH_FLAG_IS(f,op)      (((f) & (op)) == (op))

/* ------------------------------------------------------------------------ */
/* Float, knh_float_t */
/* ------------------------------------------------------------------------ */

#ifdef KNH_FLOAT_TYPE__LONG_DOUBLE
	typedef long double               knh_float_t;
	#define KNH_FLOAT_MAX             LDBL_MAX
	#define KNH_FLOAT_MIN             (-(LDBL_MAX))
	#define KNH_FLOAT_STEP            LDBL_MIN
	#define KNH_FLOAT_FMT             "%Lf"
	#define KNH_FLOAT_FMT1            "%.1Lf"
	#define KNH_FLOAT_FMT2            "%.2Lf"
	#define KNH_FLOAT_FMT3            "%.3Lf"
	#define KNH_FLOAT_FMT4            "%.4Lf"
	#define KNH_FLOAT_FMTE            "%Le"
#else
	#ifdef KNH_FLOAT_TYPE__FLOAT
		typedef float                     knh_float_t;
		#define KNH_FLOAT_MAX             FLT_MAX
		#define KNH_FLOAT_MIN             (-(FLT_MAX))
		#define KNH_FLOAT_STEP            FLT_MIN
		#define KNH_FLOAT_FMT             "%f"
		#define KNH_FLOAT_FMT1            "%.1f"
		#define KNH_FLOAT_FMT2            "%.2f"
		#define KNH_FLOAT_FMT3            "%.3f"
		#define KNH_FLOAT_FMT4            "%.4f"
		#define KNH_FLOAT_FMTE            "%e"
	#else
		typedef double                    knh_float_t;
		#define KNH_FLOAT_MAX             DBL_MAX
		#define KNH_FLOAT_MIN             (-(DBL_MAX))
		#define KNH_FLOAT_STEP            DBL_MIN
		#define KNH_FLOAT_FMT             "%f"
		#define KNH_FLOAT_FMT1            "%.1f"
		#define KNH_FLOAT_FMT2            "%.2f"
		#define KNH_FLOAT_FMT3            "%.3f"
		#define KNH_FLOAT_FMT4            "%.4f"
		#define KNH_FLOAT_FMTE            "%e"
	#endif
#endif

#define knh_double_t                    knh_float_t /* just in case */
#define KNH_FLOAT_FMTSIZ                256

/* ------------------------------------------------------------------------ */
/* Long, knh_int64_t */
/* ------------------------------------------------------------------------ */

#ifndef LLONG_MIN
#define LLONG_MIN -9223372036854775807LL
#define LLONG_MAX  9223372036854775807LL
#endif

#ifndef ULLONG_MAX
#define ULLONG_MAX 18446744073709551615ULL
#endif

typedef signed long long int           knh_int64_t;
typedef unsigned long long int         knh_uint64_t;

#define KNH_LONG_MAX   LLONG_MAX
#define KNH_LONG_MIN   LLONG_MIN
#define KNH_ULONG_MAX  ULLONG_MAX
#define KNH_ULONG_MIN  ((knh_uint64_t)0)

/* ------------------------------------------------------------------------ */
/* Integer, knh_integer_t */
/* ------------------------------------------------------------------------ */

#ifdef KNH_USING_INT32

#define knh_integer_t    knh_int_t
#define knh_uinteger_t   knh_uint_t

#define KNH_INTEGER_MAX               LONG_MAX
#define KNH_INTEGER_MIN               LONG_MIN
#define KNH_INTEGER_FMT               "%ld"
#define KNH_INTEGER_XFMT              "%lx"
#define KNH_INTEGER_BSIZE             (sizeof(knh_integer_t))
#define KNH_INTEGER_FMTSIZ            40
#define KNH_UINTEGER_MAX              ULONG_MAX
#define KNH_UINTEGER_MIN              0
#define KNH_UINTEGER_FMT              "%lu"
#define knh_abs(n)                labs(n)

#else /*KNH_USING_INT32*/

#define knh_integer_t    knh_int64_t
#define knh_uinteger_t   knh_uint64_t

#define KNH_INTEGER_MAX               LLONG_MAX
#define KNH_INTEGER_MIN               LLONG_MIN
#define KNH_INTEGER_FMT               "%lld"
#define KNH_INTEGER_XFMT              "%llx"
#define KNH_INTEGER_BSIZE             (sizeof(knh_integer_t))
#define KNH_INTEGER_FMTSIZ            40
#define KNH_UINTEGER_MAX              ULLONG_MAX
#define KNH_UINTEGER_MIN              0
#define KNH_UINTEGER_FMT              "%llu"
#define knh_abs(n)                llabs(n)

#endif/*KNH_USING_INT32*/

#define _DCAST(t,v)     ((t)v)

/* ------------------------------------------------------------------------ */
/* String, knh_uchar_t */
/* ------------------------------------------------------------------------ */

typedef unsigned char           knh_uchar_t;    /* byte */

typedef struct {
	knh_uchar_t   *buf;
	size_t     len;
} knh_bytes_t;

#define ismulti(c)             (((knh_uchar_t)c)>127)

/* ------------------------------------------------------------------------ */
/* Struct, Class, Type  */
/* ------------------------------------------------------------------------ */

typedef unsigned short       knh_struct_t ; /* struct id*/
typedef unsigned short       knh_class_t;   /* class id */
typedef unsigned short       knh_type_t;    /* extended knh_type_t */
typedef unsigned short       knh_expt_t;    /* knh_expt_t */

#define KNH_CLASSSPEC_FMT    "%s{%s}"

/* ------------------------------------------------------------------------ */

typedef knh_ushort_t          knh_nsid_t;
typedef knh_ushort_t          knh_fileid_t;

typedef knh_ushort_t          knh_fieldn_t;
typedef knh_ushort_t          knh_methodn_t;

/* ------------------------------------------------------------------------ */
/* Object */
/* ------------------------------------------------------------------------ */

#define KNH_OBJECT_MAGIC         578
#define KNH_FASTMALLOC_MAGIC     911

#ifdef KNH_USING_RCGC
#define KNH_HOBJECT_REFC      1
#endif

typedef struct knh_hObject_t {
	knh_ushort_t magic;
	knh_flag_t  flag;
	knh_class_t bcid;
	knh_class_t cid;
#ifdef KNH_HOBJECT_REFC
	KNH_MT_VOLATILE knh_uint_t refc;
#endif
} knh_hObject_t ;

typedef struct knh_Object_t {
	knh_hObject_t h;
	void *ref;
	void *ref2_unused;
	void *ref3_unused;
} knh_Object_t ;


#ifdef KNH_OBJECT_MAGIC
	#ifdef KNH_FASTMODE
		#define KNH_ASSERT_ISOBJECT(o)
	#else
		#define KNH_ASSERT_ISOBJECT(o)        KNH_ASSERT((o)->h.magic == KNH_OBJECT_MAGIC)
	#endif
#else/*KONOHA_OBJECT_MAGIC*/
	#define KNH_ASSERT_ISOBJECT(o)
#endif/*KONOHA_OBJECT_MAGIC*/

/* types of basic objects (not type-checked) */

#define Object          knh_Object_t
#define ObjectNULL      Object
#define Any             knh_Object_t
#define This            knh_Object_t
#define Any1            knh_Object_t
#define Any2            knh_Object_t
#define UP(o)           (Object*)(o)

#define KNH_FIELDn(v,n)            ((Script*)(v))->fields[(n)]


/* ------------------------------------------------------------------------ */
/* Context */
/* ------------------------------------------------------------------------ */

typedef unsigned char           knh_code_t;          /* knh_vmc_t */

#define p_size(a)      ((size_t)(a).ivalue)
#define p_int(a)         ((knh_int_t)(a).ivalue)
#define p_uint(a)        ((knh_uint_t)(a).ivalue)
#define p_integer(a)     ((a).ivalue)
#define p_uinteger(a)    ((knh_uinteger_t)(a).ivalue)

#define p_float(a)       ((a).fvalue)
#define p_double(a)      ((double)(a).fvalue)
#define p_bool(a)        ((a).bvalue)
#define p_char(a)        (knh_String_tochar(a.s))
#define p_bytes(a)       (knh_Bytes_tobytes(a.s))
#define p_cid(a)         ((a.c)->cid)
#define ARG_Object_cid(a)  knh_Object_cid(a.o)
#define p_cptr(a)        ((a.n)->cptr)

/* ------------------------------------------------------------------------ */

typedef struct knh_sfp_t {
	union {
		void   *ref;
		Object *o;
		struct knh_Int_t    *i;
		struct knh_Float_t  *f;
		struct knh_Class_t  *c;
		struct knh_String_t *s;
		struct knh_Bytes_t  *ba;
		struct knh_Iterator_t *it;
		struct knh_Glue_t   *n;
		struct knh_OutputStream_t *w;
		struct knh_Method_t *mtd;
		struct knh_Mapper_t *mpr;
		struct knh_Exception_t *e;
		struct knh_ExceptionHandler_t *hdr;
	};
	union {
		knh_boolean_t bvalue;
		knh_integer_t ivalue;
		knh_float_t   fvalue;
		knh_code_t    *pc;
		knh_uint_t     op;
		knh_uint64_t   data;
	};
} knh_sfp_t;


#define KNH_RETURN(ctx, sfp, v) {\
		Int *n_ = (Int*)v;\
		KNH_NGCMOV(ctx, sfp[-1].o, n_);\
		sfp[-1].data = (n_)->n.data;\
		return; \
	}\

#define KNH_RETURN_void(ctx, sfp)      {\
		KNH_NGCMOV(ctx, sfp[-1].o, KNH_VOID); \
		return; \
	}\

#define KNH_RETURN_Boolean(ctx, sfp, c) {\
		sfp[-1].bvalue = c; \
		return; \
	}\

#define KNH_RETURN_Int(ctx, sfp, n)      {\
		sfp[-1].ivalue = (knh_integer_t)n;\
		return; \
	}\

#define KNH_RETURN_Float(ctx, sfp, n)      {\
		sfp[-1].fvalue = (knh_float_t)n;\
		return; \
	}\

#define KNH_ITRNEXT(ctx, sfp, i, v) {\
		KNH_MOV(ctx, sfp[i].o, v);\
		sfp[i].data = ((Int*)v)->n.data;\
		return; \
	}\

#define KNH_ITREND(ctx, sfp, n) {\
		knh_Iterator_close(ctx, sfp[0].it);\
		KNH_MOV(ctx, sfp[n].o, KNH_VOID);\
		return; \
	}\

#define HAS_ITRNEXT(v)   IS_NOTNULL(v)

#define KNH_ITRNEXT_Int(ctx, sfp, n, value) {\
		sfp[n].ivalue = value;\
		KNH_MOV(ctx, sfp[n].o, KNH_INT0);\
		return; \
	}\

#define KNH_ITRNEXT_Float(ctx, sfp, n, value) {\
		sfp[n].fvalue = value;\
		KNH_MOV(ctx, sfp[n].o, KNH_FLOAT0);\
		return; \
	}\

#define KNH_MAPPED(ctx, sfp, v) {\
		KNH_MOV(ctx, sfp[0].o, v);\
		sfp[0].data = ((Int*)v)->n.data;\
		return; \
	}\

#define KNH_MAPPED_Boolean(ctx, sfp, value) {\
		sfp[0].bvalue = value;\
		KNH_MOV(ctx, sfp[0].o, KNH_TRUE);\
		return; \
	}\

#define KNH_MAPPED_Int(ctx, sfp, value) {\
		sfp[0].ivalue = value;\
		KNH_MOV(ctx, sfp[0].o, KNH_INT0);\
		return; \
	}\

#define KNH_MAPPED_Float(ctx, sfp, value) {\
		sfp[0].fvalue = value;\
		KNH_MOV(ctx, sfp[0].o, KNH_FLOAT0);\
		return;\
	}\

/* ------------------------------------------------------------------------ */
/* [Context] */
/* ------------------------------------------------------------------------ */

typedef const struct knh_Context_t    Ctx;

#define KNH_TOBJECT_SIZE     4096
#define SIZEOF_TOBJECT       (sizeof(knh_Object_t) * KNH_TOBJECT_SIZE)

#define KNH_FASTMALLOC_SIZE  (sizeof(knh_Object_t) - sizeof(void*))
#define KNH_FASTMALLOC_BSIZE (KNH_FASTMALLOC_SIZE/sizeof(knh_Object_t*))

/* ------------------------------------------------------------------------ */

#define STRUCT_newid         ((knh_struct_t)-1)

#define SIZEOF_TSTRUCT    (KNH_TSTRUCT_SIZE * sizeof(knh_tStruct_t))

char *konoha_getStructName(Ctx *ctx, knh_struct_t sid);
#define STRUCTN(sid)   konoha_getStructName(ctx, sid)

#ifndef KNH_TSTRUCT_SIZE
#define KNH_TSTRUCT_SIZE 256
#endif

typedef void (*knh_ftraverse)(Ctx *ctx, Object *);
typedef knh_uint_t                knh_hcode_t;  /* knh_hcode_t */
#define knh_hcode_join(s1,s2)	   ((knh_hcode_t)s1 << (sizeof(knh_short_t)*8)) + s2;

typedef void        (*knh_fstruct_init)(Ctx *, Object *, int);
typedef void        (*knh_fstruct_traverse)(Ctx *, Object*, knh_ftraverse);
typedef int         (*knh_fstruct_compareTo)(Ctx *ctx, Object*, Object*);
typedef knh_hcode_t (*knh_fstruct_hashCode)(Ctx *ctx, Object *);
typedef Object*     (*knh_fstruct_copy)(Ctx *, Object *);
typedef void        (*knh_fstruct_newClass)(Ctx *ctx, knh_class_t cid);

typedef struct {
	knh_fstruct_traverse   ftraverse;
	knh_fstruct_compareTo  fcompareTo;
	knh_fstruct_init       finit;
	size_t                 size;
	knh_flag_t             flag;
	knh_struct_t           sid;
	knh_fstruct_hashCode   fhashCode;
	knh_fstruct_copy       fcopy;
	knh_fstruct_newClass   fnewClass;
	char                  *name;
} knh_tStruct_t ;

/* ------------------------------------------------------------------------ */

#ifndef KNH_TCLASS_SIZE
#define KNH_TCLASS_SIZE 1024
#endif

#define SIZEOF_TCLASS  (KNH_TCLASS_SIZE * sizeof(knh_tClass_t))

typedef knh_Object_t* (*knh_fdefault)(Ctx *ctx, knh_class_t cid);

typedef struct {
	knh_flag_t    cflag;   knh_flag_t    oflag;
	knh_class_t   bcid;    knh_class_t   supcid;
	knh_class_t   p1;      knh_type_t    p2;
	knh_ushort_t  offset;  knh_struct_t  sid;
	knh_ushort_t  size;    knh_ushort_t  bsize;
	union {
		knh_short_t   keyidx;
		knh_type_t    r0;
	};
	union {
		knh_short_t   keyidx2;
		knh_type_t    p3;
	};
	struct knh_String_t       *sname;
	struct knh_String_t       *lname;
	struct knh_Class_t        *class_cid;
	struct knh_ClassStruct_t  *cstruct;
	struct knh_ClassMap_t     *cmap;
	struct knh_Object_t       *cspec;
	knh_fdefault                  fdefault;
} knh_tClass_t;

/* ------------------------------------------------------------------------ */

#ifndef KNH_TEXPT_SIZE
#define KNH_TEXPT_SIZE (KNH_TCLASS_SIZE/4)
#endif

typedef struct {
	knh_flag_t   flag;
	knh_expt_t   parent;
	struct knh_String_t     *name;
} knh_tExpt_t;

#define SIZEOF_TEXPT  (KNH_TEXPT_SIZE * sizeof(knh_tExpt_t))

/* ------------------------------------------------------------------------ */

#ifndef KNH_TINT_MIN
#define KNH_TINT_MIN (-1)  /* @property */
#endif

#ifndef KNH_TINT_MAX
#ifdef KNH_FASTMODE
#define KNH_TINT_MAX 1024  /* @property */
#else
#define KNH_TINT_MAX 256  /* @property */
#endif
#endif

#define SIZEOF_TINT (sizeof(knh_Object_t*) * (KNH_TINT_MAX - KNH_TINT_MIN + 1))
#define SIZEOF_TSTRING (sizeof(knh_Object_t*) * KNH_TSTRING_SIZE)

#define knh_rootNameSpace     DP(ctx->sys)->ns
#define knh_systemEncoding    DP(ctx->sys)->enc

#define KNH_NULL            (ctx->constNull)
#define KNH_VOID            (ctx->constVoid)
#define KNH_TRUE            (ctx->constTrue)
#define KNH_FALSE           (ctx->constFalse)
#define KNH_SYSTEM          (ctx->sys)
#define KNH_INT0            (ctx->tInt[0 - KNH_TINT_MIN])
#define KNH_FLOAT0          (ctx->constFloat0)

/* ------------------------------------------------------------------------ */

typedef int knh_mutex_t;
typedef int (*knh_fmutexlock)(knh_mutex_t*);
typedef int (*knh_fmutexunlock)(knh_mutex_t*);

#define KNH_LOCK(ctx, lock)  (ctx->share)->flock(lock);
#define KNH_UNLOCK(ctx, lock)  (ctx->share)->funlock(lock);

/* ------------------------------------------------------------------------ */

typedef struct knh_ContextShare_t {
	size_t statUsedMemorySize;
	size_t statUsedObjectSize;
	size_t maxObjectTableSize;
	size_t tObjectTableSize;
	size_t tClassSize;
	size_t maxContextSize;
	size_t tContextSize;
	knh_struct_t tStructSize; knh_expt_t   tExptSize;
	/* 32bytes used until here*/
	knh_fmutexlock        flock;
	knh_fmutexunlock      funlock;
	knh_mutex_t           objectLock;
	knh_mutex_t           tableLock;
} knh_ContextShare_t ;

/* ------------------------------------------------------------------------ */

typedef struct knh_Context_t {
	knh_hObject_t h;
	knh_Object_t        *unusedObject;
	size_t               unusedObjectSize;

	/* stack */
	knh_sfp_t*                   stack;
	knh_sfp_t*                   ebp;
	size_t                       stacksize;

	/* root table */
	struct knh_Context_t *tContext;
	struct knh_ContextShare_t   *share;

	/* system table */
	knh_Object_t **tObjectTable;
	knh_tStruct_t  *tStruct;
	knh_tClass_t   *tClass;
	knh_tExpt_t    *tExpt;
//	struct knh_DictSet_t  *texptNameDictSet;

	/* system const */
	knh_Object_t   *constNull;
	knh_Object_t   *constVoid;
	knh_Object_t   *constTrue;
	knh_Object_t   *constFalse;
	struct knh_Int_t     **tInt;
	struct knh_Float_t    *constFloat0;
	struct knh_String_t  **tString;
	struct knh_System_t   *sys;

	knh_mutex_t           *objectLock;
	knh_mutex_t           *tableLock;

	knh_flag_t                   flag;
	knh_ushort_t                 ctxid;
	char*                        doing;
	struct knh_String_t*         enc;
	struct knh_InputStream_t*    in;
	struct knh_OutputStream_t*   out;
	struct knh_OutputStream_t*   err;
	struct knh_Bytes_t*          bufa;
	struct knh_OutputStream_t*   bufw;
	struct knh_Bytes_t*          bconvbuf;
	struct knh_DictMap_t*        props;
	struct knh_HashMap_t        *tmapperHashMap;
	struct knh_HashMap_t        *tmethodHashMap;
	struct knh_NameSpace_t      *ns;
	struct knh_DictMap_t        *tsymbolDictMap;
	struct knh_Asm_t            *cmpr;
	struct knh_Context_t        *parent;

} knh_Context_t ;

/* ------------------------------------------------------------------------ */

#define KONOHA_MAGIC        314159

typedef struct konoha_t {
	knh_uint_t  magic;
	Ctx *ctx;
} konoha_t ;

/* ------------------------------------------------------------------------ */

#define KONOHA_CHECK_(konoha) \
	if(konoha.magic != KONOHA_MAGIC) { \
		KNH_SAYS("This is not a Konoha Scripting Engine"); \
		return; \
	}\

#define KONOHA_CHECK(konoha, value) \
	if(konoha.magic != KONOHA_MAGIC) { \
		KNH_SAYS("This is not a Konoha Scripting Engine"); \
		return value; \
	}\

//typedef knh_uint_t                int;
//typedef knh_uint_t                knh_stackop_t;

/* ------------------------------------------------------------------------ */
/* KLRCode */
/* ------------------------------------------------------------------------ */

typedef struct {
	size_t pos;
	struct knh_Bytes_t          *ba;
	struct knh_OutputStream_t   *w;
} knh_wbuf_t;

/* ------------------------------------------------------------------------ */
/* Functions */
/* ------------------------------------------------------------------------ */

#ifdef _MSC_VER
typedef void   (KNH_CC_FASTCALL *knh_fmethod)(Ctx *, knh_sfp_t *);
#else
typedef METHOD (*knh_fmethod)(Ctx *, knh_sfp_t *);
#endif

#ifdef _MSC_VER
typedef void   (KNH_CC_FASTCALL *knh_fmapper)(Ctx *, knh_sfp_t *);
#else
typedef MAPPER (*knh_fmapper)(Ctx *, knh_sfp_t *);
#endif

typedef knh_ushort_t             knh_sline_t;


/* ======================================================================== */
/* driver */
/* ======================================================================== */

#define KNHINIT

typedef struct {
	int   type;
	char *name;
} knh_drvapi_t ;

#define KNH_DRVAPI_TYPE__UNKNOWN          0
#define KNH_DRVAPI_TYPE__BCONV            1
#define KNH_DRVAPI_TYPE__SCONV            2
#define KNH_DRVAPI_TYPE__IO               3
#define KNH_DRVAPI_TYPE__PARSER           4
#define KNH_DRVAPI_TYPE__REGEX            5
#define KNH_DRVAPI_TYPE__DB               6

#define IS_DRVAPI(c)   (0 < c && c < 7)

/* ------------------------------------------------------------------------ */
/* KNH_DRVAPI_TYPE__BYTECONV */

struct knh_BytesConv_t;
typedef size_t (*f_bconv)(Ctx *ctx, struct knh_BytesConv_t *o, knh_bytes_t t, struct knh_Bytes_t *ba);

typedef struct {
	int  type;
	char *name;
	f_bconv      fbconv;
	f_bconv      fbconv_inverse;
} knh_bconv_driapi_t;

/* ------------------------------------------------------------------------ */
/* KNH_DRVAPI_TYPE__IO */

typedef knh_int_t knh_io_t;

typedef knh_io_t (*f_io_open)(Ctx *ctx, struct knh_InputStream_t *in, struct knh_OutputStream_t *out, knh_bytes_t urn, char *mode);
typedef knh_int_t (*f_io_read)(Ctx *ctx, knh_io_t fd, char *buf, size_t bufsiz);
typedef knh_int_t (*f_io_write)(Ctx *ctx, knh_io_t fd, char *buf, size_t bufsiz);
typedef void   (*f_io_close)(Ctx *ctx, knh_io_t fd);

typedef struct {
	int type; char *name;
	size_t bufsiz;
	f_io_open    fopen;
	f_io_read    fread;
	f_io_write   fwrite;
	f_io_close   fclose;
} knh_iodrv_t;

/* ------------------------------------------------------------------------ */
/* KNH_DRVAPI_TYPE__PARSER */

typedef knh_Object_t* (*knh_fparser)(Ctx *, struct knh_String_t *p);

typedef struct {
	int   type;
	char *name;
	knh_type_t  rtype;
	knh_fparser parser;
} knh_parser_drvapi_t;

/* ------------------------------------------------------------------------ */
/* KNH_DRVAPI_TYPE__REGEX */

typedef void knh_regex_t;

#ifndef KNH_REGEX_NMATCH_SIZE
#define KNH_REGEX_NMATCH_SIZE    16
#endif

typedef struct {
	int rm_so;   /* start of match */
	int rm_eo;   /* endo of match */
	knh_bytes_t rm_name;  /* {NULL, 0}, if not NAMED */
} knh_regmatch_t;

typedef knh_regex_t* (*knh_fregmalloc)(Ctx *);
typedef int (*knh_fregcomp)(Ctx *, knh_regex_t *, char *pattern, int flags);
typedef int (*knh_fregexec)(Ctx *, knh_regex_t *, char *str, size_t nmatch, knh_regmatch_t p[], int flags);
typedef void (*knh_fregfree)(Ctx *, knh_regex_t *);

typedef struct {
	int  type;
	char *name;
	knh_fregmalloc regmalloc;
	knh_fregcomp   regcomp;
	knh_fregexec   regexec;
	knh_fregfree   regfree;
} knh_regex_drvapi_t;

/* ------------------------------------------------------------------------ */
/* KNH_DRVAPI_TYPE__DB */

typedef void   knh_db_t;
typedef void   knh_dbcur_t;
struct knh_ResultSet_t;
typedef knh_db_t* (*knh_fdbopen)(Ctx *ctx, knh_bytes_t url);
typedef knh_dbcur_t* (*knh_fdbquery)(Ctx *ctx, knh_db_t *, knh_bytes_t query, struct knh_ResultSet_t*);
typedef void   (*knh_fdbclose)(Ctx *ctx, knh_db_t *);

typedef int    (*knh_fdbcurnext)(Ctx *, knh_dbcur_t *, struct knh_ResultSet_t*);
typedef void   (*knh_fdbcurfree)(knh_dbcur_t *);

typedef struct {
	int  type;
	char *name;
	knh_fdbopen   dbopen;
	knh_fdbquery  dbquery;
	knh_fdbclose  dbclose;
	knh_fdbcurnext dbcurnext;
	knh_fdbcurfree dbcurfree;
} knh_db_drvapi_t;

/* ======================================================================== */
/* mutex */
/* ======================================================================== */


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

#endif /*KONOHA_T_H_*/
