/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"


/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ------------------------------------------------------------------------ */

#define _LRUMap                          HashMap
#define _knh_LRUMap                      knh_HashMap_struct

#define _new_LRUMap(ctx,n)               new_HashMap(ctx,n)
#define _knh_LRUMap_get(ctx,b,kh,ko)     knh_HashMap_get(ctx,b,kh,ko)
#define _knh_LRUMap_set(ctx,b,kh,ko,v)   knh_HashMap_set(ctx,b,kh,ko,v)

/* ------------------------------------------------------------------------ */

knh_hashmapentry_t *new_hashmapentry(Ctx *ctx, HashMap *o)
{
	knh_hashmapentry_t *e = DP(o)->unused;
	if(e != NULL) {
		DP(o)->unused = e->next;
		return e;
	}
	else if(DP(o)->table_size == 0) {
		TODO();
		KNH_ABORT();
//		knh_HashMap_init(ctx, DP(o), KNH_HASHMAP_INITSIZE, NULL);
//		e = DP(o)->unused;
//		DP(o)->unused = e->next;
		return e;
	}
	else {
		knh_HashMap_struct *b = DP(o);
		knh_hashmapentry_t *newtable = (knh_hashmapentry_t*)KNH_MALLOC(ctx, sizeof(knh_hashmapentry_t) * b->table_size);
		size_t i;
		for(i = 0; i < b->table_size; i++) {
			newtable[i].hcode = 0;
			newtable[i].key = NULL;
			newtable[i].value = NULL;
			newtable[i].next = (i == b->table_size - 1) ? NULL : &(newtable[i+1]);
		}
		e = &(newtable[0]);
		b->unused = &(newtable[1]);

		if(b->ex_size  == b->ex_capacity) {
			if(b->ex_capacity == 0) {
				b->ex_capacity = 8;
				b->ex_tables = (knh_hashmapentry_t**)KNH_MALLOC(ctx, sizeof(knh_hashmapentry_t*) * b->ex_capacity);
			}
			else {
				b->ex_capacity *= 2;
				knh_hashmapentry_t **newtbll = (knh_hashmapentry_t**)KNH_MALLOC(ctx, sizeof(knh_hashmapentry_t*) * b->ex_capacity);
				knh_memcpy(newtbll, b->ex_tables, sizeof(knh_hashmapentry_t*) * b->ex_size);
				KNH_FREE(ctx, b->ex_tables, sizeof(knh_hashmapentry_t*) * b->ex_size);
				b->ex_tables = newtbll;
			}
		}
		b->ex_tables[b->ex_size] = newtable;
		b->ex_size++;

		if(b->ex_size * (b->table_size+1) > b->capacity) {
			size_t nc = b->capacity * 2 + 1;
			knh_hashmapentry_t **newarray = (knh_hashmapentry_t**)KNH_MALLOC(ctx, sizeof(knh_hashmapentry_t*) * nc);
			knh_bzero(newarray, sizeof(knh_hashmapentry_t*) * nc);

			size_t i, j;
			knh_hashmapentry_t *t = b->table;
			for(i = 0; i < b->table_size; i++) {
				knh_uint_t h = t[i].hcode % nc;
				t[i].next = newarray[h];
				newarray[h] = &(t[i]);
			}
			for(j = 0; j < b->ex_size - 1; j++) {
				t = b->ex_tables[j];
				for(i = 0; i < b->table_size; i++) {
					knh_uint_t h = t[i].hcode % nc;
					t[i].next = newarray[h];
					newarray[h] = &(t[i]);
				}
			}
			KNH_FREE(ctx, b->array, sizeof(knh_hashmapentry_t*) * b->capacity);
			b->array = newarray;
			b->capacity = nc;
		}
		return e;
	}
}

/* ------------------------------------------------------------------------ */

size_t knh_hashmapentry_capacity(Ctx *ctx, HashMap *o)
{
	return DP(o)->table_size * (DP(o)->ex_size + 1);
}

/* ------------------------------------------------------------------------ */

knh_hashmapentry_t *knh_hashmapentry_at(HashMap *o, size_t n)
{
	KNH_ASSERT(DP(o)->table_size > 0);
	if(n < DP(o)->table_size) {
		if(DP(o)->table[n].key == NULL) {
			return NULL;
		}
		else {
			return &(DP(o)->table[n]);
		}
	}
	else {
		KNH_ASSERT(DP(o)->ex_tables != NULL);
		int i = (n % DP(o)->table_size);
		int j = (n / DP(o)->table_size) - 1;
//		DBG2_P("table_size=%d, j=%d, i=%d", DP(o)->table_size, j, i);
		knh_hashmapentry_t *e = DP(o)->ex_tables[j] + i;
		if(e->key == NULL) return NULL;
		return e;
	}
}

/* ======================================================================== */
/* [constructors] */

HashMap* new_HashMap(Ctx *ctx, char *name, size_t capacity)
{
	if(capacity == 0) capacity = KNH_HASHMAP_INITSIZE;
	HashMap* o = (HashMap*)new_Object_bcid(ctx, CLASS_HashMap, capacity);
	if(name != NULL) {
		DP(o)->DBG_name = name;
	}
	return o;
}

/* ======================================================================== */
/* [methods] */

Object *knh_HashMap_get__hcode(Ctx *ctx, HashMap *o, knh_hcode_t hcode)
{
	knh_uint_t h = hcode % DP(o)->capacity;
	knh_hashmapentry_t *cur = DP(o)->array[h];
	while(cur != NULL) {
		if(cur->hcode == hcode) {
			return cur->value;
		}
		cur = cur->next;
	}
	return KNH_NULL;
}

/* ------------------------------------------------------------------------ */

void knh_HashMap_set__hcode(Ctx *ctx, HashMap *o, knh_hcode_t hcode, Any *value)
{
	knh_uint_t h = hcode % DP(o)->capacity;
	knh_hashmapentry_t *cur = DP(o)->array[h];
	while(cur != NULL) {
		if(cur->hcode == hcode) {
			KNH_SETv(ctx, cur->value, value);
			return;
		}
		cur = cur->next;
	}
	cur = new_hashmapentry(ctx, o);
	cur->hcode = hcode;
	KNH_INITv(cur->key, KNH_NULL);
	KNH_INITv(cur->value, value);
	cur->next = DP(o)->array[h];
	DP(o)->array[h] = cur;
	DP(o)->size++;
}

/* ------------------------------------------------------------------------ */

void knh_HashMap_remove__hcode(Ctx *ctx, HashMap *o, knh_hcode_t hcode)
{
	knh_uint_t h = hcode % DP(o)->capacity;
	knh_hashmapentry_t *cur = DP(o)->array[h];
	knh_hashmapentry_t **prev_next = &(DP(o)->array[h]);
	while(cur != NULL) {
		if(cur->hcode == hcode) {
			prev_next[0] = cur->next;
			cur->next = DP(o)->unused;
			DP(o)->unused = cur;
			cur->hcode = 0;
			cur->key = NULL;
			cur->value = NULL;
			DP(o)->size--;
			return ;
		}
		prev_next = &(cur->next);
		cur = cur->next;
	}
}

///* ------------------------------------------------------------------------ */
///* @method void HashMap.clear() */
//
//void knh_HashMap_clear(Ctx *ctx, HashMap *o)
//{
//	int init = DP(o)->capacity;
//	knh_HashMap_traverse(ctx, DP(o), knh_Object_sweep);
//	knh_HashMap_init(ctx, DP(o), init, NULL);
//}


/* ------------------------------------------------------------------------ */


#ifdef __cplusplus
}
#endif
