/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#include<konoha/konoha_dev.h>
#include<konoha/gen/konohac_klr_.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ------------------------------------------------------------------------ */

#ifdef __GNUC__
#define NPC
#ifdef _HERE_
#undef _HERE_ 
#endif
#define _HERE_ NULL, 0
#define JUMP *(0xdeadbeef)

static const *pc = NULL;

METHOD codetemplate(Ctx *ctx, knh_sfp_t *sfp)
{
	static void *OPJUMP[] = {
		&&L_HALT,
		&&L_MOVA,
		&&L_MOVN,
		&&L_MOVO,
		&&L_MOVX,
		&&L_MOVDEF,
		&&L_MOVSYS,
		&&L_XMOVS,
		&&L_XMOVO,
		&&L_XMOVX,
		&&L_XMOVDEF,
		&&L_XMOVSYS,
		&&L_SWAP,
		&&L_PINIO,
		&&L_SETEBP,
		&&L_CHECKEBP,
		&&L_RET,
		&&L_RETN,
		&&L_RETA,
		&&L_RETO,
		&&L_RETX,
		&&L_BOX,
		&&L_BOXNC,
		&&L_NNBOX,
		&&L_NNBOXNC,
		&&L_UNBOX,
		&&L_ISNULL,
		&&L_ISNULLX,
		&&L_ISTYPE,
		&&L_ISNNTYPE,
		&&L_FCALL,
		&&L_SCALL,
		&&L_CALL,
		&&L_ACALL,
		&&L_NEW,
		&&L_TOSTR,
		&&L_TOSTRF,
		&&L_SMAP,
		&&L_SMAPNC,
		&&L_MAP,
		&&L_MAPNC,
		&&L_AMAP,
		&&L_NNMAP,
		&&L_JMP,
		&&L_BJIFT,
		&&L_BJIFF,
		&&L_BJIFF_LOOP,
		&&L_JIFNUL,
		&&L_JIFNN,
		&&L_NEXT,
		&&L_INEXT,
		&&L_MAPNEXT,
		&&L_SMAPNEXT,
		&&L_TRY,
		&&L_TRYEND,
		&&L_CATCH,
		&&L_THROW,
		&&L_THROWS,
		&&L_THROW_AGAIN,
		&&L_P,
		&&L_PMSG,
		&&L_ICAST,
		&&L_INCAST,
		&&L_FCAST,
		&&L_FNCAST,
		&&L_BNOT,
		&&L_INEG,
		&&L_IADD,
		&&L_IADDN,
		&&L_ISUB,
		&&L_ISUBN,
		&&L_IMUL,
		&&L_IMULN,
		&&L_IDIV,
		&&L_IDIVN,
		&&L_IMOD,
		&&L_IMODN,
		&&L_IEQ,
		&&L_IEQN,
		&&L_INEQ,
		&&L_INEQN,
		&&L_ILT,
		&&L_ILTN,
		&&L_ILTE,
		&&L_ILTEN,
		&&L_IGT,
		&&L_IGTN,
		&&L_IGTE,
		&&L_IGTEN,
		&&L_FNEG,
		&&L_FADD,
		&&L_FADDN,
		&&L_FSUB,
		&&L_FSUBN,
		&&L_FMUL,
		&&L_FMULN,
		&&L_FDIV,
		&&L_FDIVN,
		&&L_FEQ,
		&&L_FEQN,
		&&L_FNEQ,
		&&L_FNEQN,
		&&L_FLT,
		&&L_FLTN,
		&&L_FLTE,
		&&L_FLTEN,
		&&L_FGT,
		&&L_FGTN,
		&&L_FGTE,
		&&L_FGTEN,
		&&L_INITCODE,
		&&L_NOP,
	};
	

	L_HALT:; {
		KLR_HALT(ctx);
	}

	L_MOVA:; {
		KLR_MOVa(ctx, 100, 200);
	}

	L_MOVN:; {
		KLR_MOVn(ctx, 100, 200);
	}

	L_MOVO:; {
		KLR_MOVo(ctx, 100, (Object*)200);
	}

	L_MOVX:; {
		const knh_sfx_t x2 = {200, 300};
		KLR_MOVx(ctx, 100, x2);
	}

	L_MOVDEF:; {
		KLR_MOVDEF(ctx, 100, 200);
	}

	L_MOVSYS:; {
		KLR_MOVSYS(ctx, 100, 200);
	}

	L_XMOVS:; {
		const knh_sfx_t x1 = {100, 200};
		KLR_XMOVs(ctx, x1, 300);
	}

	L_XMOVO:; {
		const knh_sfx_t x1 = {100, 200};
		KLR_XMOVo(ctx, x1, (Object*)300);
	}

	L_XMOVX:; {
		const knh_sfx_t x3 = {300, 400};
		const knh_sfx_t x1 = {100, 200};
		KLR_XMOVx(ctx, x1, x3);
	}

	L_XMOVDEF:; {
		const knh_sfx_t x1 = {100, 200};
		KLR_XMOVDEF(ctx, x1, 300);
	}

	L_XMOVSYS:; {
		const knh_sfx_t x1 = {100, 200};
		KLR_XMOVSYS(ctx, x1, 300);
	}

	L_SWAP:; {
		KLR_SWAP(ctx, 100, 200);
	}

	L_PINIO:; {
		KLR_PINIo(ctx, 100, (Object*)200);
	}

	L_SETEBP:; {
		KLR_SETEBP(ctx, 100);
	}

	L_CHECKEBP:; {
		KLR_CHECKEBP(ctx, 100);
	}

	L_RET:; {
		KLR_RET(ctx);
	}

	L_RETN:; {
		KLR_RETn(ctx, 100, 200);
	}

	L_RETA:; {
		KLR_RETa(ctx, 100, 200);
	}

	L_RETO:; {
		KLR_RETo(ctx, 100, (Object*)200);
	}

	L_RETX:; {
		const knh_sfx_t x2 = {200, 300};
		KLR_RETx(ctx, 100, x2);
	}

	L_BOX:; {
		KLR_BOX(ctx, 100, 200);
	}

	L_BOXNC:; {
		KLR_BOXnc(ctx, 100, 200);
	}

	L_NNBOX:; {
		KLR_NNBOX(ctx, 100, 200);
	}

	L_NNBOXNC:; {
		KLR_NNBOXnc(ctx, 100, 200);
	}

	L_UNBOX:; {
		KLR_UNBOX(ctx, 100);
	}

	L_ISNULL:; {
		KLR_ISNULL(ctx, 100);
	}

	L_ISNULLX:; {
		const knh_sfx_t x1 = {100, 200};
		KLR_ISNULLx(ctx, x1);
	}

	L_ISTYPE:; {
		KLR_ISTYPE(ctx, 100, 200);
	}

	L_ISNNTYPE:; {
		KLR_ISNNTYPE(ctx, 100, 200);
	}

	L_FCALL:; {
		KLR_FCALL(ctx, 100, 200, 300, 400);
	}

	L_SCALL:; {
		KLR_SCALL(ctx, 100, 200, 300);
	}

	L_CALL:; {
		KLR_CALL(ctx, 100, 200, 300);
	}

	L_ACALL:; {
		KLR_ACALL(ctx, 100, 200, 300, 400);
	}

	L_NEW:; {
		KLR_NEW(ctx, 100, 200, 300, 400, 500);
	}

	L_TOSTR:; {
		KLR_TOSTR(ctx, 100, 200);
	}

	L_TOSTRF:; {
		KLR_TOSTRf(ctx, 100, 200, (Object*)300);
	}

	L_SMAP:; {
		KLR_SMAP(ctx, 100, 200);
	}

	L_SMAPNC:; {
		KLR_SMAPnc(ctx, 100, 200);
	}

	L_MAP:; {
		KLR_MAP(ctx, 100, 200);
	}

	L_MAPNC:; {
		KLR_MAPnc(ctx, 100, 200);
	}

	L_AMAP:; {
		KLR_AMAP(ctx, 100, 200);
	}

	L_NNMAP:; {
		KLR_NNMAP(ctx, 100, 200);
	}

	L_JMP:; {
		KLR_JMP(ctx, NPC, JUMP);
	}

	L_BJIFT:; {
		KLR_bJIFT(ctx, NPC, JUMP, 200);
	}

	L_BJIFF:; {
		KLR_bJIFF(ctx, NPC, JUMP, 200);
	}

	L_BJIFF_LOOP:; {
		KLR_bJIFF_LOOP(ctx, NPC, JUMP, 200);
	}

	L_JIFNUL:; {
		KLR_JIFNUL(ctx, NPC, JUMP, 200);
	}

	L_JIFNN:; {
		KLR_JIFNN(ctx, NPC, JUMP, 200);
	}

	L_NEXT:; {
		KLR_NEXT(ctx, NPC, JUMP, 200, 300, 400);
	}

	L_INEXT:; {
		KLR_INEXT(ctx, NPC, JUMP, 200, 300, 400, 500);
	}

	L_MAPNEXT:; {
		KLR_MAPNEXT(ctx, NPC, JUMP, 200, 300, 400, 500);
	}

	L_SMAPNEXT:; {
		KLR_SMAPNEXT(ctx, NPC, JUMP, 200, 300, 400, (Object*)500);
	}

	L_TRY:; {
		KLR_TRY(ctx, NPC, JUMP, 200);
	}

	L_TRYEND:; {
		KLR_TRYEND(ctx, 100);
	}

	L_CATCH:; {
		KLR_CATCH(ctx, NPC, JUMP, 200, 300, (Object*)400);
	}

	L_THROW:; {
		KLR_THROW(ctx, 100);
	}

	L_THROWS:; {
		KLR_THROWs(ctx, (Object*)100);
	}

	L_THROW_AGAIN:; {
		KLR_THROW_AGAIN(ctx, 100);
	}

	L_P:; {
		KLR_P(ctx, 100, 200, 300);
	}

	L_PMSG:; {
		KLR_PMSG(ctx, 100, (Object*)200);
	}

	L_ICAST:; {
		KLR_iCAST(ctx, 100);
	}

	L_INCAST:; {
		KLR_inCAST(ctx, 100);
	}

	L_FCAST:; {
		KLR_fCAST(ctx, 100);
	}

	L_FNCAST:; {
		KLR_fnCAST(ctx, 100);
	}

	L_BNOT:; {
		KLR_bNOT(ctx, 100, 200);
	}

	L_INEG:; {
		KLR_iNEG(ctx, 100, 200);
	}

	L_IADD:; {
		KLR_iADD(ctx, 100, 200, 300);
	}

	L_IADDN:; {
		KLR_iADDn(ctx, 100, 200, 300);
	}

	L_ISUB:; {
		KLR_iSUB(ctx, 100, 200, 300);
	}

	L_ISUBN:; {
		KLR_iSUBn(ctx, 100, 200, 300);
	}

	L_IMUL:; {
		KLR_iMUL(ctx, 100, 200, 300);
	}

	L_IMULN:; {
		KLR_iMULn(ctx, 100, 200, 300);
	}

	L_IDIV:; {
		KLR_iDIV(ctx, 100, 200, 300);
	}

	L_IDIVN:; {
		KLR_iDIVn(ctx, 100, 200, 300);
	}

	L_IMOD:; {
		KLR_iMOD(ctx, 100, 200, 300);
	}

	L_IMODN:; {
		KLR_iMODn(ctx, 100, 200, 300);
	}

	L_IEQ:; {
		KLR_iEQ(ctx, 100, 200, 300);
	}

	L_IEQN:; {
		KLR_iEQn(ctx, 100, 200, 300);
	}

	L_INEQ:; {
		KLR_iNEQ(ctx, 100, 200, 300);
	}

	L_INEQN:; {
		KLR_iNEQn(ctx, 100, 200, 300);
	}

	L_ILT:; {
		KLR_iLT(ctx, 100, 200, 300);
	}

	L_ILTN:; {
		KLR_iLTn(ctx, 100, 200, 300);
	}

	L_ILTE:; {
		KLR_iLTE(ctx, 100, 200, 300);
	}

	L_ILTEN:; {
		KLR_iLTEn(ctx, 100, 200, 300);
	}

	L_IGT:; {
		KLR_iGT(ctx, 100, 200, 300);
	}

	L_IGTN:; {
		KLR_iGTn(ctx, 100, 200, 300);
	}

	L_IGTE:; {
		KLR_iGTE(ctx, 100, 200, 300);
	}

	L_IGTEN:; {
		KLR_iGTEn(ctx, 100, 200, 300);
	}

	L_FNEG:; {
		KLR_fNEG(ctx, 100, 200);
	}

	L_FADD:; {
		KLR_fADD(ctx, 100, 200, 300);
	}

	L_FADDN:; {
		KLR_fADDn(ctx, 100, 200, 300);
	}

	L_FSUB:; {
		KLR_fSUB(ctx, 100, 200, 300);
	}

	L_FSUBN:; {
		KLR_fSUBn(ctx, 100, 200, 300);
	}

	L_FMUL:; {
		KLR_fMUL(ctx, 100, 200, 300);
	}

	L_FMULN:; {
		KLR_fMULn(ctx, 100, 200, 300);
	}

	L_FDIV:; {
		KLR_fDIV(ctx, 100, 200, 300);
	}

	L_FDIVN:; {
		KLR_fDIVn(ctx, 100, 200, 300);
	}

	L_FEQ:; {
		KLR_fEQ(ctx, 100, 200, 300);
	}

	L_FEQN:; {
		KLR_fEQn(ctx, 100, 200, 300);
	}

	L_FNEQ:; {
		KLR_fNEQ(ctx, 100, 200, 300);
	}

	L_FNEQN:; {
		KLR_fNEQn(ctx, 100, 200, 300);
	}

	L_FLT:; {
		KLR_fLT(ctx, 100, 200, 300);
	}

	L_FLTN:; {
		KLR_fLTn(ctx, 100, 200, 300);
	}

	L_FLTE:; {
		KLR_fLTE(ctx, 100, 200, 300);
	}

	L_FLTEN:; {
		KLR_fLTEn(ctx, 100, 200, 300);
	}

	L_FGT:; {
		KLR_fGT(ctx, 100, 200, 300);
	}

	L_FGTN:; {
		KLR_fGTn(ctx, 100, 200, 300);
	}

	L_FGTE:; {
		KLR_fGTE(ctx, 100, 200, 300);
	}

	L_FGTEN:; {
		KLR_fGTEn(ctx, 100, 200, 300);
	}

	L_INITCODE:; {
		KLR_INITCODE(ctx, 100);
	}

	L_NOP:; {
		KLR_NOP(ctx);
	}

}
#endif


METHOD code_HALT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_HALT(ctx);
}


METHOD code_MOVA(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_MOVa(ctx, 100, 200);
}


METHOD code_MOVN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_MOVn(ctx, 100, 200);
}


METHOD code_MOVO(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_MOVo(ctx, 100, (Object*)200);
}


METHOD code_MOVX(Ctx *ctx, knh_sfp_t *sfp)
{
	const knh_sfx_t x2 = {200, 300};
		KLR_MOVx(ctx, 100, x2);
}


METHOD code_MOVDEF(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_MOVDEF(ctx, 100, 200);
}


METHOD code_MOVSYS(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_MOVSYS(ctx, 100, 200);
}


METHOD code_XMOVS(Ctx *ctx, knh_sfp_t *sfp)
{
	const knh_sfx_t x1 = {100, 200};
		KLR_XMOVs(ctx, x1, 300);
}


METHOD code_XMOVO(Ctx *ctx, knh_sfp_t *sfp)
{
	const knh_sfx_t x1 = {100, 200};
		KLR_XMOVo(ctx, x1, (Object*)300);
}


METHOD code_XMOVX(Ctx *ctx, knh_sfp_t *sfp)
{
	const knh_sfx_t x3 = {300, 400};
		const knh_sfx_t x1 = {100, 200};
		KLR_XMOVx(ctx, x1, x3);
}


METHOD code_XMOVDEF(Ctx *ctx, knh_sfp_t *sfp)
{
	const knh_sfx_t x1 = {100, 200};
		KLR_XMOVDEF(ctx, x1, 300);
}


METHOD code_XMOVSYS(Ctx *ctx, knh_sfp_t *sfp)
{
	const knh_sfx_t x1 = {100, 200};
		KLR_XMOVSYS(ctx, x1, 300);
}


METHOD code_SWAP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_SWAP(ctx, 100, 200);
}


METHOD code_PINIO(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_PINIo(ctx, 100, (Object*)200);
}


METHOD code_SETEBP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_SETEBP(ctx, 100);
}


METHOD code_CHECKEBP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_CHECKEBP(ctx, 100);
}


METHOD code_RET(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_RET(ctx);
}


METHOD code_RETN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_RETn(ctx, 100, 200);
}


METHOD code_RETA(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_RETa(ctx, 100, 200);
}


METHOD code_RETO(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_RETo(ctx, 100, (Object*)200);
}


METHOD code_RETX(Ctx *ctx, knh_sfp_t *sfp)
{
	const knh_sfx_t x2 = {200, 300};
		KLR_RETx(ctx, 100, x2);
}


METHOD code_BOX(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_BOX(ctx, 100, 200);
}


METHOD code_BOXNC(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_BOXnc(ctx, 100, 200);
}


METHOD code_NNBOX(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_NNBOX(ctx, 100, 200);
}


METHOD code_NNBOXNC(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_NNBOXnc(ctx, 100, 200);
}


METHOD code_UNBOX(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_UNBOX(ctx, 100);
}


METHOD code_ISNULL(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_ISNULL(ctx, 100);
}


METHOD code_ISNULLX(Ctx *ctx, knh_sfp_t *sfp)
{
	const knh_sfx_t x1 = {100, 200};
		KLR_ISNULLx(ctx, x1);
}


METHOD code_ISTYPE(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_ISTYPE(ctx, 100, 200);
}


METHOD code_ISNNTYPE(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_ISNNTYPE(ctx, 100, 200);
}


METHOD code_FCALL(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_FCALL(ctx, 100, 200, 300, 400);
}


METHOD code_SCALL(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_SCALL(ctx, 100, 200, 300);
}


METHOD code_CALL(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_CALL(ctx, 100, 200, 300);
}


METHOD code_ACALL(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_ACALL(ctx, 100, 200, 300, 400);
}


METHOD code_NEW(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_NEW(ctx, 100, 200, 300, 400, 500);
}


METHOD code_TOSTR(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_TOSTR(ctx, 100, 200);
}


METHOD code_TOSTRF(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_TOSTRf(ctx, 100, 200, (Object*)300);
}


METHOD code_SMAP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_SMAP(ctx, 100, 200);
}


METHOD code_SMAPNC(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_SMAPnc(ctx, 100, 200);
}


METHOD code_MAP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_MAP(ctx, 100, 200);
}


METHOD code_MAPNC(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_MAPnc(ctx, 100, 200);
}


METHOD code_AMAP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_AMAP(ctx, 100, 200);
}


METHOD code_NNMAP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_NNMAP(ctx, 100, 200);
}


METHOD code_JMP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_JMP(ctx, NPC, JUMP);
}


METHOD code_BJIFT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_bJIFT(ctx, NPC, JUMP, 200);
}


METHOD code_BJIFF(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_bJIFF(ctx, NPC, JUMP, 200);
}


METHOD code_BJIFF_LOOP(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_bJIFF_LOOP(ctx, NPC, JUMP, 200);
}


METHOD code_JIFNUL(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_JIFNUL(ctx, NPC, JUMP, 200);
}


METHOD code_JIFNN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_JIFNN(ctx, NPC, JUMP, 200);
}


METHOD code_NEXT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_NEXT(ctx, NPC, JUMP, 200, 300, 400);
}


METHOD code_INEXT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_INEXT(ctx, NPC, JUMP, 200, 300, 400, 500);
}


METHOD code_MAPNEXT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_MAPNEXT(ctx, NPC, JUMP, 200, 300, 400, 500);
}


METHOD code_SMAPNEXT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_SMAPNEXT(ctx, NPC, JUMP, 200, 300, 400, (Object*)500);
}


METHOD code_TRY(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_TRY(ctx, NPC, JUMP, 200);
}


METHOD code_TRYEND(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_TRYEND(ctx, 100);
}


METHOD code_CATCH(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_CATCH(ctx, NPC, JUMP, 200, 300, (Object*)400);
}


METHOD code_THROW(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_THROW(ctx, 100);
}


METHOD code_THROWS(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_THROWs(ctx, (Object*)100);
}


METHOD code_THROW_AGAIN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_THROW_AGAIN(ctx, 100);
}


METHOD code_P(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_P(ctx, 100, 200, 300);
}


METHOD code_PMSG(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_PMSG(ctx, 100, (Object*)200);
}


METHOD code_ICAST(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iCAST(ctx, 100);
}


METHOD code_INCAST(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_inCAST(ctx, 100);
}


METHOD code_FCAST(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fCAST(ctx, 100);
}


METHOD code_FNCAST(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fnCAST(ctx, 100);
}


METHOD code_BNOT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_bNOT(ctx, 100, 200);
}


METHOD code_INEG(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iNEG(ctx, 100, 200);
}


METHOD code_IADD(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iADD(ctx, 100, 200, 300);
}


METHOD code_IADDN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iADDn(ctx, 100, 200, 300);
}


METHOD code_ISUB(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iSUB(ctx, 100, 200, 300);
}


METHOD code_ISUBN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iSUBn(ctx, 100, 200, 300);
}


METHOD code_IMUL(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iMUL(ctx, 100, 200, 300);
}


METHOD code_IMULN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iMULn(ctx, 100, 200, 300);
}


METHOD code_IDIV(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iDIV(ctx, 100, 200, 300);
}


METHOD code_IDIVN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iDIVn(ctx, 100, 200, 300);
}


METHOD code_IMOD(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iMOD(ctx, 100, 200, 300);
}


METHOD code_IMODN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iMODn(ctx, 100, 200, 300);
}


METHOD code_IEQ(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iEQ(ctx, 100, 200, 300);
}


METHOD code_IEQN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iEQn(ctx, 100, 200, 300);
}


METHOD code_INEQ(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iNEQ(ctx, 100, 200, 300);
}


METHOD code_INEQN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iNEQn(ctx, 100, 200, 300);
}


METHOD code_ILT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iLT(ctx, 100, 200, 300);
}


METHOD code_ILTN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iLTn(ctx, 100, 200, 300);
}


METHOD code_ILTE(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iLTE(ctx, 100, 200, 300);
}


METHOD code_ILTEN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iLTEn(ctx, 100, 200, 300);
}


METHOD code_IGT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iGT(ctx, 100, 200, 300);
}


METHOD code_IGTN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iGTn(ctx, 100, 200, 300);
}


METHOD code_IGTE(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iGTE(ctx, 100, 200, 300);
}


METHOD code_IGTEN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_iGTEn(ctx, 100, 200, 300);
}


METHOD code_FNEG(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fNEG(ctx, 100, 200);
}


METHOD code_FADD(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fADD(ctx, 100, 200, 300);
}


METHOD code_FADDN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fADDn(ctx, 100, 200, 300);
}


METHOD code_FSUB(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fSUB(ctx, 100, 200, 300);
}


METHOD code_FSUBN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fSUBn(ctx, 100, 200, 300);
}


METHOD code_FMUL(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fMUL(ctx, 100, 200, 300);
}


METHOD code_FMULN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fMULn(ctx, 100, 200, 300);
}


METHOD code_FDIV(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fDIV(ctx, 100, 200, 300);
}


METHOD code_FDIVN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fDIVn(ctx, 100, 200, 300);
}


METHOD code_FEQ(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fEQ(ctx, 100, 200, 300);
}


METHOD code_FEQN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fEQn(ctx, 100, 200, 300);
}


METHOD code_FNEQ(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fNEQ(ctx, 100, 200, 300);
}


METHOD code_FNEQN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fNEQn(ctx, 100, 200, 300);
}


METHOD code_FLT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fLT(ctx, 100, 200, 300);
}


METHOD code_FLTN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fLTn(ctx, 100, 200, 300);
}


METHOD code_FLTE(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fLTE(ctx, 100, 200, 300);
}


METHOD code_FLTEN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fLTEn(ctx, 100, 200, 300);
}


METHOD code_FGT(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fGT(ctx, 100, 200, 300);
}


METHOD code_FGTN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fGTn(ctx, 100, 200, 300);
}


METHOD code_FGTE(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fGTE(ctx, 100, 200, 300);
}


METHOD code_FGTEN(Ctx *ctx, knh_sfp_t *sfp)
{
	KLR_fGTEn(ctx, 100, 200, 300);
}


#ifdef __cplusplus
}
#endif
