/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [structs] */

void
knh_MethodField_struct_init(Ctx *ctx, knh_MethodField_struct *b, int init, Object *cs)
{
	int i;
	b->flag = 0;
	b->size = (size_t)knh_int_min(init, 255);
	b->params = (knh_mfield_t*)KNH_MALLOC(ctx, b->size * sizeof(knh_mfield_t));
	for(i = 0; i < b->size; i++) {
		b->params[i].type = TYPE_any;
		b->params[i].fn   = FIELDN_NONAME;
	}
}

/* ------------------------------------------------------------------------ */

void knh_MethodField_struct_copy(Ctx *ctx, knh_MethodField_struct *b, knh_MethodField_struct *b2)
{
	int i;
	b2->size  =  b->size;
	b2->params = (knh_mfield_t*)KNH_MALLOC(ctx, b2->size * sizeof(knh_mfield_t));
	for(i = 0; i < b2->size; i++) {
		b2->params[i].type = b->params[i].type;
		b2->params[i].fn   = b->params[i].fn;
	}
}

///* ------------------------------------------------------------------------ */
//
//int knh_MethodField_struct_compare(knh_MethodField_struct *b, knh_MethodField_struct *b2)
//{
//	int i, res = b->size < b2->size;
//	if(res != 0) return res;
//	res = b->flag - b2->flag;
//	if(res != 0) return res;
//	for(i = 0; i < b->size; i++) {
//		res = b->params[i].type - b2->params[i].type;
//		if(res != 0) return res;
//		res = b->params[i].fn - b2->params[i].fn;
//		if(res != 0) return res;
//	}
//	return 0;
//}

/* ------------------------------------------------------------------------ */

void knh_MethodField_struct_traverse(Ctx *ctx, knh_MethodField_struct *b, knh_ftraverse gc)
{
	if(IS_SWEEP(gc)) {
		KNH_FREE(ctx, b->params, b->size * sizeof(knh_mfield_t));
	}
}

/* ======================================================================== */
/* [constructors] */

MethodField* new_MethodField(Ctx *ctx, knh_flag_t flag, size_t size)
{
	knh_MethodField_t* o =
		(MethodField*)new_Object_malloc(ctx, FLAG_MethodField, CLASS_MethodField, sizeof(knh_MethodField_struct));
	knh_MethodField_struct_init(ctx, DP(o), size, NULL);
	DP(o)->flag = flag & KNH_FLAG_MF_VARARGS;
	return o;
}

/* ======================================================================== */
/* [hcode] */

static
knh_hcode_t knh_methodfield_hcode(knh_type_t r, knh_type_t a0, knh_type_t a1)
{
	return (r + a0) + (a1 << 4);
}

/* ------------------------------------------------------------------------ */

knh_hcode_t knh_MethodField_hcode(MethodField *o)
{
	switch(DP(o)->size) {
		case 0: return knh_methodfield_hcode(0, 0, 0);
		case 1: return knh_methodfield_hcode(DP(o)->params[0].type, 0, 0);
		case 2: return knh_methodfield_hcode(DP(o)->params[0].type, DP(o)->params[1].type, 0);
	}
	return knh_methodfield_hcode(DP(o)->params[0].type, DP(o)->params[1].type, DP(o)->params[2].type);
}


/* ======================================================================== */
/* [flag] */

void knh_MethodField_setVarArgs(MethodField *o)
{
#ifdef MF_VARARGS
	DP(o)->flag |= MF_VARARGS;
#endif
}

/* ------------------------------------------------------------------------ */

knh_bool_t knh_MethodField_isVarArgs(MethodField *o)
{
#ifdef MF_VARARGS
	return ((DP(o)->flag & MF_VARARGS) == MF_VARARGS);
#endif
	return 0;
}

/* ======================================================================== */
/* [param] */

knh_type_t knh_MethodField_rztype(MethodField *o)
{
	return DP(o)->params[0].type;
}

#define _knh_Method_rtype(mtd)          knh_MethodField_rztype(knh_Method_mf(mtd))

/* ------------------------------------------------------------------------ */

size_t knh_MethodField_psize(MethodField *o)
{
	return DP(o)->size - 1;
}

#define _knh_Method_psize(mtd)      knh_MethodField_psize(knh_Method_mf(mtd))

/* ------------------------------------------------------------------------ */

knh_type_t knh_MethodField_pztype(MethodField *o, size_t n)
{
	if(n < (size_t)DP(o)->size - 1) {
		return DP(o)->params[n+1].type;
	}
	return DP(o)->params[DP(o)->size-1].type;
}

#define _knh_Method_ptype(mtd,n)          knh_MethodField_pztype(knh_Method_mf(mtd),n)

/* ------------------------------------------------------------------------ */

knh_mfield_t knh_MethodField_pfields(MethodField *o, size_t n)
{
	if(n < (size_t)DP(o)->size - 1) {
		return DP(o)->params[n+1];
	}
	return DP(o)->params[n+1];
}

#define _knh_Method_pfields(mtd,n)   knh_MethodField_pfields(knh_Method_mf(mtd),n)

/* ------------------------------------------------------------------------ */

knh_mfield_t knh_MethodField_lastfield(MethodField *o)
{
	return DP(o)->params[DP(o)->size-1];
}

#define _knh_Method_lastfield(mtd)   knh_MethodField_lastfield(knh_Method_mf(mtd))

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
