/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA_MESSAGE__H
#define KONOHA_MESSAGE__H

#include<konoha/konoha_t.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
#define KONOHA_LANG                     "en"
#define KONOHA_LANG__en                 0
#define KONOHA_LANG__ja                 1
#define KONOHA_LANG__debug              2
#define KONOHA_LANG_MAXSIZ              3

/* ------------------------------------------------------------------------ */
#define KMSG_NAME                       0
#define KMSG_LANG                       1
#define KMSG_CLASS                      2
#define KMSG_CONST                      3
#define KMSG_OPERATOR                   4
#define KMSG_METHOD                     5
#define KMSG_FORMATTER                  6
#define KMSG_MAPPING                    7
#define KMSG_ERRATA                     8
#define KMSG_ERROR                      9
#define KMSG_WARNING                    10
#define KMSG_INFO                       11
#define KMSG_FMTERR                     12
#define KMSG_UTOKEN                     13
#define KMSG_WCHAR                      14
#define KMSG_WLENGTH                    15
#define KMSG_IGBLOCK                    16
#define KMSG_EMISMATCH                  17
#define KMSG_WASCII                     18
#define KMSG_WEOF                       19
#define KMSG_NOTHERE                    20
#define KMSG_UUSING                     21
#define KMSG_ESYNTAX                    22
#define KMSG_EFUTURE                    23
#define KMSG_WSEMICOLON                 24
#define KMSG_TPATH                      25
#define KMSG_TTYPEN                     26
#define KMSG_TCLASSN                    27
#define KMSG_TNAME                      28
#define KMSG_TVARN                      29
#define KMSG_WEMPTY                     30
#define KMSG_CPREOP                     31
#define KMSG_ENEXTPREV                  32
#define KMSG_UOP                        33
#define KMSG_UOP1                       34
#define KMSG_UOP2                       35
#define KMSG_ETIME                      36
#define KMSG_TYPEINF                    37
#define KMSG_EABORT                     38
#define KMSG_IGSTMT                     39
#define KMSG_WCLASSN                    40
#define KMSG_WCONSTN                    41
#define KMSG_WCMETHODN                  42
#define KMSG_WNAME                      43
#define KMSG_WIGNORED                   44
#define KMSG_TEXPTN                     45
#define KMSG_TNSNAME                    46
#define KMSG_TFURN                      47
#define KMSG_TCURN                      48
#define KMSG_TNSCLASSN                  49
#define KMSG_TMETHODN                   50
#define KMSG_TCLASSTN                   51
#define KMSG_TSTR                       52
#define KMSG_TARGS                      53
#define KMSG_TCMETHODN                  54
#define KMSG_TMT                        55
#define KMSG_TANY                       56
#define KMSG_TPEXPR                     57
#define KMSG_TCATCHPARAM                58
#define KMSG_ELVALUE                    59
#define KMSG_WTYPEINF                   60
#define KMSG_NOTHERECONST               61
#define KMSG_NOTHERECLASSCONST          62
#define KMSG_NNCONST                    63
#define KMSG_DUPCONST                   64
#define KMSG_EBUILTINFUNC               65
#define KMSG_EPSTMT3                    66
#define KMSG_EPEACH                     67
#define KMSG_WLET                       68
#define KMSG_WTRUEFALSE                 69
#define KMSG_USCRIPT                    70
#define KMSG_UURN                       71
#define KMSG_UPACKAGE                   72
#define KMSG_UCONSTN                    73
#define KMSG_UVARN                      74
#define KMSG_USYSTEMVARN                75
#define KMSG_UCLASSN                    76
#define KMSG_UTAG                       77
#define KMSG_UTYPEN                     78
#define KMSG_UMETHODN                   79
#define KMSG_UFUNCN                     80
#define KMSG_ULABEL                     81
#define KMSG_WOPCMP                     82
#define KMSG_UNEW                       83
#define KMSG_UMAP                       84
#define KMSG_INTOVERFLOW                85
#define KMSG_FLOATOVERFLOW              86
#define KMSG_ETOOFEWPARAMS              87
#define KMSG_WTOOMANYPARAMS             88
#define KMSG_ENULLPARAM                 89
#define KMSG_WNULLPARAM                 90
#define KMSG_ETYPEPARAM                 91
#define KMSG_ENULLRETURN                92
#define KMSG_WNULLRETURN                93
#define KMSG_ETYPERETURN                94
#define KMSG_ENULLLET                   95
#define KMSG_ENULL                      96
#define KMSG_WNULLLET                   97
#define KMSG_WNULL                      98
#define KMSG_ETYPELET                   99
#define KMSG_ETYPE                      100
#define KMSG_ETYPEBOOL                  101
#define KMSG_WDUPFUNCNAME               102
#define KMSG_USCLASSFUNC                103
#define KMSG_IGNNTYPE                   104
#define KMSG_EEXTENDS                   105
#define KMSG_EIMPLEMENTS                106
#define KMSG_DIFFDECL                   107
#define KMSG_ENESTEDTRY                 108
#define KMSG_DIFFENAME                  109
#define KMSG_DIFFCLASSN                 110
#define KMSG_DIFFNEWTYPE                111
#define KMSG_DIFFRTYPE                  112
#define KMSG_DIFFPSIZE                  113
#define KMSG_DIFFPTYPE                  114
#define KMSG_DIFFPNAME                  115
#define KMSG_TOOMANYVARS                116
#define KMSG_EOUTERLOOP                 117
#define KMSG_IGFIELDVALUE               118
#define KMSG_IGSCRIPTNAME               119
#define KMSG_IGFIELDNAME                120
#define KMSG_NORETURN                   121
#define KMSG_NORETURNVALUE              122
#define KMSG_IGRETURN                   123
#define KMSG_AHISTORIC                  124
#define KMSG_AOVERRIDE                  125
#define KMSG_EOVERRIDE                  126
#define KMSG_TOABSTRACT                 127
#define KMSG_MAXSIZ                     128

/* ------------------------------------------------------------------------ */

/* ======================================================================== */
int knh_system_langid(char *lang);
void knh_Asm_setLang(char *lang);
int knh_message_type(int e);
char *knh_message_text(int e);
char *knh_message_tochar(int e);

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA_MESSAGE__H*/
