/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [Bytes] */

INLINE
knh_bytes_t knh_Bytes_firstbyte(Bytes *o, size_t pos)
{
	knh_bytes_t v;
	KNH_ASSERT(pos <= o->size);
	v.buf = o->buf + pos;
	v.len = pos;
	return v;
}

/* ------------------------------------------------------------------------ */

INLINE
knh_bytes_t knh_Bytes_lastbyte(Bytes *o, size_t pos)
{
	knh_bytes_t v;
	KNH_ASSERT(pos <= o->size);
	v.buf = o->buf + pos;
	v.len = o->size  - pos;
	return v;
}

/* ------------------------------------------------------------------------ */

INLINE
size_t knh_Bytes_lastsize(Bytes *o, size_t pos)
{
	return o->size - pos;
}

/* ------------------------------------------------------------------------ */

INLINE
void knh_Bytes_subclear(Bytes *o, size_t pos)
{
	KNH_ASSERT(pos <= o->size);
	knh_bzero(o->buf + pos, o->size - pos);
	o->size = pos;
}

/* ======================================================================== */
/* [String] */

String *new_String__wbuf(Ctx *ctx, knh_wbuf_t cb)
{
	if(cb.pos == cb.ba->size) {
		return TS_EMPTY;
	}
	else {
		knh_bytes_t t = knh_Bytes_lastbyte(cb.ba, cb.pos);
		//DBG_P("********** t='%s', size=%d",t.buf, t.len);
		String *s = new_String(ctx, t, NULL);
		knh_Bytes_subclear(cb.ba, cb.pos);
		return s;
	}
}

/* ------------------------------------------------------------------------ */

String *new_StringX__wbuf(Ctx *ctx, knh_class_t cid, knh_wbuf_t cb)
{
	knh_bytes_t t = knh_Bytes_lastbyte(cb.ba, cb.pos);
	//DBG_P("********** t='%s', size=%d",t.buf, t.len);
	String *s = new_StringX(ctx, cid, t, NULL);
	knh_Bytes_subclear(cb.ba, cb.pos);
	return s;
}

/* ======================================================================== */
/* [wbuf] */

knh_wbuf_t knh_Context_wbuf(Ctx* ctx)
{
	knh_wbuf_t cb;
	cb.ba = ((Context*)ctx)->bufa;
	cb.w  = ((Context*)ctx)->bufw;
	cb.pos = knh_Bytes_size(((Context*)ctx)->bufa);
	return cb;
}

/* ------------------------------------------------------------------------ */

size_t knh_wbuf_size(knh_wbuf_t cb)
{
	return knh_Bytes_lastsize(cb.ba, cb.pos);
}

/* ------------------------------------------------------------------------ */

knh_bytes_t knh_wbuf_tobytes(knh_wbuf_t cb)
{
	return B2(knh_Bytes_tochar(cb.ba) + cb.pos, knh_Bytes_lastsize(cb.ba, cb.pos));
}

/* ------------------------------------------------------------------------ */

char *knh_wbuf_top(knh_wbuf_t cb)
{
	return knh_Bytes_tochar(cb.ba) + cb.pos;
}

/* ------------------------------------------------------------------------ */


void knh_wbuf_clear(knh_wbuf_t cb)
{
	knh_Bytes_subclear(cb.ba, cb.pos);
}

/* ======================================================================== */
/* [wbuf] */

Bytes *knh_Context_openBConvBuf(Ctx* ctx)
{
	KNH_ASSERT(knh_Bytes_size(ctx->bconvbuf) == 0);
	return ctx->bconvbuf;
}

/* ------------------------------------------------------------------------ */

void knh_Context_closeBConvBuf(Ctx* ctx, Bytes *ba)
{
	KNH_ASSERT(ba == ctx->bconvbuf);
	knh_Bytes_clear(ba);
}

/* ======================================================================== */
/* [malloc] */

void *knh_Context_mallocOnce(Ctx* ctx, size_t n)
{
	KNH_ASSERT(knh_Bytes_size(ctx->bconvbuf) == 0);
	KNH_ASSERT(n > 0);
	Bytes *o = ctx->bconvbuf;
	size_t capacity = knh_barray_capacity(o->buf);
	if(o->size + n >= capacity) {
		size_t newsize = knh_uint_max(capacity * 2, o->size + n);
		o->buf = knh_barray_resize(ctx, o->buf, newsize);
	}
	return (void*)o->buf;
}

/* ------------------------------------------------------------------------ */

void knh_Context_freeOnce(Ctx* ctx, void *p)
{
	KNH_ASSERT(p == (void*)ctx->bconvbuf->buf);
	knh_Bytes_clear(ctx->bconvbuf);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
