/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [struct] */

Token* knh_tokens_curToken(knh_tokens_t *tc)
{
	int c = tc->c;
	while(!(c < tc->e)) {
		if(c == 0) break;
		c--;
	}
	return tc->ts[c];
}

///* ------------------------------------------------------------------------ */
//
//Token* knh_tokens_prevToken(knh_tokens_t *tc)
//{
//	int c = tc->c - 1;
//	while(!(c < tc->e)) {
//		if(c == 0) break;
//		c--;
//	}
//	return tc->ts[c];
//}

/* ------------------------------------------------------------------------ */

int knh_tokens_count(knh_tokens_t *tc, knh_token_t tt)
{
	Token **ts = tc->ts;
	int i, cnt = 0;
	for(i = tc->c; i < tc->e; i++) {
		if(SP(ts[i])->tt == tt) cnt++;
	}
	return cnt;
}

/* ------------------------------------------------------------------------ */

static
void knh_tokens_skipSEMICOLON(knh_tokens_t *tc)
{
	while(tc->c < tc->e) {
		if(SP(tc->ts[tc->c])->tt != TT_SEMICOLON) break;
		tc->c += 1;
	}
}

/* ------------------------------------------------------------------------ */

void knh_tokens_nextStmt(knh_tokens_t *tc)
{
	Token **ts = tc->ts;
	int i;
	for(i = tc->c; i < tc->e; i++) {
		if(knh_Token_isBOL(ts[i])) {
			tc->c = i;
			knh_tokens_skipSEMICOLON(tc);
			return;
		}
	}
	tc->c = tc->e;
}

/* ------------------------------------------------------------------------ */

knh_tokens_t knh_tokens_splitSTMT(Ctx *ctx, knh_tokens_t *tc)
{
	knh_tokens_t sub = *tc;
	int i;
	for(i = tc->c + 1; i < tc->e; i++) {
		if(knh_Token_isBOL(sub.ts[i])) {
			if(SP(sub.ts[i])->tt != TT_SEMICOLON) {
				knh_perror(ctx, SP(sub.ts[i-1])->fileid, SP(sub.ts[i-1])->line, KMSG_WSEMICOLON, NULL);
			}
			sub.e = i;
			tc->c = i;
			knh_tokens_skipSEMICOLON(tc);
			return sub;
		}
	}
	sub.e = tc->e;
//	if(tc->c < tc->e) {
//		knh_perror(ctx, SP(sub.ts[(tc->e)-1])->fileid, SP(sub.ts[(tc->e)-1])->line, KMSG_WSEMICOLON, NULL);
//	}
	tc->c = tc->e;
	return sub;
}

/* ------------------------------------------------------------------------ */

knh_tokens_t
knh_tokens_splitEXPR(Ctx *ctx, knh_tokens_t *tc, knh_token_t tt)
{
	knh_tokens_t sub = *tc;
	int i;
	for(i = tc->c; i < tc->e; i++) {
		if(SP(sub.ts[i])->tt == tt) {
			sub.e =i;
			tc->c = i + 1;
			return sub;
		}
	}
	sub.e = i;
	tc->c = tc->e;
	return sub;
}

/* ------------------------------------------------------------------------ */

String *knh_tokens_toString(Ctx *ctx, knh_tokens_t *tc, char *premsg, char *postmsg)
{
	if(tc->c + 1 == tc->e && premsg == NULL && postmsg == NULL && IS_String(DP(tc->ts[tc->c])->data)) {
		switch(SP(tc->ts[tc->c])->tt) {
		case TT_NAME: case TT_STR: case TT_NUM:
		case TT_TSTR: case TT_CONSTN:
			return (String*)DP(tc->ts[tc->c])->data;
		}
	}

	int i;
	knh_wbuf_t wbuf = knh_Context_wbuf(ctx);
	if(premsg != NULL) knh_write__s(ctx, wbuf.w, premsg);
	for(i = tc->c; i <tc->e; i++) {
		knh_Token__k(ctx, tc->ts[i], wbuf.w, (String*)KNH_NULL);
	}
	if(postmsg != NULL) knh_write__s(ctx, wbuf.w, postmsg);
	return new_String__wbuf(ctx, wbuf);
}

/* ------------------------------------------------------------------------ */

void knh_tokens_ignore(Ctx *ctx, knh_tokens_t *tc)
{
	if(tc->c < tc->e) {
		String *expr = knh_tokens_toString(ctx, tc, NULL, NULL);
		Token *tk = tc->ts[tc->c];
		KNH_SETv(ctx, DP(tk)->data, expr);
		knh_perror(ctx, SP(tk)->fileid, SP(tk)->line, KMSG_WIGNORED, knh_String_tochar(expr));
		tc->c = tc->e;
	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
