/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHAC_ASM__H
#define KONOHAC_ASM__H

#include<konoha/konoha_dev.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
#define ASMC_HALT                       ((knhvm_opcode_t)0)
#define ASMC_RET__EBP                   ((knhvm_opcode_t)1)
#define ASMC_RET__SFP                   ((knhvm_opcode_t)2)
#define ASMC_RET__OFP                   ((knhvm_opcode_t)3)
#define ASMC_RET__OBJ                   ((knhvm_opcode_t)4)
#define ASMC_RET__OIDX                  ((knhvm_opcode_t)5)
#define ASMC_MOVE__EBP                  ((knhvm_opcode_t)6)
#define ASMC_MOVE__SFP                  ((knhvm_opcode_t)7)
#define ASMC_MOVE__OFP                  ((knhvm_opcode_t)8)
#define ASMC_MOVE__OBJ                  ((knhvm_opcode_t)9)
#define ASMC_MOVE__OIDX                 ((knhvm_opcode_t)10)
#define ASMC_MOVS__EBP                  ((knhvm_opcode_t)11)
#define ASMC_MOVS__SFP                  ((knhvm_opcode_t)12)
#define ASMC_MOVS__OFP                  ((knhvm_opcode_t)13)
#define ASMC_MOVS__OBJ                  ((knhvm_opcode_t)14)
#define ASMC_MOVS__OIDX                 ((knhvm_opcode_t)15)
#define ASMC_MOVO__EBP                  ((knhvm_opcode_t)16)
#define ASMC_MOVO__SFP                  ((knhvm_opcode_t)17)
#define ASMC_MOVO__OFP                  ((knhvm_opcode_t)18)
#define ASMC_MOVO__OBJ                  ((knhvm_opcode_t)19)
#define ASMC_MOVO__OIDX                 ((knhvm_opcode_t)20)
#define ASMC_MOVOI__EBP                 ((knhvm_opcode_t)21)
#define ASMC_MOVOI__SFP                 ((knhvm_opcode_t)22)
#define ASMC_MOVOI__OFP                 ((knhvm_opcode_t)23)
#define ASMC_MOVOI__OBJ                 ((knhvm_opcode_t)24)
#define ASMC_MOVOI__OIDX                ((knhvm_opcode_t)25)
#define ASMC_MOVSFP_IFNUL               ((knhvm_opcode_t)26)
#define ASMC_PUSH__EBP                  ((knhvm_opcode_t)27)
#define ASMC_PUSH__SFP                  ((knhvm_opcode_t)28)
#define ASMC_PUSH__OFP                  ((knhvm_opcode_t)29)
#define ASMC_PUSH__OBJ                  ((knhvm_opcode_t)30)
#define ASMC_PUSH__OIDX                 ((knhvm_opcode_t)31)
#define ASMC_PUT_SYSCONST               ((knhvm_opcode_t)32)
#define ASMC_PUSH_SYSCONST              ((knhvm_opcode_t)33)
#define ASMC_PUSH__DEF                  ((knhvm_opcode_t)34)
#define ASMC_VARGS                      ((knhvm_opcode_t)35)
#define ASMC_SHIFT                      ((knhvm_opcode_t)36)
#define ASMC_SCALL                      ((knhvm_opcode_t)37)
#define ASMC_NSCALL                     ((knhvm_opcode_t)38)
#define ASMC_CALL                       ((knhvm_opcode_t)39)
#define ASMC_DCALL                      ((knhvm_opcode_t)40)
#define ASMC_NEW                        ((knhvm_opcode_t)41)
#define ASMC_MT                         ((knhvm_opcode_t)42)
#define ASMC_MT__FMT                    ((knhvm_opcode_t)43)
#define ASMC_SMAP                       ((knhvm_opcode_t)44)
#define ASMC_SMAPE                      ((knhvm_opcode_t)45)
#define ASMC_MAP                        ((knhvm_opcode_t)46)
#define ASMC_MAPE                       ((knhvm_opcode_t)47)
#define ASMC_ANYMAP                     ((knhvm_opcode_t)48)
#define ASMC_ANYMAPE                    ((knhvm_opcode_t)49)
#define ASMC_MAP2                       ((knhvm_opcode_t)50)
#define ASMC_MAP2E                      ((knhvm_opcode_t)51)
#define ASMC_TYPECHK__EBP               ((knhvm_opcode_t)52)
#define ASMC_TYPECHK__SFP               ((knhvm_opcode_t)53)
#define ASMC_TYPECHK__OFP               ((knhvm_opcode_t)54)
#define ASMC_TYPECHK__OBJ               ((knhvm_opcode_t)55)
#define ASMC_TYPECHK__OIDX              ((knhvm_opcode_t)56)
#define ASMC_NULLCHK__EBP               ((knhvm_opcode_t)57)
#define ASMC_NULLCHK__SFP               ((knhvm_opcode_t)58)
#define ASMC_NULLCHK__OFP               ((knhvm_opcode_t)59)
#define ASMC_NULLCHK__OBJ               ((knhvm_opcode_t)60)
#define ASMC_NULLCHK__OIDX              ((knhvm_opcode_t)61)
#define ASMC_JMP                        ((knhvm_opcode_t)62)
#define ASMC_SKIP                       ((knhvm_opcode_t)63)
#define ASMC_JMP_IFT__EBP               ((knhvm_opcode_t)64)
#define ASMC_JMP_IFT__SFP               ((knhvm_opcode_t)65)
#define ASMC_JMP_IFT__OFP               ((knhvm_opcode_t)66)
#define ASMC_JMP_IFT__OIDX              ((knhvm_opcode_t)67)
#define ASMC_JMP_IFF__EBP               ((knhvm_opcode_t)68)
#define ASMC_JMP_IFF__SFP               ((knhvm_opcode_t)69)
#define ASMC_JMP_IFF__OFP               ((knhvm_opcode_t)70)
#define ASMC_JMP_IFF__OIDX              ((knhvm_opcode_t)71)
#define ASMC_JMP_IFN__EBP               ((knhvm_opcode_t)72)
#define ASMC_JMP_IFN__SFP               ((knhvm_opcode_t)73)
#define ASMC_JMP_IFN__OFP               ((knhvm_opcode_t)74)
#define ASMC_JMP_IFN__OIDX              ((knhvm_opcode_t)75)
#define ASMC_JMP_IFNN__EBP              ((knhvm_opcode_t)76)
#define ASMC_JMP_IFNN__SFP              ((knhvm_opcode_t)77)
#define ASMC_JMP_IFNN__OFP              ((knhvm_opcode_t)78)
#define ASMC_JMP_IFNN__OIDX             ((knhvm_opcode_t)79)
#define ASMC_NEXT                       ((knhvm_opcode_t)80)
#define ASMC_MAPNEXT                    ((knhvm_opcode_t)81)
#define ASMC_SMAPNEXT                   ((knhvm_opcode_t)82)
#define ASMC_TRY                        ((knhvm_opcode_t)83)
#define ASMC_TRY_WC                     ((knhvm_opcode_t)84)
#define ASMC_TRY_END                    ((knhvm_opcode_t)85)
#define ASMC_CATCH                      ((knhvm_opcode_t)86)
#define ASMC_THROW_AGAIN                ((knhvm_opcode_t)87)
#define ASMC_THROW__EBP                 ((knhvm_opcode_t)88)
#define ASMC_THROW__SFP                 ((knhvm_opcode_t)89)
#define ASMC_THROW__OBJ                 ((knhvm_opcode_t)90)
#define ASMC_PRINT__EBP                 ((knhvm_opcode_t)91)
#define ASMC_PRINT__SFP                 ((knhvm_opcode_t)92)
#define ASMC_PRINT__OFP                 ((knhvm_opcode_t)93)
#define ASMC_PRINT__OBJ                 ((knhvm_opcode_t)94)
#define ASMC_PRINT__OIDX                ((knhvm_opcode_t)95)
#define ASMC_NOP                        ((knhvm_opcode_t)96)

/* ------------------------------------------------------------------------ */
#ifndef METHODN__k
#define METHODN__k                      METHODN__s
#endif

/* ------------------------------------------------------------------------ */
void knh_Compiler_remapAddress(Ctx *ctx, Compiler *o);
void knh_KLRCode_utraverse(Ctx *ctx, knh_bytes_t vmc, f_traverse gc);
void knh_KLRCode__dumpmtd(Ctx *ctx, KLRCode *o, OutputStream *w, Method *mtd);
METHOD knh_KLRCode_exec(Ctx *ctx, knh_sfp_t *sfp);

#ifdef CLASS_Compiler
void KNH_ASM_HALT(Ctx *ctx, Compiler *o);
void KNH_ASM_RET(Ctx *ctx, Compiler *o, Term *v);
void KNH_ASM_RET__ebp(Ctx *ctx, Compiler *o, knhvm_ebp_t a1);
void KNH_ASM_RET__sfp(Ctx *ctx, Compiler *o, knhvm_sfp_t a1);
void KNH_ASM_RET__ofp(Ctx *ctx, Compiler *o, knhvm_ofp_t a1);
void KNH_ASM_RET__OBJ(Ctx *ctx, Compiler *o, Object* a1);
void KNH_ASM_RET__OIDX(Ctx *ctx, Compiler *o, Object* a1, knhvm_u1_t a2);
void KNH_ASM_MOVE(Ctx *ctx, Compiler *o, knhvm_ebp_t a1, Term *v);
void KNH_ASM_MOVE__ebp(Ctx *ctx, Compiler *o, knhvm_ebp_t a1, knhvm_ebp_t a2);
void KNH_ASM_MOVE__sfp(Ctx *ctx, Compiler *o, knhvm_ebp_t a1, knhvm_sfp_t a2);
void KNH_ASM_MOVE__ofp(Ctx *ctx, Compiler *o, knhvm_ebp_t a1, knhvm_ofp_t a2);
void KNH_ASM_MOVE__OBJ(Ctx *ctx, Compiler *o, knhvm_ebp_t a1, Object* a2);
void KNH_ASM_MOVE__OIDX(Ctx *ctx, Compiler *o, knhvm_ebp_t a1, Object* a2, knhvm_u1_t a3);
void KNH_ASM_MOVS(Ctx *ctx, Compiler *o, knhvm_sfp_t a1, Term *v);
void KNH_ASM_MOVS__ebp(Ctx *ctx, Compiler *o, knhvm_sfp_t a1, knhvm_ebp_t a2);
void KNH_ASM_MOVS__sfp(Ctx *ctx, Compiler *o, knhvm_sfp_t a1, knhvm_sfp_t a2);
void KNH_ASM_MOVS__ofp(Ctx *ctx, Compiler *o, knhvm_sfp_t a1, knhvm_ofp_t a2);
void KNH_ASM_MOVS__OBJ(Ctx *ctx, Compiler *o, knhvm_sfp_t a1, Object* a2);
void KNH_ASM_MOVS__OIDX(Ctx *ctx, Compiler *o, knhvm_sfp_t a1, Object* a2, knhvm_u1_t a3);
void KNH_ASM_MOVO(Ctx *ctx, Compiler *o, knhvm_ofp_t a1, Term *v);
void KNH_ASM_MOVO__ebp(Ctx *ctx, Compiler *o, knhvm_ofp_t a1, knhvm_ebp_t a2);
void KNH_ASM_MOVO__sfp(Ctx *ctx, Compiler *o, knhvm_ofp_t a1, knhvm_sfp_t a2);
void KNH_ASM_MOVO__ofp(Ctx *ctx, Compiler *o, knhvm_ofp_t a1, knhvm_ofp_t a2);
void KNH_ASM_MOVO__OBJ(Ctx *ctx, Compiler *o, knhvm_ofp_t a1, Object* a2);
void KNH_ASM_MOVO__OIDX(Ctx *ctx, Compiler *o, knhvm_ofp_t a1, Object* a2, knhvm_u1_t a3);
void KNH_ASM_MOVOI(Ctx *ctx, Compiler *o, Object* a1, knhvm_ofp_t a2, Term *v);
void KNH_ASM_MOVOI__ebp(Ctx *ctx, Compiler *o, Object* a1, knhvm_ofp_t a2, knhvm_ebp_t a3);
void KNH_ASM_MOVOI__sfp(Ctx *ctx, Compiler *o, Object* a1, knhvm_ofp_t a2, knhvm_sfp_t a3);
void KNH_ASM_MOVOI__ofp(Ctx *ctx, Compiler *o, Object* a1, knhvm_ofp_t a2, knhvm_ofp_t a3);
void KNH_ASM_MOVOI__OBJ(Ctx *ctx, Compiler *o, Object* a1, knhvm_ofp_t a2, Object* a3);
void KNH_ASM_MOVOI__OIDX(Ctx *ctx, Compiler *o, Object* a1, knhvm_u1_t a2, Object* a3, knhvm_u1_t a4);
void KNH_ASM_MOVSFP_IFNUL(Ctx *ctx, Compiler *o, knhvm_u1_t a1, Object* a2);
void KNH_ASM_PUSH(Ctx *ctx, Compiler *o, Term *v);
void KNH_ASM_PUSH__ebp(Ctx *ctx, Compiler *o, knhvm_ebp_t a1);
void KNH_ASM_PUSH__sfp(Ctx *ctx, Compiler *o, knhvm_sfp_t a1);
void KNH_ASM_PUSH__ofp(Ctx *ctx, Compiler *o, knhvm_ofp_t a1);
void KNH_ASM_PUSH__OBJ(Ctx *ctx, Compiler *o, Object* a1);
void KNH_ASM_PUSH__OIDX(Ctx *ctx, Compiler *o, Object* a1, knhvm_u1_t a2);
void KNH_ASM_PUT_SYSCONST(Ctx *ctx, Compiler *o, knhvm_u2_t a1);
void KNH_ASM_PUSH_SYSCONST(Ctx *ctx, Compiler *o, knhvm_u2_t a1);
void KNH_ASM_PUSH__DEF(Ctx *ctx, Compiler *o, knhvm_class_t a1);
void KNH_ASM_VARGS(Ctx *ctx, Compiler *o, knhvm_u2_t a1);
void KNH_ASM_SHIFT(Ctx *ctx, Compiler *o, knhvm_i1_t a1);
void KNH_ASM_SCALL(Ctx *ctx, Compiler *o, knhvm_u1_t a1);
void KNH_ASM_NSCALL(Ctx *ctx, Compiler *o, knhvm_u1_t a1);
void KNH_ASM_CALL(Ctx *ctx, Compiler *o, knhvm_u1_t a1, knhvm_methodn_t a2);
void KNH_ASM_DCALL(Ctx *ctx, Compiler *o, knhvm_u1_t a1, knhvm_methodn_t a2);
void KNH_ASM_NEW(Ctx *ctx, Compiler *o, knhvm_u2_t a1, knhvm_u2_t a2, knhvm_class_t a3);
void KNH_ASM_MT(Ctx *ctx, Compiler *o, knhvm_methodn_t a1);
void KNH_ASM_MT__FMT(Ctx *ctx, Compiler *o, knhvm_methodn_t a1, Object* a2);
void KNH_ASM_SMAP(Ctx *ctx, Compiler *o, Object* a1);
void KNH_ASM_SMAPE(Ctx *ctx, Compiler *o, Object* a1);
void KNH_ASM_MAP(Ctx *ctx, Compiler *o, knhvm_class_t a1);
void KNH_ASM_MAPE(Ctx *ctx, Compiler *o, knhvm_class_t a1);
void KNH_ASM_ANYMAP(Ctx *ctx, Compiler *o, knhvm_class_t a1);
void KNH_ASM_ANYMAPE(Ctx *ctx, Compiler *o, knhvm_class_t a1);
void KNH_ASM_MAP2(Ctx *ctx, Compiler *o, knhvm_class_t a1);
void KNH_ASM_MAP2E(Ctx *ctx, Compiler *o, knhvm_class_t a1);
void KNH_ASM_TYPECHK(Ctx *ctx, Compiler *o, knhvm_class_t a1, Term *v);
void KNH_ASM_TYPECHK__ebp(Ctx *ctx, Compiler *o, knhvm_class_t a1, knhvm_ebp_t a2);
void KNH_ASM_TYPECHK__sfp(Ctx *ctx, Compiler *o, knhvm_class_t a1, knhvm_sfp_t a2);
void KNH_ASM_TYPECHK__ofp(Ctx *ctx, Compiler *o, knhvm_class_t a1, knhvm_ofp_t a2);
void KNH_ASM_TYPECHK__OBJ(Ctx *ctx, Compiler *o, knhvm_class_t a1, Object* a2);
void KNH_ASM_TYPECHK__OIDX(Ctx *ctx, Compiler *o, knhvm_class_t a1, Object* a2, knhvm_u1_t a3);
void KNH_ASM_NULLCHK(Ctx *ctx, Compiler *o, Term *v);
void KNH_ASM_NULLCHK__ebp(Ctx *ctx, Compiler *o, knhvm_ebp_t a1);
void KNH_ASM_NULLCHK__sfp(Ctx *ctx, Compiler *o, knhvm_sfp_t a1);
void KNH_ASM_NULLCHK__ofp(Ctx *ctx, Compiler *o, knhvm_ofp_t a1);
void KNH_ASM_NULLCHK__OBJ(Ctx *ctx, Compiler *o, Object* a1);
void KNH_ASM_NULLCHK__OIDX(Ctx *ctx, Compiler *o, Object* a1, knhvm_u1_t a2);
void KNH_ASM_JMP(Ctx *ctx, Compiler *o, knh_bytes_t a1);
void KNH_ASM_SKIP(Ctx *ctx, Compiler *o, knh_bytes_t a1);
void KNH_ASM_JMP_IFT(Ctx *ctx, Compiler *o, knh_bytes_t a1, Term *v);
void KNH_ASM_JMP_IFT__ebp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_ebp_t a2);
void KNH_ASM_JMP_IFT__sfp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2);
void KNH_ASM_JMP_IFT__ofp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_ofp_t a2);
void KNH_ASM_JMP_IFT__OIDX(Ctx *ctx, Compiler *o, knh_bytes_t a1, Object* a2, knhvm_u1_t a3);
void KNH_ASM_JMP_IFF(Ctx *ctx, Compiler *o, knh_bytes_t a1, Term *v);
void KNH_ASM_JMP_IFF__ebp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_ebp_t a2);
void KNH_ASM_JMP_IFF__sfp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2);
void KNH_ASM_JMP_IFF__ofp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_ofp_t a2);
void KNH_ASM_JMP_IFF__OIDX(Ctx *ctx, Compiler *o, knh_bytes_t a1, Object* a2, knhvm_u1_t a3);
void KNH_ASM_JMP_IFN(Ctx *ctx, Compiler *o, knh_bytes_t a1, Term *v);
void KNH_ASM_JMP_IFN__ebp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_ebp_t a2);
void KNH_ASM_JMP_IFN__sfp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2);
void KNH_ASM_JMP_IFN__ofp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_ofp_t a2);
void KNH_ASM_JMP_IFN__OIDX(Ctx *ctx, Compiler *o, knh_bytes_t a1, Object* a2, knhvm_u1_t a3);
void KNH_ASM_JMP_IFNN(Ctx *ctx, Compiler *o, knh_bytes_t a1, Term *v);
void KNH_ASM_JMP_IFNN__ebp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_ebp_t a2);
void KNH_ASM_JMP_IFNN__sfp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2);
void KNH_ASM_JMP_IFNN__ofp(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_ofp_t a2);
void KNH_ASM_JMP_IFNN__OIDX(Ctx *ctx, Compiler *o, knh_bytes_t a1, Object* a2, knhvm_u1_t a3);
void KNH_ASM_NEXT(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2, knhvm_sfp_t a3);
void KNH_ASM_MAPNEXT(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2, knhvm_sfp_t a3, knhvm_class_t a4);
void KNH_ASM_SMAPNEXT(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2, knhvm_sfp_t a3, Object* a4);
void KNH_ASM_TRY(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2, knhvm_sfp_t a3);
void KNH_ASM_TRY_WC(Ctx *ctx, Compiler *o, knh_bytes_t a1, knhvm_sfp_t a2);
void KNH_ASM_TRY_END(Ctx *ctx, Compiler *o, knhvm_sfp_t a1);
void KNH_ASM_CATCH(Ctx *ctx, Compiler *o, knh_bytes_t a1, Object* a2, knhvm_sfp_t a3);
void KNH_ASM_THROW_AGAIN(Ctx *ctx, Compiler *o, knhvm_sfp_t a1);
void KNH_ASM_THROW(Ctx *ctx, Compiler *o, Term *v);
void KNH_ASM_THROW__ebp(Ctx *ctx, Compiler *o, knhvm_ebp_t a1);
void KNH_ASM_THROW__sfp(Ctx *ctx, Compiler *o, knhvm_sfp_t a1);
void KNH_ASM_THROW__OBJ(Ctx *ctx, Compiler *o, Object* a1);
void KNH_ASM_PRINT(Ctx *ctx, Compiler *o, knhvm_u2_t a1, Object* a2, knhvm_methodn_t a3, Term *v);
void KNH_ASM_PRINT__ebp(Ctx *ctx, Compiler *o, knhvm_u2_t a1, Object* a2, knhvm_methodn_t a3, knhvm_ebp_t a4);
void KNH_ASM_PRINT__sfp(Ctx *ctx, Compiler *o, knhvm_u2_t a1, Object* a2, knhvm_methodn_t a3, knhvm_sfp_t a4);
void KNH_ASM_PRINT__ofp(Ctx *ctx, Compiler *o, knhvm_u2_t a1, Object* a2, knhvm_methodn_t a3, knhvm_ofp_t a4);
void KNH_ASM_PRINT__OBJ(Ctx *ctx, Compiler *o, knhvm_u2_t a1, Object* a2, knhvm_methodn_t a3, Object* a4);
void KNH_ASM_PRINT__OIDX(Ctx *ctx, Compiler *o, knhvm_u2_t a1, Object* a2, knhvm_methodn_t a3, Object* a4, knhvm_u1_t a5);
void KNH_ASM_NOP(Ctx *ctx, Compiler *o);

#endif/*CLASS_Compiler*/

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
} knh_asmc_halt_t;

typedef struct {
	knhvm_opcode_t code;
	void *w;
} knh_asmc_halt_tw;

#define KNH_ASMC_HALT_SIZ  (sizeof(knh_asmc_halt_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
} knh_asmc_ret_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	void *w;
} knh_asmc_ret_ebp_tw;

#define KNH_ASMC_RET_ebp_SIZ  (sizeof(knh_asmc_ret_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
} knh_asmc_ret_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	void *w;
} knh_asmc_ret_sfp_tw;

#define KNH_ASMC_RET_sfp_SIZ  (sizeof(knh_asmc_ret_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
} knh_asmc_ret_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	void *w;
} knh_asmc_ret_ofp_tw;

#define KNH_ASMC_RET_ofp_SIZ  (sizeof(knh_asmc_ret_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
} knh_asmc_ret_obj_t;

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
	void *w;
} knh_asmc_ret_obj_tw;

#define KNH_ASMC_RET_OBJ_SIZ  (sizeof(knh_asmc_ret_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a2;
	Object* a1;
} knh_asmc_ret_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a2;
	Object* a1;
	void *w;
} knh_asmc_ret_oidx_tw;

#define KNH_ASMC_RET_OIDX_SIZ  (sizeof(knh_asmc_ret_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	knhvm_ebp_t a2;
} knh_asmc_move_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	knhvm_ebp_t a2;
	void *w;
} knh_asmc_move_ebp_tw;

#define KNH_ASMC_MOVE_ebp_SIZ  (sizeof(knh_asmc_move_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	knhvm_sfp_t a2;
} knh_asmc_move_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_move_sfp_tw;

#define KNH_ASMC_MOVE_sfp_SIZ  (sizeof(knh_asmc_move_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	knhvm_ofp_t a2;
} knh_asmc_move_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	knhvm_ofp_t a2;
	void *w;
} knh_asmc_move_ofp_tw;

#define KNH_ASMC_MOVE_ofp_SIZ  (sizeof(knh_asmc_move_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	Object* a2;
} knh_asmc_move_obj_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	Object* a2;
	void *w;
} knh_asmc_move_obj_tw;

#define KNH_ASMC_MOVE_OBJ_SIZ  (sizeof(knh_asmc_move_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	knhvm_u1_t a3;
	Object* a2;
} knh_asmc_move_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	knhvm_u1_t a3;
	Object* a2;
	void *w;
} knh_asmc_move_oidx_tw;

#define KNH_ASMC_MOVE_OIDX_SIZ  (sizeof(knh_asmc_move_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	knhvm_ebp_t a2;
} knh_asmc_movs_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	knhvm_ebp_t a2;
	void *w;
} knh_asmc_movs_ebp_tw;

#define KNH_ASMC_MOVS_ebp_SIZ  (sizeof(knh_asmc_movs_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	knhvm_sfp_t a2;
} knh_asmc_movs_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_movs_sfp_tw;

#define KNH_ASMC_MOVS_sfp_SIZ  (sizeof(knh_asmc_movs_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	knhvm_ofp_t a2;
} knh_asmc_movs_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	knhvm_ofp_t a2;
	void *w;
} knh_asmc_movs_ofp_tw;

#define KNH_ASMC_MOVS_ofp_SIZ  (sizeof(knh_asmc_movs_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	Object* a2;
} knh_asmc_movs_obj_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	Object* a2;
	void *w;
} knh_asmc_movs_obj_tw;

#define KNH_ASMC_MOVS_OBJ_SIZ  (sizeof(knh_asmc_movs_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	knhvm_u1_t a3;
	Object* a2;
} knh_asmc_movs_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	knhvm_u1_t a3;
	Object* a2;
	void *w;
} knh_asmc_movs_oidx_tw;

#define KNH_ASMC_MOVS_OIDX_SIZ  (sizeof(knh_asmc_movs_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	knhvm_ebp_t a2;
} knh_asmc_movo_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	knhvm_ebp_t a2;
	void *w;
} knh_asmc_movo_ebp_tw;

#define KNH_ASMC_MOVO_ebp_SIZ  (sizeof(knh_asmc_movo_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	knhvm_sfp_t a2;
} knh_asmc_movo_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_movo_sfp_tw;

#define KNH_ASMC_MOVO_sfp_SIZ  (sizeof(knh_asmc_movo_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	knhvm_ofp_t a2;
} knh_asmc_movo_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	knhvm_ofp_t a2;
	void *w;
} knh_asmc_movo_ofp_tw;

#define KNH_ASMC_MOVO_ofp_SIZ  (sizeof(knh_asmc_movo_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	Object* a2;
} knh_asmc_movo_obj_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	Object* a2;
	void *w;
} knh_asmc_movo_obj_tw;

#define KNH_ASMC_MOVO_OBJ_SIZ  (sizeof(knh_asmc_movo_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	knhvm_u1_t a3;
	Object* a2;
} knh_asmc_movo_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	knhvm_u1_t a3;
	Object* a2;
	void *w;
} knh_asmc_movo_oidx_tw;

#define KNH_ASMC_MOVO_OIDX_SIZ  (sizeof(knh_asmc_movo_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a2;
	knhvm_ebp_t a3;
	Object* a1;
} knh_asmc_movoi_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a2;
	knhvm_ebp_t a3;
	Object* a1;
	void *w;
} knh_asmc_movoi_ebp_tw;

#define KNH_ASMC_MOVOI_ebp_SIZ  (sizeof(knh_asmc_movoi_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a2;
	knhvm_sfp_t a3;
	Object* a1;
} knh_asmc_movoi_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a2;
	knhvm_sfp_t a3;
	Object* a1;
	void *w;
} knh_asmc_movoi_sfp_tw;

#define KNH_ASMC_MOVOI_sfp_SIZ  (sizeof(knh_asmc_movoi_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a2;
	knhvm_ofp_t a3;
	Object* a1;
} knh_asmc_movoi_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a2;
	knhvm_ofp_t a3;
	Object* a1;
	void *w;
} knh_asmc_movoi_ofp_tw;

#define KNH_ASMC_MOVOI_ofp_SIZ  (sizeof(knh_asmc_movoi_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a2;
	Object* a1;
	Object* a3;
} knh_asmc_movoi_obj_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a2;
	Object* a1;
	Object* a3;
	void *w;
} knh_asmc_movoi_obj_tw;

#define KNH_ASMC_MOVOI_OBJ_SIZ  (sizeof(knh_asmc_movoi_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a2;
	knhvm_u1_t a4;
	Object* a1;
	Object* a3;
} knh_asmc_movoi_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a2;
	knhvm_u1_t a4;
	Object* a1;
	Object* a3;
	void *w;
} knh_asmc_movoi_oidx_tw;

#define KNH_ASMC_MOVOI_OIDX_SIZ  (sizeof(knh_asmc_movoi_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
	Object* a2;
} knh_asmc_movsfp_ifnul_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
	Object* a2;
	void *w;
} knh_asmc_movsfp_ifnul_tw;

#define KNH_ASMC_MOVSFP_IFNUL_SIZ  (sizeof(knh_asmc_movsfp_ifnul_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
} knh_asmc_push_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	void *w;
} knh_asmc_push_ebp_tw;

#define KNH_ASMC_PUSH_ebp_SIZ  (sizeof(knh_asmc_push_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
} knh_asmc_push_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	void *w;
} knh_asmc_push_sfp_tw;

#define KNH_ASMC_PUSH_sfp_SIZ  (sizeof(knh_asmc_push_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
} knh_asmc_push_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	void *w;
} knh_asmc_push_ofp_tw;

#define KNH_ASMC_PUSH_ofp_SIZ  (sizeof(knh_asmc_push_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
} knh_asmc_push_obj_t;

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
	void *w;
} knh_asmc_push_obj_tw;

#define KNH_ASMC_PUSH_OBJ_SIZ  (sizeof(knh_asmc_push_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a2;
	Object* a1;
} knh_asmc_push_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a2;
	Object* a1;
	void *w;
} knh_asmc_push_oidx_tw;

#define KNH_ASMC_PUSH_OIDX_SIZ  (sizeof(knh_asmc_push_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
} knh_asmc_put_sysconst_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	void *w;
} knh_asmc_put_sysconst_tw;

#define KNH_ASMC_PUT_SYSCONST_SIZ  (sizeof(knh_asmc_put_sysconst_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
} knh_asmc_push_sysconst_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	void *w;
} knh_asmc_push_sysconst_tw;

#define KNH_ASMC_PUSH_SYSCONST_SIZ  (sizeof(knh_asmc_push_sysconst_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
} knh_asmc_push_def_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	void *w;
} knh_asmc_push_def_tw;

#define KNH_ASMC_PUSH_DEF_SIZ  (sizeof(knh_asmc_push_def_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
} knh_asmc_vargs_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	void *w;
} knh_asmc_vargs_tw;

#define KNH_ASMC_VARGS_SIZ  (sizeof(knh_asmc_vargs_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_i1_t a1;
} knh_asmc_shift_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_i1_t a1;
	void *w;
} knh_asmc_shift_tw;

#define KNH_ASMC_SHIFT_SIZ  (sizeof(knh_asmc_shift_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
} knh_asmc_scall_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
	void *w;
} knh_asmc_scall_tw;

#define KNH_ASMC_SCALL_SIZ  (sizeof(knh_asmc_scall_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
} knh_asmc_nscall_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
	void *w;
} knh_asmc_nscall_tw;

#define KNH_ASMC_NSCALL_SIZ  (sizeof(knh_asmc_nscall_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
	knhvm_methodn_t a2;
} knh_asmc_call_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
	knhvm_methodn_t a2;
	void *w;
} knh_asmc_call_tw;

#define KNH_ASMC_CALL_SIZ  (sizeof(knh_asmc_call_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
	knhvm_methodn_t a2;
} knh_asmc_dcall_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a1;
	knhvm_methodn_t a2;
	void *w;
} knh_asmc_dcall_tw;

#define KNH_ASMC_DCALL_SIZ  (sizeof(knh_asmc_dcall_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_u2_t a2;
	knhvm_class_t a3;
} knh_asmc_new_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_u2_t a2;
	knhvm_class_t a3;
	void *w;
} knh_asmc_new_tw;

#define KNH_ASMC_NEW_SIZ  (sizeof(knh_asmc_new_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_methodn_t a1;
} knh_asmc_mt_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_methodn_t a1;
	void *w;
} knh_asmc_mt_tw;

#define KNH_ASMC_MT_SIZ  (sizeof(knh_asmc_mt_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_methodn_t a1;
	Object* a2;
} knh_asmc_mt_fmt_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_methodn_t a1;
	Object* a2;
	void *w;
} knh_asmc_mt_fmt_tw;

#define KNH_ASMC_MT_FMT_SIZ  (sizeof(knh_asmc_mt_fmt_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
} knh_asmc_smap_t;

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
	void *w;
} knh_asmc_smap_tw;

#define KNH_ASMC_SMAP_SIZ  (sizeof(knh_asmc_smap_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
} knh_asmc_smape_t;

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
	void *w;
} knh_asmc_smape_tw;

#define KNH_ASMC_SMAPE_SIZ  (sizeof(knh_asmc_smape_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
} knh_asmc_map_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	void *w;
} knh_asmc_map_tw;

#define KNH_ASMC_MAP_SIZ  (sizeof(knh_asmc_map_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
} knh_asmc_mape_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	void *w;
} knh_asmc_mape_tw;

#define KNH_ASMC_MAPE_SIZ  (sizeof(knh_asmc_mape_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
} knh_asmc_anymap_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	void *w;
} knh_asmc_anymap_tw;

#define KNH_ASMC_ANYMAP_SIZ  (sizeof(knh_asmc_anymap_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
} knh_asmc_anymape_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	void *w;
} knh_asmc_anymape_tw;

#define KNH_ASMC_ANYMAPE_SIZ  (sizeof(knh_asmc_anymape_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
} knh_asmc_map2_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	void *w;
} knh_asmc_map2_tw;

#define KNH_ASMC_MAP2_SIZ  (sizeof(knh_asmc_map2_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
} knh_asmc_map2e_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	void *w;
} knh_asmc_map2e_tw;

#define KNH_ASMC_MAP2E_SIZ  (sizeof(knh_asmc_map2e_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	knhvm_ebp_t a2;
} knh_asmc_typechk_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	knhvm_ebp_t a2;
	void *w;
} knh_asmc_typechk_ebp_tw;

#define KNH_ASMC_TYPECHK_ebp_SIZ  (sizeof(knh_asmc_typechk_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	knhvm_sfp_t a2;
} knh_asmc_typechk_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_typechk_sfp_tw;

#define KNH_ASMC_TYPECHK_sfp_SIZ  (sizeof(knh_asmc_typechk_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	knhvm_ofp_t a2;
} knh_asmc_typechk_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	knhvm_ofp_t a2;
	void *w;
} knh_asmc_typechk_ofp_tw;

#define KNH_ASMC_TYPECHK_ofp_SIZ  (sizeof(knh_asmc_typechk_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	Object* a2;
} knh_asmc_typechk_obj_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	Object* a2;
	void *w;
} knh_asmc_typechk_obj_tw;

#define KNH_ASMC_TYPECHK_OBJ_SIZ  (sizeof(knh_asmc_typechk_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	knhvm_u1_t a3;
	Object* a2;
} knh_asmc_typechk_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_class_t a1;
	knhvm_u1_t a3;
	Object* a2;
	void *w;
} knh_asmc_typechk_oidx_tw;

#define KNH_ASMC_TYPECHK_OIDX_SIZ  (sizeof(knh_asmc_typechk_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
} knh_asmc_nullchk_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	void *w;
} knh_asmc_nullchk_ebp_tw;

#define KNH_ASMC_NULLCHK_ebp_SIZ  (sizeof(knh_asmc_nullchk_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
} knh_asmc_nullchk_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	void *w;
} knh_asmc_nullchk_sfp_tw;

#define KNH_ASMC_NULLCHK_sfp_SIZ  (sizeof(knh_asmc_nullchk_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
} knh_asmc_nullchk_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ofp_t a1;
	void *w;
} knh_asmc_nullchk_ofp_tw;

#define KNH_ASMC_NULLCHK_ofp_SIZ  (sizeof(knh_asmc_nullchk_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
} knh_asmc_nullchk_obj_t;

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
	void *w;
} knh_asmc_nullchk_obj_tw;

#define KNH_ASMC_NULLCHK_OBJ_SIZ  (sizeof(knh_asmc_nullchk_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a2;
	Object* a1;
} knh_asmc_nullchk_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u1_t a2;
	Object* a1;
	void *w;
} knh_asmc_nullchk_oidx_tw;

#define KNH_ASMC_NULLCHK_OIDX_SIZ  (sizeof(knh_asmc_nullchk_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
} knh_asmc_jmp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	void *w;
} knh_asmc_jmp_tw;

#define KNH_ASMC_JMP_SIZ  (sizeof(knh_asmc_jmp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
} knh_asmc_skip_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	void *w;
} knh_asmc_skip_tw;

#define KNH_ASMC_SKIP_SIZ  (sizeof(knh_asmc_skip_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ebp_t a2;
} knh_asmc_jmp_ift_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ebp_t a2;
	void *w;
} knh_asmc_jmp_ift_ebp_tw;

#define KNH_ASMC_JMP_IFT_ebp_SIZ  (sizeof(knh_asmc_jmp_ift_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
} knh_asmc_jmp_ift_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_jmp_ift_sfp_tw;

#define KNH_ASMC_JMP_IFT_sfp_SIZ  (sizeof(knh_asmc_jmp_ift_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ofp_t a2;
} knh_asmc_jmp_ift_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ofp_t a2;
	void *w;
} knh_asmc_jmp_ift_ofp_tw;

#define KNH_ASMC_JMP_IFT_ofp_SIZ  (sizeof(knh_asmc_jmp_ift_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_u1_t a3;
	Object* a2;
} knh_asmc_jmp_ift_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_u1_t a3;
	Object* a2;
	void *w;
} knh_asmc_jmp_ift_oidx_tw;

#define KNH_ASMC_JMP_IFT_OIDX_SIZ  (sizeof(knh_asmc_jmp_ift_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ebp_t a2;
} knh_asmc_jmp_iff_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ebp_t a2;
	void *w;
} knh_asmc_jmp_iff_ebp_tw;

#define KNH_ASMC_JMP_IFF_ebp_SIZ  (sizeof(knh_asmc_jmp_iff_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
} knh_asmc_jmp_iff_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_jmp_iff_sfp_tw;

#define KNH_ASMC_JMP_IFF_sfp_SIZ  (sizeof(knh_asmc_jmp_iff_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ofp_t a2;
} knh_asmc_jmp_iff_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ofp_t a2;
	void *w;
} knh_asmc_jmp_iff_ofp_tw;

#define KNH_ASMC_JMP_IFF_ofp_SIZ  (sizeof(knh_asmc_jmp_iff_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_u1_t a3;
	Object* a2;
} knh_asmc_jmp_iff_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_u1_t a3;
	Object* a2;
	void *w;
} knh_asmc_jmp_iff_oidx_tw;

#define KNH_ASMC_JMP_IFF_OIDX_SIZ  (sizeof(knh_asmc_jmp_iff_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ebp_t a2;
} knh_asmc_jmp_ifn_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ebp_t a2;
	void *w;
} knh_asmc_jmp_ifn_ebp_tw;

#define KNH_ASMC_JMP_IFN_ebp_SIZ  (sizeof(knh_asmc_jmp_ifn_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
} knh_asmc_jmp_ifn_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_jmp_ifn_sfp_tw;

#define KNH_ASMC_JMP_IFN_sfp_SIZ  (sizeof(knh_asmc_jmp_ifn_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ofp_t a2;
} knh_asmc_jmp_ifn_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ofp_t a2;
	void *w;
} knh_asmc_jmp_ifn_ofp_tw;

#define KNH_ASMC_JMP_IFN_ofp_SIZ  (sizeof(knh_asmc_jmp_ifn_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_u1_t a3;
	Object* a2;
} knh_asmc_jmp_ifn_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_u1_t a3;
	Object* a2;
	void *w;
} knh_asmc_jmp_ifn_oidx_tw;

#define KNH_ASMC_JMP_IFN_OIDX_SIZ  (sizeof(knh_asmc_jmp_ifn_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ebp_t a2;
} knh_asmc_jmp_ifnn_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ebp_t a2;
	void *w;
} knh_asmc_jmp_ifnn_ebp_tw;

#define KNH_ASMC_JMP_IFNN_ebp_SIZ  (sizeof(knh_asmc_jmp_ifnn_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
} knh_asmc_jmp_ifnn_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_jmp_ifnn_sfp_tw;

#define KNH_ASMC_JMP_IFNN_sfp_SIZ  (sizeof(knh_asmc_jmp_ifnn_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ofp_t a2;
} knh_asmc_jmp_ifnn_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_ofp_t a2;
	void *w;
} knh_asmc_jmp_ifnn_ofp_tw;

#define KNH_ASMC_JMP_IFNN_ofp_SIZ  (sizeof(knh_asmc_jmp_ifnn_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_u1_t a3;
	Object* a2;
} knh_asmc_jmp_ifnn_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_u1_t a3;
	Object* a2;
	void *w;
} knh_asmc_jmp_ifnn_oidx_tw;

#define KNH_ASMC_JMP_IFNN_OIDX_SIZ  (sizeof(knh_asmc_jmp_ifnn_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	knhvm_sfp_t a3;
} knh_asmc_next_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	knhvm_sfp_t a3;
	void *w;
} knh_asmc_next_tw;

#define KNH_ASMC_NEXT_SIZ  (sizeof(knh_asmc_next_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	knhvm_sfp_t a3;
	knhvm_class_t a4;
} knh_asmc_mapnext_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	knhvm_sfp_t a3;
	knhvm_class_t a4;
	void *w;
} knh_asmc_mapnext_tw;

#define KNH_ASMC_MAPNEXT_SIZ  (sizeof(knh_asmc_mapnext_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	knhvm_sfp_t a3;
	Object* a4;
} knh_asmc_smapnext_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	knhvm_sfp_t a3;
	Object* a4;
	void *w;
} knh_asmc_smapnext_tw;

#define KNH_ASMC_SMAPNEXT_SIZ  (sizeof(knh_asmc_smapnext_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	knhvm_sfp_t a3;
} knh_asmc_try_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	knhvm_sfp_t a3;
	void *w;
} knh_asmc_try_tw;

#define KNH_ASMC_TRY_SIZ  (sizeof(knh_asmc_try_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
} knh_asmc_try_wc_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a2;
	void *w;
} knh_asmc_try_wc_tw;

#define KNH_ASMC_TRY_WC_SIZ  (sizeof(knh_asmc_try_wc_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
} knh_asmc_try_end_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	void *w;
} knh_asmc_try_end_tw;

#define KNH_ASMC_TRY_END_SIZ  (sizeof(knh_asmc_try_end_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a3;
	Object* a2;
} knh_asmc_catch_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_addr_t a1;
	knhvm_sfp_t a3;
	Object* a2;
	void *w;
} knh_asmc_catch_tw;

#define KNH_ASMC_CATCH_SIZ  (sizeof(knh_asmc_catch_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
} knh_asmc_throw_again_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	void *w;
} knh_asmc_throw_again_tw;

#define KNH_ASMC_THROW_AGAIN_SIZ  (sizeof(knh_asmc_throw_again_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
} knh_asmc_throw_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_ebp_t a1;
	void *w;
} knh_asmc_throw_ebp_tw;

#define KNH_ASMC_THROW_ebp_SIZ  (sizeof(knh_asmc_throw_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
} knh_asmc_throw_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_sfp_t a1;
	void *w;
} knh_asmc_throw_sfp_tw;

#define KNH_ASMC_THROW_sfp_SIZ  (sizeof(knh_asmc_throw_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
} knh_asmc_throw_obj_t;

typedef struct {
	knhvm_opcode_t code;
	Object* a1;
	void *w;
} knh_asmc_throw_obj_tw;

#define KNH_ASMC_THROW_OBJ_SIZ  (sizeof(knh_asmc_throw_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	knhvm_ebp_t a4;
	Object* a2;
} knh_asmc_print_ebp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	knhvm_ebp_t a4;
	Object* a2;
	void *w;
} knh_asmc_print_ebp_tw;

#define KNH_ASMC_PRINT_ebp_SIZ  (sizeof(knh_asmc_print_ebp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	knhvm_sfp_t a4;
	Object* a2;
} knh_asmc_print_sfp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	knhvm_sfp_t a4;
	Object* a2;
	void *w;
} knh_asmc_print_sfp_tw;

#define KNH_ASMC_PRINT_sfp_SIZ  (sizeof(knh_asmc_print_sfp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	knhvm_ofp_t a4;
	Object* a2;
} knh_asmc_print_ofp_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	knhvm_ofp_t a4;
	Object* a2;
	void *w;
} knh_asmc_print_ofp_tw;

#define KNH_ASMC_PRINT_ofp_SIZ  (sizeof(knh_asmc_print_ofp_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	Object* a2;
	Object* a4;
} knh_asmc_print_obj_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	Object* a2;
	Object* a4;
	void *w;
} knh_asmc_print_obj_tw;

#define KNH_ASMC_PRINT_OBJ_SIZ  (sizeof(knh_asmc_print_obj_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	knhvm_u1_t a5;
	Object* a2;
	Object* a4;
} knh_asmc_print_oidx_t;

typedef struct {
	knhvm_opcode_t code;
	knhvm_u2_t a1;
	knhvm_methodn_t a3;
	knhvm_u1_t a5;
	Object* a2;
	Object* a4;
	void *w;
} knh_asmc_print_oidx_tw;

#define KNH_ASMC_PRINT_OIDX_SIZ  (sizeof(knh_asmc_print_oidx_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

typedef struct {
	knhvm_opcode_t code;
} knh_asmc_nop_t;

typedef struct {
	knhvm_opcode_t code;
	void *w;
} knh_asmc_nop_tw;

#define KNH_ASMC_NOP_SIZ  (sizeof(knh_asmc_nop_tw)-sizeof(void*))

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHAC_ASM__H*/
