/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

#ifndef KONOHA_KNHAPI__H
#define KONOHA_KNHAPI__H

#include<konoha/gen/konoha_class_.h>


#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */

/* ======================================================================== */
/* [MACROS] */
#define knh_AffineConv_struct_copy      NULL
#define knh_AffineConv_struct_compare   NULL
#define knh_AffineConv_struct_traverse  NULL
#define KNH_FLAG_MMF_AFFINE (KNH_FLAG_MMF_SIGNIFICANT|KNH_FLAG_MMF_SYNONYM|KNH_FLAG_MMF_TOTAL|KNH_FLAG_MMF_CONST)
#define knh_Array_n(a,n)      (a)->list[(n)]
#define knh_Array_size(a)     (a)->size
#define IS_TRUE(o)         (o == KNH_TRUE)
#define IS_FALSE(o)        (o == KNH_FALSE)
#define BOOL_ISTRUE(o)         (o == KNH_TRUE)
#define BOOL_ISFALSE(o)        (o == KNH_FALSE)
#define new_Boolean(ctx,b)     ((b) ? KNH_TRUE : KNH_FALSE)
#define knh_Bytes_size(o)      (o)->size
#define knh_Bytes_value(o)     (o)->buf
#define knh_Bytes_last(o)      ((o)->buf + (o)->size)
#define knh_Bytes_tochar(b)  (char*)knh_Bytes_value(b)
#define KNH_SIZE(v)         knh_size(v)
#define B(c)     new_bytes(c)
#define B2(c,n)   new_bytes__2(c,n)
#define STEXT(c)  new_bytes__2(c,sizeof(c)-1)
#define ISB(t,c) (t.len == (sizeof(c)-1) && knh_strncmp((char*)t.buf,c,t.len) == 0)
#define knh_BytesConv_struct_copy NULL
#define knh_BytesConv_struct_compare NULL
#define CLASS_newid          ((knh_class_t)-1)
#define CLASS_unknown        ((knh_class_t)-2)
#define knh_Class_cid(c)     (knh_class_t)(c)->cid
#define IS_SPEC(o)   (CLASS_IntUnit <= knh_Object_cid(o)  && knh_Object_cid(o) <= CLASS_Vocabulary)
#define KNH_FLAG_TF_NN                KNH_FLAG_T0
#define TYPE_ISNULLABLE(t)            ((t & KNH_FLAG_TF_NN)==0)
#define TYPE_ISNOTNULL(t)             ((t & KNH_FLAG_TF_NN)==KNH_FLAG_TF_NN)
#define CLASS_TONNTYPE(c)             (c|KNH_FLAG_TF_NN)
#define TYPE_TONNTYPE(t)              (t|KNH_FLAG_TF_NN)
#define TYPE_UNMASK(t)                (t&(~(KNH_FLAG_TF_NN|KNH_FLAG_T1)))
#define TYPE_UNMASK_NN(t)             (t&(~KNH_FLAG_TF_NN))
#define TYPEQN(t)                     TYPEN(t), TYPEQ(t)
#define TYPE_void                     CLASS_TONNTYPE(CLASS_Nue)
#define NNTYPE_void                   CLASS_TONNTYPE(CLASS_Nue)
#define TYPE_any                      CLASS_Any
#define NNTYPE_any                    CLASS_any
#define TYPEN(type)  knh_TYPEN(ctx,type)
#define knh_ClassMap_struct_copy    NULL
#define knh_ClassMap_struct_compare  NULL
#define knh_tstruct_isNative(sid)   (sid < KONOHA_TSTRUCT_SIZE)
#define knh_ClassStruct_struct_copy    NULL
#define knh_Class_getMethod(ctx, c, mn)    knh_Class_getMethod__(ctx, c, mn, 0)
#define knh_Class_findMethod(ctx, c, mn)   knh_Class_getMethod__(ctx, c, mn, 1)
#define knh_Connection_struct_copy    NULL
#define knh_Connection_struct_compare  NULL
#define KNH_STDIN          (((Context*)ctx)->in)
#define KNH_STDOUT         (((Context*)ctx)->out)
#define KNH_STDERR         (((Context*)ctx)->err)
#define knh_DictIdx_struct_copy   NULL
#define new_DictSet(ctx, c)   new_DictSet0(ctx, c)
#define knh_Exception_eid(o)   (o)->eid
#define knh_Exception_struct_copy   NULL
#define knh_Exception_struct_compare  NULL
#define new_Exception__s(ctx, s)     new_Exception__b(ctx, B(s))
#define KNH_SETJUMP(hdlr)   setjmp(DP((ExceptionHandler*)hdlr)->jmpbuf)
#define knh_ExceptionHandler_struct_copy   NULL
#define knh_ExceptionHandler_struct_compare  NULL
#define knh_Float_value(o)    (o)->value
#define knh_FloatUnit_struct_copy    NULL
#define knh_FloatUnit_struct_compare NULL
#define LRUMap                          HashMap
#define knh_LRUMap                      knh_HashMap_struct
#define new_LRUMap(ctx,n)               new_HashMap(ctx,n)
#define knh_LRUMap_get(ctx,b,kh,ko)     knh_HashMap_get(ctx,b,kh,ko)
#define knh_LRUMap_set(ctx,b,kh,ko,v)   knh_HashMap_set(ctx,b,kh,ko,v)
#define knh_HashMap_struct_copy NULL
#define knh_HashMap_struct_compare NULL
#define knh_HashSet_struct_copy NULL
#define knh_HashSet_struct_compare NULL
#define knh_InputStream_struct_copy   NULL
#define knh_InputStream_struct_compare  NULL
#define knh_Int_value(o)      (o)->value
#define knh_IntUnit_isBuffered(u,n)   (DP(u)->bfarray != NULL && DP(u)->bfoffset <= n && n < DP(u)->bfoffset + DP(u)->bfsize)
#define knh_IntUnit_struct_copy    NULL
#define knh_IntUnit_struct_compare NULL
#define knh_Iterator_cid(it)           DP(it)->cid
#define knh_Iterator_source(it)        DP(it)->source
#define knh_Iterator_pos(it)           DP(it)->pos
#define knh_Iterator_setpos(it, p)     DP(it)->pos = p
#define knh_Iterator_ref(it)           DP(it)->ref
#define knh_LRUHashMap_struct_copy NULL
#define knh_HashMap_struct_compare NULL
#define knh_Mapper_struct_copy NULL
#define knh_Method_mn(mtd)    DP(mtd)->mn
#define knh_Method_mf(mtd)    DP(mtd)->mf
#define knh_Method_rtype(mtd)          knh_MethodField_rtype(knh_Method_mf(mtd))
#define knh_Method_psize(mtd)      knh_MethodField_psize(knh_Method_mf(mtd))
#define knh_Method_ptype(mtd,n)          knh_MethodField_ptype(knh_Method_mf(mtd),n)
#define knh_Method_pfields(mtd,n)   knh_MethodField_pfields(knh_Method_mf(mtd),n)
#define knh_Method_lastfield(mtd)   knh_MethodField_lastfield(knh_Method_mf(mtd))
#define knh_NameSpace_struct_copy  NULL
#define knh_NameSpace_struct_compare NULL
#define CTXCLASSN(cid)     knh_Context_CLASSN(ctx,cid)
#define CTXTYPEQN(cid)     knh_Context_CLASSN(ctx,TYPE_UNMASK_NN(cid)), TYPEQ(cid)
#define IS_NULL(o)          (((Object*)o)->h.cid == CLASS_Nue)
#define IS_NOTNULL(o)       (((Object*)o)->h.cid != CLASS_Nue)
#define new_Nue__b(ctx, txt)   new_Nue(ctx, new_String(ctx, txt, NULL));
#define new_Nue__s(ctx, txt)   new_Nue(ctx, new_String(ctx, B(txt), NULL));
#define knh_Object_cid(o)           (o)->h.cid
#define knh_Object_bcid(o)          (o)->h.bcid
#define knh_OutputStream_struct_copy      NULL
#define knh_OutputStream_struct_compare   NULL
#define knh_write_delim(ctx, w)    knh_write(ctx, w, STEXT(", "))
#define knh_write_dots(ctx, w)     knh_write(ctx, w, STEXT("..."))
#define knh_write__i(ctx, w, n)   knh_write__ifmt(ctx, w, KNH_INT_FMT, n)
#define knh_write__u(ctx, w, n)   knh_write__ifmt(ctx, w, KNH_UINT_FMT, n)
#define knh_write__x(ctx, w, n)   knh_write__ifmt(ctx, w, KNH_INT_FMTX, n)
#define knh_write__f(ctx, w, f)  knh_write__ffmt(ctx, w, KNH_FLOAT_FMT, f)
#define knh_write__e(ctx, w, f)  knh_write__ffmt(ctx, w, KNH_FLOAT_FMTE, f)
#define knh_write__fn(ctx, w, fn)   knh_write__s(ctx, w, FIELDN(fn))
#define knh_write__O(ctx, w, o)    knh_format(ctx, w, METHODN__k, o, KNH_NULL)
#define knh_Object_toString(ctx, b)   knh_Object_movableText(ctx, b, METHODN__s, KNH_NULL)
#define knh_ResultSet_struct_copy NULL
#define knh_ResultSet_struct_compare NULL
#define knh_Runtime_struct_copy  NULL
#define knh_Runtime_struct_compare NULL
#define knh_String_value(o)   ((o)->str)
#define knh_String_tochar(o)  (char*)((o)->str)
#define knh_String_strlen(o)  (o)->size
#define knh_bytes_hcode(t)     knh_string_hash((t).buf, (t).len)
#define knh_StringUnit_struct_copy   NULL
#define knh_StringUnit_struct_compare  NULL
#define NSN_main           0
#define FILEN_unknown      0
#define knh_Compiler_struct_copy   NULL
#define knh_Compiler_struct_compare  NULL
#define knh_KLRCode_struct_compare  NULL
#define KNH_PERRATA_(ctx, f, l, msgo, msgn)    knh_perrata(ctx, f, l, msgo, msgn)
#define KNH_PERRATA(ctx, tk, msg)  knh_perrata(ctx, (tk)->fileid, (tk)->line, knh_Token_tochar(tk), msg)
#define knh_Stmt_struct_copy  NULL
#define knh_Stmt_struct_compare  NULL
#define knh_Stmt_terms_cmpl(ctx, stmt, n, cpr, ns, reqt, level)      knh_Stmt_terms_cmpl_(ctx, stmt, n, cpr, ns, reqt, level, 0)
#define knh_Stmt_terms_cmplpush(ctx, stmt, n, cpr, ns, reqt, level)  knh_Stmt_terms_cmpl_(ctx, stmt, n, cpr, ns, reqt, level, 1)
#define knh_Token_struct_copy  NULL
#define knh_Token_struct_compare  NULL
#define KNH_FLAG_CF2OF(f)        (f)
#define knh_tClass_isPMZ(cid)    (knh_tClass[cid].p1 != CLASS_Nue)
#define DEBUG_ASSERT_cid(cid)    KNH_ASSERT(IS_cid(cid))
#define CLASSN(cid)   knh_String_tochar(knh_tClass[cid].lname)
#define CLASSNo(o)    knh_String_tochar(knh_tClass[(o)->h.cid].lname)
#define EXPT_unknown  ((knh_expt_t)-1)
#define EXPT_newid    ((knh_expt_t)0)
#define DEBUG_ASSERT_eid(cid)    KNH_ASSERT(IS_eid(cid))
#define EXPTN(eid)   knh_String_tochar(knh_tExpt_name(eid))
#define KNH_TMAPMAP  KNH_TMAPPER
#define FIELDN_NONAME    ((knh_fieldn_t)-1)
#define FIELDN_NEWID     ((knh_fieldn_t)-2)
#define FIELDN_return    FIELDN_
#define METHODN_NONAME   ((knh_methodn_t)-1)
#define METHODN_NEWID    ((knh_methodn_t)-2)
#define KNH_FLAG_FN_SUPER   KNH_FLAG_T0
#define KNH_FLAG_FN_U1      KNH_FLAG_T1
#define KNH_FLAG_FN_U2      KNH_FLAG_T2
#define FIELDN_IS_SUPER(fnq)       ((fnq & KNH_FLAG_FN_SUPER) == KNH_FLAG_FN_SUPER)
#define FIELDN_IS_U1(fnq)          ((fnq & KNH_FLAG_FN_U1) == KNH_FLAG_FN_U1)
#define FIELDN_IS_U2(fnq)          ((fnq & KNH_FLAG_FN_U2) == KNH_FLAG_FN_U2)
#define FIELDN_IS_PROTECTED(fnq)   (FIELDN_IS_U1(fnq)||FIELDN_IS_U2(fnq))
#define FIELDN_UNMASK(fnq)         (fnq & (~(KNH_FLAG_FN_SUPER|KNH_FLAG_FN_U1|KNH_FLAG_FN_U2)))
#define KNH_FLAG_MN_SUPER        KNH_FLAG_T0
#define KNH_FLAG_MN_GETTER       KNH_FLAG_T1
#define KNH_FLAG_MN_SETTER       KNH_FLAG_T2
#define KNH_FLAG_MN_MOVTEXT      (KNH_FLAG_T1|KNH_FLAG_T2)
#define KNH_FLAG_MN_FIELDN       (~(KNH_FLAG_T0|KNH_FLAG_T1|KNH_FLAG_T2))
#define METHODN_IS_GETTER(mn)   ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_GETTER)
#define METHODN_TO_GETTER(mn)   (mn | KNH_FLAG_MN_GETTER)
#define METHODN_IS_SETTER(mn)   ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_SETTER)
#define METHODN_TO_SETTER(mn)   (mn | KNH_FLAG_MN_SETTER)
#define METHODN_IS_MOVTEXT(mn)  ((mn & KNH_FLAG_MN_MOVTEXT) == KNH_FLAG_MN_MOVTEXT)
#define METHODN_TO_MOVTEXT(mn)  (mn | KNH_FLAG_MN_MOVTEXT)
#define METHODN_TOFIELDN(mn)     (mn & KNH_FLAG_MN_FIELDN)
#define FIELDN(fn) knh_String_tochar(knh_tfieldn_name(fn))
#define FILEIDN(fileid) knh_String_tochar(knh_tfileid_name(fileid))
#define new_Object_malloc(ctx, flag, cid, size)   new_ObjectX_malloc(ctx, flag, cid, cid, size)
#define IS_SWEEP(f)   (f == knh_Object_RCsweep)
#define knh_rootNameSpace    DP(knh_rootSystem)->ns
#define knh_systemEncoding    DP(knh_rootSystem)->enc
#define knh_systemStdIn       DP(knh_rootSystem)->in
#define knh_systemStdOut      DP(knh_rootSystem)->out
#define knh_systemStdErr      DP(knh_rootSystem)->err
#define knh_tMethodField_add(ctx, mf)       knh_Array_add(ctx, DP(knh_rootSystem)->tMethodFields, UP(mf))
#define knh_tMethodField(n)                 (MethodField*)knh_Array_n(DP(knh_rootSystem)->tMethodFields, n)
#define knh_tMethodField_size               knh_Array_size(DP(knh_rootSystem)->tMethodFields)
#define new_Int(ctx, n)      new_Int__fast(ctx, CLASS_Int, (n))
#define new_Float(ctx, n)      new_Float__fast(ctx, CLASS_Float, (n))
#define new_String__T(ctx, text)    new_StringX__T(ctx, CLASS_String, text)
#define KNH_FLAG_SF_FIELD          KNH_FLAG_T1
#define STRUCT_ISFIELD(sid)        ((sid & KNH_FLAG_SF_FIELD) == KNH_FLAG_SF_FIELD)
#define BSIZE_TOSID(bsize)         (((knh_struct_t)bsize)|KNH_FLAG_SF_FIELD)
#define STRUCT_FIELD(bsize)        (((knh_struct_t)bsize)|KNH_FLAG_SF_FIELD)
#define STRUCT_FIELDSIZE(sid)      (sid & (~KNH_FLAG_SF_FIELD))
#define STRUCT_UNMASK(sid)         (sid & (~KNH_FLAG_SF_FIELD))
#define DEBUG_ASSERT_sid(sid)   KNH_ASSERT(IS_sid(sid))
#define STRUCTN(sid)   knh_tstruct_name(sid)
#define KNH_LOPEN(ctx, n) \
	knh_sfp_t *lbp_ = ((Context*)ctx)->ebp + 1; \
	knh_stackf_locals(ctx, n) \


#define KNH_LOCALn(n)                 (lbp_[n].o)
#define KNH_LSETv(ctx, n, v)          KNH_SETv(ctx, lbp_[n].o, v)
#define KNH_LCLOSE(ctx)               ((Context*)ctx)->ebp = lbp_ - 1
#define KNH_LPUSH(ctx,v) \
	((Context*)ctx)->ebp++; \
	KNH_SETv(ctx, ((Context*)ctx)->ebp[0].o, v); \


#define KNH_PUSHv(ctx,v) \
	((Context*)ctx)->ebp++; \
	KNH_SETv(ctx, ((Context*)ctx)->ebp[0].o, v); \
*/

#define KNH_FLAG_PF_STDERR      KNH_FLAG_T0
#define KNH_FLAG_PF_EOL         KNH_FLAG_T1
#define KNH_FLAG_PF_TIME        KNH_FLAG_T2
#define KNH_FLAG_PF_FUNC        KNH_FLAG_T3
#define KNH_FLAG_PF_NAME        KNH_FLAG_T4
#define KNH_FLAG_PF_NOCOMMA     KNH_FLAG_T5
#define KNH_FLAG_PF_EMPTY       KNH_FLAG_T6
#define KNH_FLAG_PF_BOL         KNH_FLAG_T7
#define KNH_THROW(ctx, e) knh_throw(ctx, UP(e), KNH_SAFEFILE(__FILE__), __LINE__)
#define KNH_THROWs(ctx, s) \
	knh_throwException(ctx, new_Exception__b(ctx, B(s)), KNH_SAFEFILE(__FILE__), __LINE__); \


#define KNH_THROWf(ctx, fmt, ...) \
	char throwbuf_[256]; \
	knh_snprintf(throwbuf_, sizeof(throwbuf_), fmt, ## __VA_ARGS__); \
	knh_throwException(ctx, new_Exception__b(ctx, B(throwbuf_)), KNH_SAFEFILE(__FILE__), __LINE__); \


#define TODO_THROW(ctx) knh_throw_TODO(ctx, (char*)__FILE__, __LINE__, (char*)__FUNCTION__)

/* ======================================================================== */
/* [PROTOTYPE] */
KNHAPI(void) konoha_addAffineMapper(Ctx *ctx, knh_class_t scid, char *text, knh_float_t scale, knh_float_t shift);
KNHAPI(Bytes*) new_Bytes(Ctx *ctx, size_t capacity);
KNHAPI(knh_bytes_t) knh_Bytes_tobytes(Bytes *o);
KNHAPI(void) knh_Bytes_clear(Bytes *o);
KNHAPI(void) knh_Bytes_putc(Ctx *ctx, Bytes *o, int ch);
KNHAPI(void) knh_Bytes_write(Ctx *ctx, Bytes *o, knh_bytes_t v);
KNHAPI(Exception*) new_Exception(Ctx *ctx, String *msg);
KNHAPI(Exception*) new_Exception__b(Ctx *ctx, knh_bytes_t msg);
KNHAPI(Exception*) new_Exception__errno(Ctx *ctx);
KNHAPI(ClassSpec*) new_Unit(Ctx *ctx, char *tag, knh_float_t min, knh_float_t max, knh_float_t defv, knh_float_t step);
KNHAPI(InputStream*) new_FileInputStream(Ctx *ctx, knh_bytes_t file);
KNHAPI(InputStream*) new_BytesInputStream(Ctx *ctx, Bytes *ba, size_t s, size_t e);
KNHAPI(InputStream*) new_StringInputStream(Ctx *ctx, String *str, size_t s, size_t e);
KNHAPI(OutputStream*) new_FileOutputStream(Ctx *ctx, knh_bytes_t file, char *mode);
KNHAPI(OutputStream*) new_BytesOutputStream(Ctx *ctx, Bytes *ba);
KNHAPI(void) knh_putc(Ctx *ctx, OutputStream *w, int ch);
KNHAPI(void) knh_write(Ctx *ctx, OutputStream *w, knh_bytes_t s);
KNHAPI(void) knh_flush(Ctx *ctx, OutputStream *w);
KNHAPI(void) knh_print(Ctx *ctx, OutputStream *w, knh_bytes_t s);
KNHAPI(void) knh_println(Ctx *ctx, OutputStream *w, knh_bytes_t s);
KNHAPI(void) knh_write_EOL(Ctx *ctx, OutputStream *w);
KNHAPI(void) knh_write_TAB(Ctx *ctx, OutputStream *w);
KNHAPI(void) knh_write_BOL(Ctx *ctx, OutputStream *w);
KNHAPI(void) knh_format(Ctx *ctx, OutputStream *w, knh_methodn_t mn, Any *x, Any *m);
KNHAPI(void) knh_printf(Ctx *ctx, OutputStream *w, char *fmt, ...);
KNHAPI(ResultSet*) new_ResultSet(Ctx *ctx, knh_dbcur_t *dbcur, size_t column_size);
KNHAPI(void) knh_ResultSet_setName(Ctx *ctx, ResultSet *o, size_t n, String *name);
KNHAPI(void) knh_ResultSet_setInt(Ctx *ctx, ResultSet *o, size_t n, knh_integer_t value);
KNHAPI(void) knh_ResultSet_setFloat(Ctx *ctx, ResultSet *o, size_t n, knh_float_t value);
KNHAPI(void) knh_ResultSet_setText(Ctx *ctx, ResultSet *o, size_t n, knh_bytes_t t);
KNHAPI(void) knh_ResultSet_setBLOB(Ctx *ctx, ResultSet *o, size_t n, knh_bytes_t t);
KNHAPI(void) knh_ResultSet_setNULL(Ctx *ctx, ResultSet *o, size_t n);
KNHAPI(void) konoha_addAliasURN(Ctx *ctx, char *alias, char *urn);
KNHAPI(String*) new_String_bconv(Ctx *ctx, String *s, f_bconv bconv);
KNHAPI(void) konoha_addParserDriver(Ctx *ctx, char *alias, knh_parser_drvapi_t *d);
KNHAPI(ClassSpec*) new_Vocabulary(Ctx *ctx, char *lang, char *defval, ...);
KNHAPI(void) konoha_addVocabularyMapper(Ctx *ctx, knh_class_t scid, char *text);
KNHAPI(void) konoha_addDBDriver(Ctx *ctx, char *alias, knh_db_drvapi_t *d);
KNHAPI(void) konoha_addIODriver(Ctx *ctx, char *alias, knh_iodrv_t *d);
KNHAPI(void) konoha_addRegexDriver(Ctx *ctx, char *alias, knh_regex_drvapi_t *d);
KNHAPI(size_t) knh_stat_usedMemorySize(void);
KNHAPI(f_traverse) konoha_sweep();
KNHAPI(int) konoha_issweep(f_traverse ftr);
KNHAPI(Int*) new_Int__fast(Ctx *ctx, knh_class_t cid, knh_integer_t value);
KNHAPI(Float*) new_Float__fast(Ctx *ctx, knh_class_t cid, knh_float_t value);
KNHAPI(void) konoha_addClassSpecFunc(Ctx *ctx, char *urn, f_makespec func);
KNHAPI(konoha_t) konoha_open(void);
KNHAPI(void) konoha_close(konoha_t konoha);
KNHAPI(Ctx*) konoha_open_context(konoha_t konoha);
KNHAPI(void) konoha_close_context(konoha_t konoha, Ctx *ctx);
KNHAPI(void) konoha_read(Ctx *ctx, char *fpath);
KNHAPI(int) konoha_main(Ctx *ctx, int argc, char **argv);
KNHAPI(void) konoha_SETv(Ctx *ctx, Object **v, Object *o);
KNHAPI(void) konoha_FINALv(Ctx *ctx, Object **v);
KNHAPI(knh_class_t) konoha_addVirtualClass(Ctx *ctx, char *name, int method_size);
KNHAPI(void) konoha_addMethod(Ctx *ctx, char *kscript, f_method f);
KNHAPI(void) konoha_addConst(Ctx *ctx, char *name, Object *o);
KNHAPI(void) konoha_addIntConst(Ctx *ctx, char *name, knh_int_t value);
KNHAPI(void) konoha_addFloatConst(Ctx *ctx, char *name, knh_float_t value);
KNHAPI(void) konoha_addStringConst(Ctx *ctx, char *name, char *text);
KNHAPI(void) konoha_addDriver(Ctx *ctx, char *name, int type, void *drv);
KNHAPI(char*) KNH_SAFEFILE(char *file);
KNHAPI(void) konoha_shell(Ctx *ctx);
KNHAPI(void) knh_throw_TODO(Ctx *ctx, char *file, int line, char *func);
KNHAPI(void) knh_throwException(Ctx *ctx, Exception *e, char *file, int line);
KNHAPI(void) knh_throw(Ctx *ctx, Object *e, char *file, int line);

#ifdef __cplusplus
}
#endif

/* ======================================================================== */

#endif/*KONOHA_KNHAPI__H*/
