/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

#include<konoha.h>

#ifdef __cplusplus
extern "C" {
#endif

int
main(int argc, char **argv)
{
	konoha_t k = konoha_open();
	Ctx *ctx = konoha_open_context(k);
	if(argc == 1) {
		konoha_shell(ctx);
	}
	else {
		if(knh_strncmp(argv[1], "-c", 2) == 0) {
			knh_Context_setCompiling(ctx, 1);
			konoha_read(ctx, argv[2]);
			konoha_main(ctx, argc - 3, argv + 3);
		}
		else {
			konoha_read(ctx, argv[1]);
			konoha_main(ctx, argc - 2, argv + 2);
		}
	}
	konoha_close_context(k, ctx);
	konoha_close(k);
	DBG2_P("remaining memory %d", (int)knh_stat_usedMemorySize());
	//DBG2_P("sizeof(Stmt)=%uld, sizeof(Token)=%uld", sizeof(knh_Stmt_struct), sizeof(knh_Token_struct));
	return 0;
}

#ifdef __cplusplus
}
#endif
