/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [operators] */

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opAdd(Int! v) */

METHOD knh__Int_opAdd(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0]) + ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opNeg() */

METHOD knh__Int_opNeg(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, -(ARG_int(sfp[0])));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opSub(Int! n) */

METHOD knh__Int_opSub(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0]) - ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opMul(Int! n) */

METHOD knh__Int_opMul(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0]) * ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opDiv(Int! n) */

METHOD knh__Int_opDiv(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0]) / ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opMod(Int! n) */

METHOD knh__Int_opMod(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0]) % ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST|NULLBASE] Boolean! Int.opEq(Int! value) */

METHOD knh__Int_opEq(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_int(sfp[0]) == ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST|NULLBASE] Boolean! Int.opNeq(Int! value) */

METHOD knh__Int_opNeq(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_int(sfp[0]) != ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Boolean! Int.opLt(Int! value) */

METHOD knh__Int_opLt(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_int(sfp[0]) < ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Boolean! Int.opLte(Int! value) */

METHOD knh__Int_opLte(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_int(sfp[0]) <= ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Boolean! Int.opGt(Int! value) */

METHOD knh__Int_opGt(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_int(sfp[0]) > ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Boolean! Int.opGte(Int! value) */

METHOD knh__Int_opGte(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Boolean(ctx, sfp, ARG_int(sfp[0]) >= ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|CONST] Int! Int.opLand(Int! v) */

METHOD knh__Int_opLand(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
	knh_sfp_t *v = sfp + 1;
	knh_integer_t n = ARG_int(sfp[0]);
	size_t i;
	for(i = 0; i < ac; i++) {
		n = n & ARG_int(v[i]);
	}
	KNH_RETURN_Int(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[VARARGS|CONST] Int! Int.opLor(Int! v) */

METHOD knh__Int_opLor(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_vargc_t ac = knh_sfp_argc(ctx, sfp + 1);
	knh_sfp_t *v = sfp + 1;
	knh_integer_t n = ARG_int(sfp[0]);
	size_t i;
	for(i = 0; i < ac; i++) {
		n = n | ARG_int(v[i]);
	}
	KNH_RETURN_Int(ctx, sfp, n);
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opXor(Int! n) */

METHOD knh__Int_opXor(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0]) ^ ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opLnot() */

METHOD knh__Int_opLnot(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ~(ARG_int(sfp[0])));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opLshift(Int! n) */

METHOD knh__Int_opLshift(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0]) << ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opRshift(Int! n) */

METHOD knh__Int_opRshift(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0]) >> ARG_int(sfp[1]));
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opNext() */

METHOD knh__Int_opNext(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0])+1);
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] Int! Int.opPrev() */

METHOD knh__Int_opPrev(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN_Int(ctx, sfp, ARG_int(sfp[0])-1);
}

/* ------------------------------------------------------------------------ */
/* @method[NULLBASE|CONST] Int! Int.getSize() */

METHOD knh__Int_getSize(Ctx *ctx, knh_sfp_t *sfp)
{
	if(IS_NULL(sfp[0].o)) {
		KNH_RETURN_Int(ctx, sfp, 0);
	}
	else {
		knh_int_t n = ARG_int(sfp[0]);
		if(n >= 0) {
			KNH_RETURN(ctx, sfp, sfp[0].o);
		}
		else {
			KNH_RETURN_Int(ctx, sfp, -(n));
		}
	}
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] Int! Int.random(Int n) */

METHOD knh__Int_random(Ctx *ctx, knh_sfp_t *sfp)
{
	knh_int_t n = knh_rand();
	if(IS_NOTNULL(sfp[1].o)) {
		knh_int_t max = knh_abs(ARG_int(sfp[1]));
		if(max > 0) {
			KNH_RETURN_Int(ctx, sfp,  n % max);
		}
	}
	KNH_RETURN_Int(ctx, sfp, n % KNH_UINT_MAX);
}

/* ======================================================================== */
/* [mapping] */

/* ------------------------------------------------------------------------ */
/* @map String Int @Const @Final */

Int* knh_String_Int(Ctx *ctx, String *o, Mapper *mpr)
{
	return new_IntX__b(ctx, CLASS_Int, knh_String_tobytes(o));
}

/* ------------------------------------------------------------------------ */
/* @map Int String! @Const @Final */

String* knh_Int_String(Ctx *ctx, Int *o, Mapper *mpr)
{
	char buf[KNH_INTUNIT_BUFSIZ];
	knh_format_Int(buf, sizeof(buf), o);
	return new_String(ctx, B(buf), NULL);
}

/* ======================================================================== */
/* [movabletext] */

/* ------------------------------------------------------------------------ */
/* @method void Int.%s(OutputStream w, String m) */

void knh_Int__s(Ctx *ctx, Int *o, OutputStream *w, String *m)
{
	knh_write_integerfmt(ctx, w, KNH_INTEGER_FMT, (o)->value);
}

/* ------------------------------------------------------------------------ */
/* @method void Int.%d(OutputStream w, String m) */

void knh_Int__d(Ctx *ctx, Int *o, OutputStream *w, String *m)
{
	if(IS_String(m)) {
		char fmt[40];
		knh_format_newFMT(fmt, sizeof(fmt), knh_String_tobytes(m), 0, KNH_INTEGER_FMT);
		knh_write_integerfmt(ctx, w, fmt, (o)->value);
	}
	else {
		knh_write_integerfmt(ctx, w, KNH_INTEGER_FMT, (o)->value);
	}
}

/* ------------------------------------------------------------------------ */
/* @method void Int.%u(OutputStream w, String m) */

void knh_Int__u(Ctx *ctx, Int *o, OutputStream *w, String *m)
{
	if(IS_String(m)) {
		char fmt[40];
		knh_format_newFMT(fmt, sizeof(fmt), knh_String_tobytes(m), 0, KNH_UINTEGER_FMT);
		knh_write_integerfmt(ctx, w, fmt, (o)->value);
	}
	else {
		knh_write_integerfmt(ctx, w, KNH_UINTEGER_FMT, (o)->value);
	}
}

/* ------------------------------------------------------------------------ */
/* @method void Int.%f(OutputStream w, String m) */

void knh_Int__f(Ctx *ctx, Int *o, OutputStream *w, String *m)
{
	if(IS_String(m)) {
		char fmt[40];
		knh_format_newFMT(fmt, sizeof(fmt), knh_String_tobytes(m), 1, KNH_FLOAT_FMT);
		knh_write__ffmt(ctx, w, KNH_FLOAT_FMT, (knh_float_t)o->value);
	}
	else {
		knh_write__f(ctx, w, (knh_float_t)o->value);
	}
}

/* ------------------------------------------------------------------------ */
/* @method void Int.%x(OutputStream w, String m) */

void knh_Int__x(Ctx *ctx, Int *o, OutputStream *w, String *m)
{
	knh_write_integerfmt(ctx, w, KNH_INTEGER_XFMT, o->value);
}

/* ------------------------------------------------------------------------ */

void knh_write_bits(Ctx *ctx, OutputStream *w, knh_uint64_t n, int bits)
{
	knh_uint64_t i, flag = 1 << (bits - 1);
	for(i = 0; i < (size_t)bits; i++) {
		if(i > 0 && i % 8 == 0) {
			knh_putc(ctx, w, ' ');
		}
		if((flag & n) == flag) {
			knh_putc(ctx, w, '1');
		}else{
			knh_putc(ctx, w, '0');
		}
		flag >>= 1;
	}
}

/* ------------------------------------------------------------------------ */
/* @method void Int.%bits(OutputStream w, String m) */

void knh_Int__bits(Ctx *ctx, Int *b, OutputStream *w, String *m)
{
	knh_write_bits(ctx, w, b->value, sizeof(knh_integer_t) * 8);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
