/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [drivers] */

/* ======================================================================== */
/* [NOP] */

static
knh_io_t knh_iodrv_fopen__NOP(Ctx *ctx, Object *io, knh_bytes_t n, char *mode)
{
	return 0;
}

/* ------------------------------------------------------------------------ */

static size_t knh_iodrv_fread__NOP(Ctx *ctx, knh_io_t fd, char *buf, size_t bufsiz)
{
	return 0;
}

/* ------------------------------------------------------------------------ */

static size_t knh_iodrv_fwrite__NOP(Ctx *ctx, knh_io_t fd, char *buf, size_t bufsiz)
{
	return bufsiz;
}

/* ------------------------------------------------------------------------ */

static void knh_iodrv_fclose__NOP(Ctx *ctx, knh_io_t fd)
{

}

/* ======================================================================== */
/* [FILE] */

static knh_io_t knh_iodrv_fopen__FILE(Ctx *ctx, Object *io, knh_bytes_t file, char *mode)
{
	char buf[FILENAME_BUFSIZ];
	knh_format_ospath(buf, sizeof(buf), file);
	DBG2_P("opening '%s'", buf);
	{
		FILE *fp = knh_fopen(buf, mode);
		if(fp == NULL) {
			//KNH_THROWf(ctx, "IO!!: cannot open: %s, mode='%s'\n", (char*)file.buf, mode);
			return (knh_io_t)-1;
		}
		return (knh_io_t)fp;
	}
}

/* ------------------------------------------------------------------------ */

static
size_t knh_iodrv_fread__FILE(Ctx *ctx, knh_io_t fd, char *buf, size_t bufsiz)
{
	FILE *fp = (FILE*)fd;
	size_t ssize = fread(buf, 1, bufsiz, fp);
	return ssize;
}

/* ------------------------------------------------------------------------ */

static
size_t knh_iodrv_fwrite__FILE(Ctx *ctx, knh_io_t fd, char *buf, size_t bufsiz)
{
	FILE *fp = (FILE*)fd;
	size_t ssize = fwrite(buf, 1, bufsiz, fp);
	fflush(fp);
	return ssize;
}

/* ------------------------------------------------------------------------ */

static
void knh_iodrv_fclose__FILE(Ctx *ctx, knh_io_t fd)
{
	FILE *fp = (FILE*)fd;
	knh_fclose(fp);
}

/* ======================================================================== */

static knh_iodrv_t IO__NOP = {
	KNH_DRVAPI_TYPE__IO, "NOP",
	0,
	knh_iodrv_fopen__NOP,
	knh_iodrv_fread__NOP,
	knh_iodrv_fwrite__NOP,
	knh_iodrv_fclose__NOP
};

static knh_iodrv_t IO__FILE = {
	KNH_DRVAPI_TYPE__IO, "file",
	4096,
	knh_iodrv_fopen__FILE,
	knh_iodrv_fread__FILE,
	knh_iodrv_fwrite__FILE,
	knh_iodrv_fclose__FILE
};

static knh_iodrv_t IO__stdio = {
	KNH_DRVAPI_TYPE__IO, "stdio",
	4096,
	knh_iodrv_fopen__NOP,
	knh_iodrv_fread__FILE,
	knh_iodrv_fwrite__FILE,
	knh_iodrv_fclose__NOP
};

/* ------------------------------------------------------------------------ */

knh_iodrv_t *knh_System_getIODriver(Ctx *ctx, knh_bytes_t name)
{
	knh_iodrv_t *p = (knh_iodrv_t*)knh_System_getDRVAPI(ctx, KNH_DRVAPI_TYPE__IO, name);
	if(p == NULL) {
		KNH_WARNING(ctx, "IO!!: unsupported scheme '%s'", name);
		p = &IO__NOP;
	}
	return p;
}

/* ------------------------------------------------------------------------ */

knh_iodrv_t knh_System_getDefaultIODriver()
{
	return IO__NOP;
}

/* ------------------------------------------------------------------------ */

knh_iodrv_t knh_System_getStdIODriver()
{
	return IO__stdio;
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) konoha_addIODriver(Ctx *ctx, char *alias, knh_iodrv_t *d)
{
	KNH_TDRVAPI(ctx, alias, (knh_drvapi_t*)d);
}

/* ------------------------------------------------------------------------ */

void KNHINIT init_IO(Ctx *ctx)
{
	konoha_addIODriver(ctx, NULL, &IO__NOP);
	konoha_addIODriver(ctx, NULL, &IO__FILE);
	//konoha_addIODriver(ctx, NULL, &IO__stdio);
}


/* ======================================================================== */
/* [mappings] */


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
