/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method[STATIC] InputStream! System.getIn() */

METHOD knh__System_getIn(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, DP(knh_rootSystem)->in);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] void System.setIn(InputStream in) */

METHOD knh__System_setIn(Ctx *ctx, knh_sfp_t *sfp)
{
	if(knh_Context_isAdmin(ctx)) {
		if(IS_NULL(sfp[1].o)) {
			KNH_SETv(ctx, DP(knh_rootSystem)->in, knh_tClass_defaultValue(ctx, CLASS_InputStream));
		}
		else {
			KNH_SETv(ctx, DP(knh_rootSystem)->in, sfp[1].o);
		}
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] OutputStream! System.getOut() */

METHOD knh__System_getOut(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, DP(knh_rootSystem)->out);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] void System.setOut(OutputStream out) */

METHOD knh__System_setOut(Ctx *ctx, knh_sfp_t *sfp)
{
	if(knh_Context_isAdmin(ctx)) {
		if(IS_NULL(sfp[1].o)) {
			KNH_SETv(ctx, DP(knh_rootSystem)->out, knh_tClass_defaultValue(ctx, CLASS_OutputStream));
		}
		else {
			KNH_SETv(ctx, DP(knh_rootSystem)->out, sfp[1].o);
		}
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] OutputStream! System.getErr() */

METHOD knh__System_getErr(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, DP(knh_rootSystem)->err);
}

/* ------------------------------------------------------------------------ */
/* @method[STATIC] void System.setStdErr(OutputStream out) */

METHOD knh__System_setErr(Ctx *ctx, knh_sfp_t *sfp)
{
	if(knh_Context_isAdmin(ctx)) {
		if(IS_NULL(sfp[1].o)) {
			KNH_SETv(ctx, DP(knh_rootSystem)->err, knh_tClass_defaultValue(ctx, CLASS_OutputStream));
		}
		else {
			KNH_SETv(ctx, DP(knh_rootSystem)->err, sfp[1].o);
		}
	}
	KNH_RETURN_void(ctx, sfp);
}

/* ======================================================================== */
/* [movabletext] */

/* @method void System.%k(OutputStream w, String m) */

void knh_System__k(Ctx *ctx, System *o, OutputStream *w, String *m)
{
#ifdef KONOHA_UNDER_GPL2
	knh_printf(ctx, w, "Konoha %s-GPL2 (#%d, %s, %s)\n", KONOHA_VERSION, KONOHA_BUILDID, __DATE__, __TIME__);
#else
	knh_printf(ctx, w, "Konoha %s (#%d, %s, %s)\n" TERM_INIT, KONOHA_VERSION, KONOHA_BUILDID, __DATE__, __TIME__);
#endif
	knh_printf(ctx, w, "[%s] on %s (%d, %s)\n", KONOHA_CC_VERSION, KONOHA_OS, sizeof(void*) * 8, konoha_encoding());
	knh_write__s(ctx, w, "Options:");

#ifdef KNH_USING_ICONV
	knh_write__s(ctx, w, " iconv");
#endif
#ifdef KNH_USING_INT64
	knh_write__s(ctx, w, " int64");
#endif
#ifdef KNH_USING_MATH
	knh_write__s(ctx, w, " math");
#endif
#ifdef KNH_USING_THREAD
	knh_write__s(ctx, w, " thread");
#endif
#ifdef KNH_USING_REGEX
	knh_write__s(ctx, w, " regex");
#endif
	knh_write_EOL(ctx, w);
}

/* ------------------------------------------------------------------------ */
/* @method void System.%dump(OutputStream w, String m) */

void knh_System__dump(Ctx *ctx, System *o, OutputStream *w, String *m)
{
	knh_System__k(ctx, o, w, m);
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
