/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include<konoha.h>

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */

static
size_t bconv__toEncodedURL(Ctx *ctx, BytesConv *o, knh_bytes_t in, knh_Bytes_t *out)
{
	TODO_THROW(ctx);
//	@from(bconv__toLower)
//	int i;
//	for(i = 0; i < in.len; i++) {
//		if(isupper(in.buf[i])) {
//			knh_Bytes_putc(ctx, out, tolower(in.buf[i]));
//		}
//		else {
//			knh_Bytes_putc(ctx, out, in.buf[i]);
//		}
//	}
	return in.len;
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] String! String.toEncodedURL() */

static
METHOD knh__String_toEncodedURL(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, new_String_bconv(ctx, sfp[0].s, bconv__toEncodedURL));
}

/* ------------------------------------------------------------------------ */

static
size_t bconv__toDecodedURL(Ctx *ctx, BytesConv *o, knh_bytes_t in, knh_Bytes_t *out)
{
	TODO_THROW(ctx);
//	@from(bconv__toUpper)
//	int i;
//	for(i = 0; i < in.len; i++) {
//		if(islower(in.buf[i])) {
//			knh_Bytes_putc(ctx, out, toupper(in.buf[i]));
//		}
//		else {
//			knh_Bytes_putc(ctx, out, in.buf[i]);
//		}
//	}
	return in.len;
}

/* ------------------------------------------------------------------------ */
/* @method[CONST] String! String.toDecodedURL() */

static
METHOD knh__String_toDecodedURL(Ctx *ctx, knh_sfp_t *sfp)
{
	KNH_RETURN(ctx, sfp, new_String_bconv(ctx, sfp[0].s, bconv__toDecodedURL));
}

/* ======================================================================== */
/* [KNHAPI] */

KNHAPI(int) knhcgi_init(Ctx *ctx)
{
	KNH_NOTICE(ctx, "loading cgi..");
	konoha_addMethod(ctx, "@Const String! String.toEncodedURL()", knh__String_toEncodedURL);
	konoha_addMethod(ctx, "@Const String! String.toDecodedURL()", knh__String_toDecodedURL);
	return 1;
}

/* ------------------------------------------------------------------------ */

KNHAPI(void) knhcgi_traverse(Ctx *ctx, f_traverse ftr)
{
	if(konoha_issweep(ftr)) {

	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
