#ifndef KONOHA_DEPS_H_
#define KONOHA_DEPS_H_
#include"konoha_t.h"
#include<stdlib.h>
#include<string.h>

/* ======================================================================== */
/* [UNIX] */

#ifdef KONOHA_OS__UNKONWN
	#define KNH_USING_POSIX 1
	#define KNH_USING_UNIX  1
	#define KONOHA_OS_ENCODING "UTF-8"
	#define KONOHA_OS_LINEFEED "\n"
#endif

#ifdef KONOHA_OS__LINUX
#define		KNH_USING_POSIX 1
#define		KNH_USING_UNIX  1
#define		KONOHA_OS_ENCODING "UTF-8"
#define		KONOHA_OS_LINEFEED "\n"
#define		KONOHA_OS_DLLEXT   ".so"
#ifdef KONOHA_CC_WITH_ECLIPSE
#define 	KNH_USING_READLINE 1
#endif
#endif

#ifdef KONOHA_OS__MACOSX
#define 	KNH_USING_POSIX    1
#define 	KNH_USING_UNIX     1
#define 	KNH_USING_ICONV    1
#define 	KNH_USING_REGEX    1
#define 	KONOHA_OS_ENCODING "UTF-8"
#define 	KONOHA_OS_LINEFEED "\n"
#define 	KONOHA_OS_DLLEXT ".dylib"
#ifdef KONOHA_CC_WITH_ECLIPSE
#define 	KNH_USING_READLINE 1
#define		KONOHA_MONOLITHIC  1
#endif
#endif

/* ======================================================================== */
/* [WINDOWS] */

#ifdef KONOHA_OS__WINDOWS
#define 	KNH_USING_WIN32    1
#define 	KNH_USING_WINDOWS  1
#define 	KONOHA_OS_LINEFEED "\r\n"
#ifdef KNHAPI_IMPORTS
#define 	KNHAPI(T)     __declspec(dllimport) T __stdcall
#else
#define 	KNHAPI(T)     __declspec(dllexport) T __stdcall
#endif
#define 	KONOHA_OS_DLLEXT ".dll"
#endif

#ifdef KONOHA_OS__MINGW
#define 	KNH_USING_WIN32    1
#define 	KNH_USING_WINDOWS  1
#define 	KONOHA_OS_LINEFEED "\r\n"
#ifdef KNHAPI_IMPORTS
#define 	KNHAPI(T) __declspec(dllimport) T __stdcall
#else
#define 	KNHAPI(T) __declspec(dllexport) T __stdcall
#endif
#define KONOHA_OS_DLLEXT ".dll"
#endif

#ifdef KONOHA_OS__CYGWIN
#define 	KNH_USING_POSIX    1
#define 	KNH_USING_UNIX     1
#define 	KNH_USING_REGEX    1
#define 	KONOHA_OS_LINEFEED "\r\n"
#define 	KONOHA_OS_DLLEXT ".dll"
#endif

/* ======================================================================== */
/* [WINDOWS] */

#ifdef KONOHA_OS__TBMX
#define 	KNH_USING_BTRON    1
#define 	KONOHA_OS_ENCODING KONOHA_ENCODING
#define 	KONOHA_OS_LINEFEED "\n"
#define 	KONOHA_OS_DLLEXT ".so"
#define     ALT_GETENV
#undef      KNH_USING_I18N
#endif

/* ======================================================================== */
/* [KNHAPI] */

#ifndef KNHAPI
#define KNHAPI(T)         T
#endif

#ifdef KONOHA_MONOLITHIC
#undef KNHAPI
#define KNHAPI(T)        T
#endif

/* ======================================================================== */
/* [CONFIG_H] */

#if !defined(KNH_USING_ICONV) && defined(HAVE_LIBICONV)
#define 	KNH_USING_ICONV 1
#endif

#if !defined(KNH_USING_REGEX) && defined(HAVE_REGCOMP)
#define 	KNH_USING_REGEX 1
#endif

/* ======================================================================== */

#ifndef KNH_USING_ICONV
#undef KNH_USING_I18N
#endif

/* ======================================================================== */
/* [stdlib] */

#ifdef ALT_SNPRINTF
#define knh_snprintf(b,n,fmt, ...)     ALT_snprintf(b,n,fmt, ## __VA_ARGS__)
#else
#ifdef _MSC_VER
#define knh_snprintf(b,n,fmt, ...)     _snprintf(b,n,fmt, ## __VA_ARGS__)
#else
#define knh_snprintf(b,n,fmt, ...)     snprintf(b,n,fmt, ## __VA_ARGS__)
#endif
#endif

/* ------------------------------------------------------------------------ */

#define knh_strlen(c)                  strlen(c)
#define knh_memcpy(d, s, n)            memcpy(d,s,n)
#define knh_bzero(s, n)                memset(s,0,n)
#define knh_strcmp(s1, s2)             strcmp(s1,s2)
#define knh_strncmp(s1, s2, n)         strncmp(s1,s2,n)

/* ------------------------------------------------------------------------ */

#ifdef ALT_SORT
#define  knh_sort(b,s,w,f)     ALT_sort(b,s,w,f)
#define  knh_qsort(b,s,w,f)    ALT_qsort(b,s,w,f)
#else
#define  knh_sort(b,s,w,f)     qsort(b,s,w,f)
#define  knh_qsort(b,s,w,f)    qsort(b,s,w,f)
#endif

/* ------------------------------------------------------------------------ */

#ifdef ALT_FOPEN
	#define knh_fopen(p,o)           ALT_fopen(p,o)
#else
	#define knh_fopen(p,o)           fopen(p,o)
#endif
#define knh_fclose(fp)               fclose(fp)

/* ======================================================================== */

#ifdef KNH_USING_POSIX
	#include<dlfcn.h>              /* @using dl -ldl */
	#define knh_dlopen(p,m)         dlopen(p,m)
	#define knh_dlsym(hdr,name)     dlsym(hdr,name)
	#define knh_dlerror()           dlerror()
	#define knh_dlclose(hdr)        dlclose(hdr)
#define KNH_RTLD_LAZY               RTLD_LAZY
#else
	#define knh_dlopen(p,m)         ALT_dlopen(p,m)
	#define knh_dlsym(hdr,name)     ALT_dlsym(hdr,name)
	#define knh_dlerror()           ALT_dlerror()
	#define knh_dlclose(hdr)        ALT_dlclose(hdr)
#ifndef KNH_RTLD_LAZY
#define KNH_RTLD_LAZY               0
#endif
#endif

/* ------------------------------------------------------------------------ */

#ifdef ALT_GETENV
	#define knh_getenv(n)           ALT_getenv(n)
#else
	#define knh_getenv(n)           getenv(n)
#endif

/* ======================================================================== */

#endif /*KONOHA_DEPS_H_*/
