/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include<konoha.h>

#ifdef __cplusplus
extern "C" {
#endif


/* ======================================================================== */
/* [method] */

/* ------------------------------------------------------------------------ */
/* @method void System.startIrohaServer(Int! port, String! dir) */

static
METHOD knh__System_startIrohaServer(Ctx *ctx, knh_sfp_t *sfp)
{
	int port = ARG_int(sfp[1]);
	char *dir = ARG_char(sfp[2]);
	fprintf(stderr, "Staring iRoha at %d port with '%s'", port, dir);
	TODO_THROW(ctx);
	KNH_RETURN_void(ctx, sfp);
}

/* ======================================================================== */
/* [KNHAPI] */

KNHAPI(int) knhiroha_init(Ctx *ctx)
{
	KNH_NOTICE(ctx, "loading iroha..");
	konoha_addMethod(ctx, "void System.startIrohaServer(Int! port, String! dir)", knh__System_startIrohaServer);
	return 1;
}
/* ------------------------------------------------------------------------ */

KNHAPI(void) knhiroha_traverse(Ctx *ctx, f_traverse ftr)
{
	if(konoha_issweep(ftr)) {

	}
}

/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif

