/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER  
 * 
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation  
 * All rights reserved.
 * 
 * You may choose one of the following two licenses when you use konoha. 
 * See www.konohaware.org/license.html for further information.
 * 
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER 
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *  
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus 
extern "C" {
#endif

/* ======================================================================== */
/* [structs] */

void
knh_Mapper_struct_init(Ctx *ctx, knh_Mapper_struct *b, int init, Object *cs)
{
	b->size = 0;
	b->flag = 0;
	b->scid = CLASS_Object;
	b->tcid = CLASS_Object;
	b->fmap = NULL;
	KNH_INITv(b->mapdata, KNH_NULL);
}

/* ------------------------------------------------------------------------ */

#define _knh_Mapper_struct_copy NULL

/* ------------------------------------------------------------------------ */

void
knh_Mapper_struct_traverse(Ctx *ctx, knh_Mapper_struct *b, f_traverse ftr)
{
	if(IS_Mapper(b->mapdata)) {
		ftr(ctx, UP(b->m1));
		ftr(ctx, UP(b->m2));
	}
	else {
		ftr(ctx, b->mapdata);
	}
}

/* ======================================================================== */
/* [func] */

static
Object* knh_Mapper_fMethod(Ctx *ctx, Object *o, Mapper *mpr)
{
	KNH_ASSERT(IS_Method(DP(mpr)->mapdata));
	KNH_LPUSH(ctx, DP(mpr)->mapdata);    /* ebp[-1] */
	KNH_LPUSH(ctx, o);                   /* ebp[0] */
	KNH_SCALL(ctx, -1);
	VM_SHIFT(ctx, -1);
	return VM_EBP(ctx, 1);
}

/* ------------------------------------------------------------------------ */

static
f_mapper knh_tMapper_findFunc(Ctx *ctx, Object *mapdata, knh_class_t scid, knh_class_t tcid)
{
	if(IS_Method(mapdata)) return knh_Mapper_fMethod;
	return knh_Mapper_fNull;
}

/* ======================================================================== */
/* [constructors] */

Mapper* new_Mapper(Ctx *ctx, knh_flag_t flag, knh_class_t scid, knh_class_t tcid, f_mapper fmap, Object *mapdata)
{
	knh_Mapper_t* o = 
		(Mapper*)new_Object_malloc(ctx, FLAG_Mapper, CLASS_Mapper, sizeof(knh_Mapper_struct));
	knh_Mapper_struct_init(ctx, DP(o), 0, NULL);
	DP(o)->size = 0;
	DP(o)->flag = flag;
	DP(o)->scid = scid;
	DP(o)->tcid = tcid;
	if(fmap == NULL) {
		DP(o)->fmap = knh_tMapper_findFunc(ctx, mapdata, scid, tcid);
		KNH_ASSERT(fmap != NULL);
	}else {
		DP(o)->fmap = fmap;
	}
	KNH_SETv(ctx, DP(o)->mapdata, mapdata);
	o->fmap_1 = DP(o)->fmap;
	return o;
}

/* ======================================================================== */
/* [MapMap] */

Object *knh_Mapper_fmapmap(Ctx *ctx, Object *s, Mapper *mpr)
{
	KNH_ASSERT(knh_Mapper_isMapMap(mpr));
	KNH_LOPEN(ctx,0);
	Object *t = (DP(mpr)->m1)->fmap_1(ctx, s, DP(mpr)->m1);
	if(IS_NULL(t)) {
		return t;
	}
	KNH_LPUSH(ctx, t);
	t = (DP(mpr)->m2)->fmap_1(ctx, t, DP(mpr)->m2);
	KNH_LCLOSE(ctx);
	return t;
}

/* ------------------------------------------------------------------------ */

Mapper* new_MapMap(Ctx *ctx, Mapper *m1, Mapper *m2)
{
	knh_Mapper_t* o = 
		(Mapper*)new_Object_malloc(ctx, FLAG_Mapper, CLASS_Mapper, sizeof(knh_Mapper_struct));
	DP(o)->size = 0;
	DP(o)->flag = DP(m1)->flag | DP(m2)->flag;
	DP(o)->scid = DP(m1)->scid;
	DP(o)->tcid = DP(m2)->tcid;
	KNH_INITv(DP(o)->m1, m1);
	KNH_INITv(DP(o)->m2, m2);
	o->fmap_1 = knh_Mapper_fmapmap;
	return o;
}

/* ======================================================================== */
/* [methods] */

INLINE
Object *knh_Mapper_execMap(Ctx *ctx, Mapper *o, Object *sub)
{
	KNH_ASSERT(IS_Mapper(o));
	return o->fmap_1(ctx, sub, o);
}

/* ======================================================================== */
/* [movabletext] */
/* @method void Mapper.%k(OutputStream w, String m) */

void knh_Mapper__k(Ctx *ctx, Mapper *o, OutputStream *w, String *m)
{
	knh_write__type(ctx, w, DP(o)->scid);
	if(knh_Mapper_isTotal(o)) {
		knh_write(ctx, w, STEXT("==>"));
	}else{
		knh_write(ctx, w, STEXT("-->"));
	}
	knh_write__type(ctx, w, DP(o)->tcid);
	knh_putc(ctx, w, ':');
	knh_write__flag(ctx, w, DP(o)->flag);
}

/* ------------------------------------------------------------------------ */


#ifdef __cplusplus
}
#endif
