/****************************************************************************
 * KONOHA COPYRIGHT, LICENSE NOTICE, AND DISCRIMER
 *
 * Copyright (c) 2005-2008, Kimio Kuramitsu <kimio at ynu.ac.jp>
 *           (c) 2008-      Konoha Software Foundation
 * All rights reserved.
 *
 * You may choose one of the following two licenses when you use konoha.
 * See www.konohaware.org/license.html for further information.
 *
 * (1) GNU General Public License 2.0      (with    KONOHA_UNDER_GPL2)
 * (2) Konoha Software Foundation License 1.0
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****************************************************************************/

/* ************************************************************************ */

#include"commons.h"

/* ************************************************************************ */

#ifdef __cplusplus
extern "C" {
#endif

/* ======================================================================== */
/* [constructor] */

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [method] */

/* ======================================================================== */
/* [movabletext] */

/* @method void Class.%s(OutputStream w, String m) */

void knh_Class__s(Ctx *ctx, Class *o, OutputStream *w, String *m)
{
	knh_write__class(ctx, w, o->cid);
}

/* ------------------------------------------------------------------------ */
/* @method void Class.%k(OutputStream w, String m) */

void knh_Class__k(Ctx *ctx, Class *o, OutputStream *w, String *m)
{
	knh_write__type(ctx, w, o->type);
}

/* ------------------------------------------------------------------------ */
/* @method void Class.%dump(OutputStream w, String m) */

void knh_Class__dump(Ctx *ctx, Class *o, OutputStream *w, String *m)
{
	TODO_THROW(ctx);
}

/* ------------------------------------------------------------------------ */

static
char *knh_methodop_tochar(knh_methodn_t mn)
{
	switch(mn) {
	case METHODN_opNot: return "!";
	case METHODN_opHasstanceof: return "instanceof";
	case METHODN_opAs:  return "as";

	case METHODN_opHas:  return "in?";
	case METHODN_opIsa: return "isa?";
	case METHODN_opIs:  return "is?";
	case METHODN_opTo:  return "to?";

	case METHODN_opEq:  return "==";
	case METHODN_opNeq:  return "!=";
	case METHODN_opLt:  return "<";
	case METHODN_opLte:  return "<=";
	case METHODN_opGt:  return ">";
	case METHODN_opGte:  return ">=";

	case METHODN_opLshift:  return "<<";
	case METHODN_opRShift:  return ">>";

	case METHODN_opMod:  return "%";

#ifdef METHODN_opAdd__2
	case METHODN_opAdd__2 :
#endif
	case METHODN_opAdd:  return "+";

#ifdef METHODN_opSub__2
	case METHODN_opSub__2 :
#endif
	case METHODN_opNeg:
	case METHODN_opSub:  return "-";

#ifdef METHODN_opDiv__2
	case METHODN_opDiv__2 :
#endif
	case METHODN_opDiv:  return "/";

#ifdef METHODN_opMul__2
	case METHODN_opMul__2 :
#endif
	case METHODN_opMul:  return "*";

	case METHODN_opLor:  return "&";
	case METHODN_opLand:  return "|";
	case METHODN_opLnot:  return "~";
	case METHODN_opXor:  return "^";
	case METHODN_opNext:  return "++";
	case METHODN_opPrev:  return "--";
	case METHODN_opItr:   return "..";
	case METHODN_opSubsete: return "[m..n]";
	case METHODN_opOffset: return "[m..+n]";
	case METHODN_opSubset: return "[m..<n]";
	}
	return NULL;
}

/* ------------------------------------------------------------------------ */

static
void knh_Method__man(Ctx *ctx, Method *o, OutputStream *w, knh_class_t cid)
{
	if(knh_Method_isAbstract(o)) {
		knh_write(ctx, w, STEXT("@abstract"));
		knh_putc(ctx, w, ' ');
	}

	if(knh_Method_rtype(o) == TYPE_void) {
		knh_write(ctx, w, knh_String_tobytes(TS_void));
	}else{
		knh_write__type(ctx, w, knh_pmztype_totype(ctx, knh_Method_rtype(o), cid));
	}
	knh_putc(ctx, w, ' ');

	if(knh_Method_isStatic(o)) {
		knh_write__s(ctx, w, CTXCLASSN(cid));
		knh_putc(ctx, w, '.');
	}
	knh_write__mn(ctx, w, DP(o)->mn);

	knh_putc(ctx, w, '(');
	knh_int_t i;
	for(i = 0; i < knh_Method_psize(o); i++) {
		if(i > 0) {
			knh_write_delim(ctx, w);
		}
		knh_mfield_t mf = knh_Method_pfields(o, i);
		knh_write__type(ctx, w, knh_pmztype_totype(ctx, mf.type, cid));
		knh_putc(ctx, w, ' ');
		knh_write(ctx, w, B(FIELDN(mf.fn)));
	}
	if(knh_Method_isVarArgs(o)) {
		knh_write_delim(ctx, w);
		knh_write_dots(ctx, w);
	}
	knh_putc(ctx, w, ')');
}

/* ------------------------------------------------------------------------ */

static
void knh_Class__man__supcid(Ctx *ctx, knh_class_t cid, OutputStream *w, DictMap *dm)
{
	if(cid == CLASS_Object) return;
	knh_write(ctx, w, STEXT("METHODS: +"));
	knh_write__class(ctx, w, cid);
	knh_write_EOL(ctx, w);
	int cnt = 0, i;

	for(i = 0; i < knh_DictMap_size(dm); i++) {
		Method *mtd = (Method*)knh_DictMap_valueAt(dm, i);
		if(IS_Method(mtd)) {
			if(METHODN_IS_MOVTEXT(DP(mtd)->mn)) continue;
			if(DP(mtd)->cid != cid) break;
			knh_DictMap_removeAt(ctx, dm, i);
			knh_bytes_t k = knh_String_tobytes(knh_DictMap_keyAt(dm, i));
			if(cnt + k.len > 72) {
				knh_write_EOL(ctx, w);
				knh_write_TAB(ctx, w);
				cnt = 8;
			}
			if(cnt == 0) {
				cnt = 8;
				knh_write_TAB(ctx, w);
			}
			knh_write(ctx, w, k); knh_putc(ctx, w, ' ');
			cnt += (k.len + 1);
		}
	}
	if(cnt > 8) {
		knh_write_EOL(ctx, w);
	}
	knh_Class__man__supcid(ctx, knh_tClass[cid].supcid, w, dm);
}

/* ------------------------------------------------------------------------ */
/* @method void Class.%man(OutputStream w, String m) */

void knh_Class__man(Ctx *ctx, Class *o, OutputStream *w, String *m)
{
	knh_class_t cid = (o)->cid;
	char bufmn[CLASSNAME_BUFSIZ];
	DEBUG_ASSERT_cid(cid);
	KNH_LOPEN(ctx, 0);
	DictMap *dm = new_DictMap(ctx, 128);
	KNH_LPUSH(ctx, dm);
	size_t i = 0;
	while(1) {
		Array *a = DP(knh_tClass[cid].cstruct)->methods;
		for(i = 0; i < knh_Array_size(a); i++) {
			Method *mtd = (Method*)knh_Array_n(a, i);
			char *op = knh_methodop_tochar(DP(mtd)->mn);
			if(op == NULL) {
				knh_format_methodn(bufmn, sizeof(bufmn), DP(mtd)->mn);
				//DBG2_P("mn='%s'", bufmn);
				knh_bytes_t name = B(bufmn);
				if(IS_NULL(knh_DictMap_get__b(ctx, dm, name))) {
					knh_DictMap_set(ctx, dm, new_String(ctx, name, NULL), UP(mtd));
				}
			}
			else {
				knh_bytes_t name = B(op);
				if(IS_NULL(knh_DictMap_get__b(ctx, dm, name))) {
					knh_DictMap_set(ctx, dm, new_String__T(ctx, op), UP(mtd));
				}
			}
		}
		if(cid == CLASS_Object) break;
		cid = knh_tClass[cid].supcid;
	}

	int cnt = 0;
	cid = (o)->cid;
	knh_println(ctx, w, STEXT("NAME"));
	knh_write_TAB(ctx, w);
	knh_println(ctx, w, knh_String_tobytes(knh_tClass[cid].lname));
	knh_write_EOL(ctx, w);

	knh_DictMap_sort(dm);

	knh_println(ctx, w, STEXT("OPERATORS:"));
	knh_write_TAB(ctx, w);

	for(i = 0; i < knh_DictMap_size(dm); i++) {
		Method *mtd = (Method*)knh_DictMap_valueAt(dm, i);
		if(IS_Method(mtd)) {
			char *op = knh_methodop_tochar(DP(mtd)->mn);
			if(op == NULL) continue;
			knh_DictMap_removeAt(ctx, dm, i);
			if(DP(mtd)->cid == CLASS_Object && cid != CLASS_Object) continue;
			knh_write__s(ctx, w, op); knh_putc(ctx, w, ' ');
		}
	}
	knh_write_EOL(ctx, w);

	knh_println(ctx, w, STEXT("METHODS:"));

	for(i = 0; i < knh_DictMap_size(dm); i++) {
		Method *mtd = (Method*)knh_DictMap_valueAt(dm, i);
		if(IS_Method(mtd)) {
			if(METHODN_IS_MOVTEXT(DP(mtd)->mn)) continue;
			if(DP(mtd)->cid == CLASS_Object && cid != CLASS_Object) continue;
//			if(DP(mtd)->cid != knh_tClass[cid].bcid) continue;
			knh_write_TAB(ctx, w);
			knh_Method__man(ctx, mtd, w, cid);
			knh_write_EOL(ctx, w);
			knh_DictMap_removeAt(ctx, dm, i);
		}
	}

	knh_Class__man__supcid(ctx, knh_tClass[cid].supcid, w, dm);

	knh_println(ctx, w, STEXT("FORMATTERS:"));
	knh_write_TAB(ctx, w);
	cnt = 8;
	for(i = 0; i < knh_DictMap_size(dm); i++) {
		Method *mtd = (Method*)knh_DictMap_valueAt(dm, i);
		if(IS_Method(mtd)) {
			if(!METHODN_IS_MOVTEXT(DP(mtd)->mn)) continue;
			if(DP(mtd)->cid == CLASS_Object && cid != CLASS_Object) continue;
			knh_bytes_t k = knh_String_tobytes(knh_DictMap_keyAt(dm, i));
			if(cnt + k.len > 72) {
				knh_write_EOL(ctx, w);
				knh_write_TAB(ctx, w);
				cnt = 8;
			}
			knh_write(ctx, w, k); knh_putc(ctx, w, ' ');
			cnt += (k.len + 1);
		}
	}

	KNH_LCLOSE(ctx);
}

/* ------------------------------------------------------------------------ */
/* ======================================================================== */
/* [mapping] */


/* ------------------------------------------------------------------------ */

#ifdef __cplusplus
}
#endif
