/* $Id: decode.c,v 1.5 2005/12/10 16:39:08 ichiro Exp $ */
/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <regex.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/time.h>
#include <sys/param.h>

#include "kircd.h"

int url_decode_jis(char *dst, char *src)
{
	int n, len = 0;
	char *p;
	unsigned char data[HTTPBUF + 256];

	p = dst;
	memset(data, 0, sizeof(data));

	if (strlen(src) == 0) 
		return (1);

	/* URL convert to raw data */
	len = url_decode_rawdata(data, src);

	/* check encode method */
	for (n = 0; n < len; n++) {
		if (data[n] == 0x1B) { /* found JIScode */
			/* printf("found JIS\n"); */
			strcpy(p, data);
			return (0);
		}

		if (data[n] < 0x80) { 
			goto loop_end;
		} else if (data[n] >= 0x81 && data[n] <= 0x9F) {
			/* printf("found SJIS\n"); */
			sjis2jis(p, data);
			return (0);
		} else if (data[n] >= 0xA1 && data[n] <= 0xDF) {
			if ((data[n+1] < 0x80) ||
			    (data[n+1] > 0x80 && data[n+1] < 0xA0)) {
				/* printf("found SJIS+kana\n"); */
				sjis2jis(p, data);
				return (0);
			}
		}

		if (data[n] >= 0xF0 && data[n] <= 0xFE) {
			/* printf("found EUC\n"); */
			euc2jis(p, data);
			return (0);
		} else { 
			n++;
		}

		if ((data[n] >= 0x40 && data[n] <= 0x7E) || 
		    (data[n] >= 0x80 && data[n] <= 0xA0)) {
			/* printf("found SJIS\n"); */
			sjis2jis(p, data);
			return (0);
		} else if (data[n] >= 0xFD && data[n] <= 0xFE) {
			/* printf("found EUC\n"); */
			euc2jis(p, data);
			return (0);
		}
loop_end:
	;;
	}

	/* printf("use EUC conv\n"); */
	euc2jis(p, data);

	return (0);
}

int url_decode_rawdata(char *dst, char *src)
{
	int i, j, len;
	char *p, hex_buf[3];
	long hex;

	len = strlen((char *)src);
	p = dst;

	for (i = 0, j = 0; i < len; i++, j++){
		if (src[i] == '+' ){
			p[j] = ' ';
			continue;
		}
		if (src[i] == '%'){ 
			sprintf(hex_buf,"%c%c",src[i+1],src[i+2]);
			hex = strtol(hex_buf, NULL, 16);
			p[j] = (char)hex;
			i += 2;
		} else {
			p[j] = src[i];
		}
        }
        p[j] = '\0';

	return j;
}

int sjis2jis(char *dst, char *src)
{
	int i, j, len, esc_in;
	char *p;
	unsigned char high, low;

	len = strlen((char *)src);
	p = dst;
	esc_in = 0;

	for (i = 0, j = 0; i < len; i++, j++){
		high = src[i];
		low  = src[i+1];
		if ((high >= 0x81 && high <= 0x9F) ||
		     (high >= 0xE0 && high <= 0xEF)) {
			if (high <= 0x9F) {
				if(low < 0x9F)
					high = (high << 1) - 0xE1;
				else
					high = (high << 1) - 0xE0;
			} else {
				if(low < 0x9F)
					high = (high << 1) - 0x161;
				else
					high = (high << 1) - 0x160;
			}
			if (low < 0x7F)
				low -= 0x1F;
			else if (low < 0x9F)
				low -= 0x20;
			else
				low -= 0x7E;

			/* add ESC-IN code */
			if (esc_in == 0) {
			/* printf("1:ESC-IN[%d]\n", j); */
				p[j] = 0x1B;
				p[j+1] = 0x24;
				p[j+2] = 0x42;
				j += 3;
				esc_in = 1;
			}

			/* JIS code into buffer */
			p[j] = high;
			p[j+1] = low;
			/* printf("2:p[%d]=%x,p[%d]=%x\n",
				j, p[j], j+1, p[j+1]); */
			i++;
			j++;
		} else {
			/* add ESC-OUT code */
			if (esc_in) {
			/* printf("3:ESC-OUT[%d]\n", j); */
				p[j] = 0x1B;
				p[j+1] = 0x28;
				p[j+2] = 0x42;
				j += 3;
				esc_in = 0;
			}
			p[j] = high;
			/* printf("4:p[%d]=%x\n", j, p[j]); */
		}
        }
	/* add ESC code */
	if (esc_in) {
	/* printf("5:ESC-OUT[%d]\n", j); */
		p[j] = 0x1B;
		p[j+1] = 0x28;
		p[j+2] = 0x42;
		j += 3;
	}
        p[j] = '\0';

	return (0);
}

int euc2jis(char *dst, char *src)
{
	int i, j, len, esc_in = 0;    
	char *p; 

	len = strlen((char *)src);
	p = dst;

	for (i = 0, j = 0; i < len; i++, j++) {
		if (src[i] & 0x80) {
			if (esc_in == 0) {
				p[j] = 0x1B;
				p[j+1] = 0x24;
				p[j+2] = 0x42;
				j += 3;
				esc_in = 1;
			}
			p[j] = src[i] & 0x7F;
			p[j+1] = src[i+1] & 0x7F;
			i++;
			j++;
		} else {
			if (esc_in) {
				p[j] = 0x1B;
				p[j+1] = 0x28;
				p[j+2] = 0x42;
				j += 3;
				esc_in = 0;
			}
			p[j] = src[i];
		}
	}
	if (esc_in) {
		p[j] = 0x1B;
		p[j+1] = 0x28;
		p[j+2] = 0x42;
		j += 3;
	}
	p[j] = '\0';

	return (0);
}

int ltgt_encode(char *dst, char *src)
{
        int i, j, len, esc_in;
        char *p;

        len = strlen((char *)src);
	p = dst;
	esc_in = 0;

	for (i = 0, j = 0; i < len; i++) {
		/* make flag for ESC-in,out */
		if ((src[i] == 0x1B) && (src[i + 1] == 0x24) &&
		    (src[i + 2] == 0x42))
			esc_in = 1;
		else if ((src[i] == 0x1B) &&
			 (src[i + 1] == 0x28) &&
			 (src[i + 2] == 0x42))
			esc_in = 0;

		/* '<','>' ---> '&lt;','&gt;' */
		if ((esc_in == 0) && (src[i] == '<')) { 
			strcat(p, "&lt;");
			j += 4;
		} else if ((esc_in == 0) && (src[i] == '>')) {
			strcat(p, "&gt;");
			j += 4;
		} else {
			p[j] = src[i];
			j++;
		}
	}
        p[j] = '\0';

        return (0);
}

int channel_decode(char *dst, char *src)
{
	char channel[40];

	/* %hoge -> #hoge:*.jp */
	if (src[0] == '%') {
		sscanf(src, "%%%s", channel);
		sprintf(dst, "#%s:*.jp", channel);
	} else
		strcpy(dst, src);

	return (0);
}

int channel_encode(char *dst, char *src)
{
	int n = 0;
	char channel[40];
	char sufix[3];

	/* #hoge:*.jp -> %hoge */
	if ((n = sscanf(src, "#%[^:]:%*2s%2s",
			channel, sufix)) == 2)
		sprintf(dst, "%%%s", channel);
	else
		strcpy(dst, src);

	return (0);
}

const char B64[] =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
#define Val(i)  ( src[i] == '=' ? 0 : strchr(B64, src[i]) - B64 )

char * base64_decode(char *src)
{
	int i, j, len;
	char buf[HTTPBUF];
	char *p;

	len = strlen(src);
	p = buf;

	for (i = 0, j = 0; i < len; i += 4){
		p[j]   = (char) ((Val(i) << 2) |
			        ((Val(i+1) & 0x30) >> 4));
		p[j+1] = (char)(((Val(i+1) & 0x0F) << 4) |
				((Val(i+2) & 0x3C) >> 2));
		p[j+2] = (char)(((Val(i+2) & 0x03) << 6) |
				 (Val(i+3) & 0x3F));
		j += 3;
	}
	p[j] = '\0';

	return p;
}

char* href_conv(char* str) {
	regex_t reg;
	regmatch_t match;
	int regsuccess; 

	char *matched_str;
	char *head_str;
	char *tail_str;

	int matched_str_len;
	int head_str_len;
	int tail_str_len;

	regcomp(&reg,"http://[[:alnum:]./~?&%#_=-]+",REG_EXTENDED);
	regsuccess = regexec(&reg, str, 1, &match, 0);
	regfree(&reg);

	if (regsuccess == REG_NOMATCH) return str;

	matched_str_len = match.rm_eo - match.rm_so;
	head_str_len = match.rm_so;
	tail_str_len = strlen(str) - match.rm_eo;

	/* match str */
	matched_str = (char*)malloc(matched_str_len + 1);
	if (matched_str == NULL) return str;

	*matched_str = '\0';
	strncat(matched_str, &str[match.rm_so], matched_str_len);

	/* head str */
	head_str = (char*)malloc(head_str_len + 1);
	*head_str = '\0';
	strncat(head_str, &str[0], head_str_len);

	/* tail str */
	tail_str = (char*)malloc(tail_str_len + 1);
	*tail_str = '\0';
	strncat(tail_str, &str[match.rm_eo], tail_str_len);

	sprintf(str, "%s<a href=\"%s\">%s</a>%s",
		head_str, matched_str, matched_str, tail_str);

	return str;
}
