/* $Id: keitai.c,v 1.22 2005/12/11 20:17:58 ichiro Exp $ */
/*
 * Copyright (c) 2004
 *	Ichiro FUKUHARA <ichiro@ichiro.org>.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Ichiro FUKUHARA.
 * 4. The name of the company nor the name of the author may be used to
 *    endorse or promote products derived from this software without specific
 *    prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ICHIRO FUKUHARA ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL ICHIRO FUKUHARA OR THE VOICES IN HIS HEAD BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <net/if.h>
#include <sys/param.h>

#include "kircd.h"

int
keitai_start(struct tparam *th)
{
	char a1[IRC_MAX], a2[IRC_MAX], a3[IRC_MAX * 2], a4[IRC_MAX * 2];
	char *s;

#ifdef DEBUG
		printf("%s\r\n", th->l_buff);
#endif
	/* skip NOTICE messages */
	if ((s = strstr(th->l_buff, "NOTICE"))) {
	}

	/* catch PING messages */
	if ((s = strstr(th->l_buff, "PING"))) {
		ping_recv(th);
	}

	/* catch NICK name */
	if ((s = strstr(th->l_buff, "NICK"))) {
		nick_recv(th);
	}

	/* detect JOIN channel */
	if ((s = strstr(th->l_buff, "JOIN"))) {
		sscanf(th->l_buff, ":%s JOIN :%[^,]", a1, a3);
		if (a3[0] != '#') { /* for madoka4.2 */
			sscanf(th->l_buff, ":%s JOIN %[^,]", a1, a3);
#ifdef DEBUG
			printf("JOIN: madoka hack\n");
#endif
		}
		join_recv(th, a3);
	}

	if ((s = strstr(th->l_buff, "PART"))) {
		part_recv(th);
 	}

	/* catch PRIVMSGs */
	if ((s = strstr(th->l_buff, "PRIVMSG"))) {
		priv_recv(th);
	}

	/* catch QUIT */
	if ((s = strstr(th->l_buff, "QUIT"))) {
#ifdef DEBUG
		printf("QUIT:%s\n", th->l_buff);
#endif
	}

	/* detect TOPIC */
	if ((s = strstr(th->l_buff, "332"))) {
		if ((sscanf(th->l_buff, ":%s 332 %*s %s :%[^\n]",
			a1, a2, a4)) == 3) {
			topic_recv(th, "332", a2, a4);
		}
	} else if ((s = strstr(th->l_buff, "TOPIC"))) {
		if ((sscanf(th->l_buff, ":%[^!]!%*s TOPIC %s :%[^\n]",
			a1, a2, a4)) == 3) {
			topic_recv(th, a1, a2, a4);
		}
	}

	/* MODE */
	if ((s = strstr(th->l_buff, "MODE"))) {
#ifdef DEBUG
		printf("MODE:%s\n", th->l_buff);
#endif
	}

	/* NAMES */
	if ((s = strstr(th->l_buff, "353"))) {
		if ((sscanf(th->l_buff, ":%*s 353 %s %*s %s :%[^\n]",
			a2, a3, a4)) == 3) {
			if (strcmp(th->real_nickname, a2) == 0)
				names_recv(th, a3, a4);
		}
	}

	return (0);
}

int priv_recv(struct tparam *th)
{
	time_t t = time(NULL);
	struct tm* tm;
	char id[IRC_MAX];
	char channel[C_NAME], channel2[C_NAME];
	char message[IRC_MAX * 2];
	char message2[IRC_MAX * 2]; /* include &lt,&gt charactor */

	int n = 0;
	int ch_number = 255; /* 255 means "not found" */
	tm = localtime(&t);

	/* zero clear */
	memset(channel,  0, sizeof(channel));
	memset(channel2, 0, sizeof(channel2));
	memset(message,  0, sizeof(message));
	memset(message2, 0, sizeof(message2));

	/* get PRIVMSG */
	n = sscanf(th->l_buff, ":%[^!]!%*s PRIVMSG %s :%[^\n]",
			id, channel, message);
	if (n < 3) { /* for madoka4.2 */
		n = sscanf(th->l_buff, ":%s PRIVMSG %s :%[^\n]",
			id, channel, message);
	}

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

	/* message; '<','>' ---> '&lt;','&gt;' */
        ltgt_encode(message2, message);

	/* add href tag */
	href_conv(message2);

#ifdef DEBUG 
	printf("%s | <%s> %s\n", channel2, id, message2);
#endif

	for (n = 0; n <= th->ch_count; n++) {
		if (strstr(th->name[n], channel2)) {
					/* message to channel */
			ch_number = n;
			break;
		} else if (strstr(th->name[n], id)) { 
					/* message from another person */
			ch_number = n;
			break;
		}
	}
	/* can not found out channel, maybe conversation
	   with another person ? */
	if (ch_number == 255) {
		if (strstr(th->real_nickname, channel2)) {
			printf("private session with %s\n", id);
			ch_number = join_recv(th, id);
			printf("make new channel with another person\n");
		} else {
			printf("channel not found\n");
			return (1);
		}
	} 

	/* check history count and roll up */
	if (th->history_count[ch_number] == th->max_line) {
		for (n = 0; n <= th->max_line; n++) {
			strcpy(th->data[ch_number][n],
			       th->data[ch_number][n + 1]);
			memset(th->data[ch_number][n + 1], 0,
			       sizeof(th->data[ch_number][n + 1]));
		}
		th->history_count[ch_number]--;
		if (th->read_count[ch_number] > 0)
			th->read_count[ch_number]--;
	}

	/* add message with time into historical buffer */
	if (strstr(th->real_nickname, id)) { /* own messages */
		sprintf(th->
			data[ch_number][th->history_count[ch_number]],
			"%02d:%02d &gt;%s&lt;  %s<br>",
			tm->tm_hour, tm->tm_min,id, message2);
		th->read_count[ch_number]++;
	} else {
		sprintf(th->
			data[ch_number][th->history_count[ch_number]],
			"%02d:%02d &lt;%s&gt; %s<br>",
			tm->tm_hour, tm->tm_min,id, message2);
	}
	th->history_count[ch_number]++;

#ifdef DEBUG2
	printf("%d: %s | %s\n", (th->history_count[ch_number] - 1), channel2,
		th->data[ch_number][th->history_count[ch_number] - 1]);
#endif

	return (0);
}

int names_recv(struct tparam *th, char *channel, char *names)
{
	int n = 0;
	char buf[IRC_MAX * 2];
	char channel2[C_NAME];

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

#ifdef DEBUG
	printf("NAMES:channel=%s, names=%s\n", channel2, names);
#endif

	for (n = 0; n <= th->ch_count; n++) {
		if (strstr(th->name[n], channel2))
                        sprintf(th->member_names[n], " %s", names);
        }

	return (0);
}

int topic_recv(struct tparam *th, char *user, char *channel, char *topic)
{
	int n = 0;
	char buf[IRC_MAX * 2];
	char channel2[C_NAME];

	memset(buf, 0, sizeof(buf));
	memset(channel2, 0, sizeof(channel2));

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

#ifdef DEBUG
	printf("TOPIC:user=%s, channel=%s, topic=%s\n",
		user, channel2, topic);
#endif
	/* '<','>' ---> '&lt;','&gt;' */
	ltgt_encode(buf, topic);

	/* add href tag */
	href_conv(buf);

	for (n = 0; n <= th->ch_count; n++) {
		if (strstr(th->name[n], channel2))
			sprintf(th->topic[n], " %s", buf);
	}

	return (0);
}

int part_recv(struct tparam *th)
{
	int i, j, match = 255;
	char id[IRC_MAX];
	char channel[C_NAME], channel2[C_NAME];

	/* zero clear */
	memset(channel,  0, sizeof(channel));
	memset(channel2, 0, sizeof(channel2));

	/* get PART */
	sscanf(th->l_buff, ":%s PART %s :%*[^,]",
		id, channel);

	/* send NAMES command */
	if (strcmp(th->real_nickname, id) != 0) {
		send_names(th, channel);
		return (0);
	}

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

#ifdef DEBUG
	printf("part channel=%s\n", channel2);
	printf("last ch number=%d\n", th->ch_count);
#endif

	 /* search exist channel */
	for (i = 0; i <= th->ch_count; i++) {
		if (strcmp(th->name[i], channel2) == 0) {
			match = i;
			break;
		}
	}

	if (match > th->ch_count)
		return (0);

	if (match == th->ch_count) {
		memset(th->name[match], 0, sizeof(th->name[match]));
		memset(th->topic[match], 0, sizeof(th->topic[match]));
		memset(th->data[match], 0, sizeof(th->data[match]));
		th->history_count[match] = 0;
		th->read_count[match] = 0;
	} else {
	    for (i = match; i < th->ch_count; i++) {
		memset(th->name[i], 0, sizeof(th->name[i]));
		memset(th->topic[i], 0, sizeof(th->topic[i]));
		memset(th->data[i], 0, sizeof(th->data[i]));

		strcpy(th->name[i], th->name[i + 1]);
		strcpy(th->topic[i], th->topic[i + 1]);

		for (j = 0; j < th->history_count[i + 1]; j++) {
			strcpy(th->data[i][j], th->data[i + 1][j]);
		}
		th->history_count[i] = th->history_count[i + 1];
		th->read_count[i] = th->read_count[i + 1];
	    }
	    memset(th->name[th->ch_count], 0,
		   sizeof(th->name[th->ch_count]));
	    memset(th->topic[th->ch_count], 0,
		   sizeof(th->topic[th->ch_count]));
	    memset(th->data[th->ch_count], 0,
		   sizeof(th->data[match]));
	    th->history_count[th->ch_count] = 0;
	    th->read_count[th->ch_count] = 0;
	}
	th->ch_count--;

	return (0);
}

int join_recv(struct tparam *th, char *channel)
{
	int i, n = 0;
	char channel2[C_NAME];

	/* zero clear */
	memset(channel2, 0, sizeof(channel2));

	/* send NAMES command */
	send_names(th, channel);

	/* channel;  #hoge:*.jp -> %hoge */
	channel_encode(channel2, channel);

	/* search exist channel */
	for (i = 0; i <= th->ch_count; i++) {
		if (strcmp(th->name[i], channel2) == 0)
			return (0);
	}

	/* make new channel */
	while (th->name[n][0] != '\0')
		n++;
	if (n > th->ch_count)
		th->ch_count = n; /* largest channel number */

	strcpy(th->name[n], channel2);

#ifdef DEBUG
	printf("%s\r\n", th->l_buff);
	printf("join channel name(%d) = %s\n", n, th->name[n]);
#endif
	return (n);
}

int ping_recv (struct tparam *th)
{
	char server[IRC_MAX];

	/* zero clear */
	memset(server,  0, sizeof(server));

	/* get PING */
	sscanf(th->l_buff, "PING :%[^\n]", server);

	/* wait for flags clear */
	while ((!th->t_empty) || (th->t_lock)) {
		usleep(10000); /* 10ms */
	}
	th->t_lock = 1;	/* now writing */

	/* transfer message */
	sprintf(th->postdata, "PONG %s\r\n", server);

	/* clear trans lock and empty flag */
	th->t_empty = 0;
	th->t_lock = 0;

	return (0);
}

int nick_recv(struct tparam *th)
{
	char old_nickname[NAME_LEN];
	char new_nickname[NAME_LEN];

	sscanf(th->l_buff, ":%[^!]!%*s NICK :%[^,]",
		old_nickname, new_nickname);

	if (strcmp(th->real_nickname, old_nickname) == 0) {
		strcpy(th->real_nickname, new_nickname);
#ifdef DEBUG
	printf("NICK:%s -> %s\n", old_nickname, th->real_nickname);
#endif
	}

	return (0);
}

int send_names(struct tparam *th, char *channel)
{
	/* wait for flags clear */
	while ((!th->t_empty) || (th->t_lock)) {
		usleep(10000); /* 10ms */
	}
	th->t_lock = 1;	/* now writing */

	/* transfer message */
	sprintf(th->postdata, "NAMES %s\r\n", channel);

	/* clear trans lock and empty flag */
	th->t_empty = 0;
	th->t_lock = 0;

	return (0);
}
