#ifndef XICONTEXT_H
#define XICONTEXT_H

//#include <qptrlist.h>
#include <qvaluelist.h>
#include <qdatastream.h>
#include <qstring.h>
#include <qpoint.h>
#include <qintdict.h>
#include "supportattr.h"
#include <X11/Xlib.h>

class XICAttribute;

class XIContext {
public:
  XIContext(QDataStream::ByteOrder);
  ~XIContext();

  ushort       createIC();
  inline void  removeIC(ushort ic) { _iclist.remove(ic); }
  void         setValue(ushort ic, ushort id, const QByteArray&); 
  QByteArray   getValue(ushort ic, ushort id) const;
  Window       focusWindow(ushort ic) const;
  QString      fontPreedit(ushort ic) const;
  QPoint       spotPreedit(ushort ic) const;
  void         setTriggerFlag(ushort ic, bool b);
  bool         triggerFlag(ushort ic) const;
  static QValueList<SupportAttr>  getSuppICAttr();

protected:
  static void  initSuppICAttr();  // initialize IC attributes supported

private:
  QIntDict<XICAttribute>  _iclist;    // list of ICs
  QDataStream::ByteOrder  _byteorder;
  static QValueList<SupportAttr>  _attr_list;  // IC attributes supported
};


#endif // XICONTEXT_H
