#include "xicattribute.h"
#include <qdatastream.h>


XICAttribute::XICAttribute(ushort ic, QDataStream::ByteOrder bo) :
  _icid(ic),
  _trgr_flag(FALSE),
  _byteorder(bo),
  //_inputstyle(0),
  _clientwin(0),
  _filterevents(KeyPressMask),
  _focuswin(0),
  //_preeditattr_2(0),
  //_statusattr_3(0),
  //_areand_pree(0),
  //_area_pree(0),
  _fg_pree(0),
  _bg_pree(0),
  _bgpix_pree(0),    
  _color_pree(0),
  _stdclr_pree(0),  
  _line_pree(0),
  _cur_pree(0),
  //_areand_stat(0), 
  //_area_stat(0),
  _fg_stat(0),
  _bg_stat(0),
  _bgpix_stat(0),   
  _color_stat(0),
  _stdclr_stat(0), 
  _line_stat(0),
  _cur_stat(0)
{
  _fontset_pree = QCString();
  //_spot_pree = XPoint( 0, 0 );
  _fontset_stat = QCString();
  //_spot_stat = { 0, 0 };
}


XICAttribute::~XICAttribute()
{
}


QByteArray
XICAttribute::getValue(ushort id) const
{
  QByteArray ret(0);
  QDataStream ds(ret, IO_WriteOnly);
  ds.setByteOrder(_byteorder);
  
  switch (id) {
  case 1:
    ds << _clientwin;
    break;

  case 4:
    ds << _filterevents;
    break;

  default:
    qDebug("%s:unsupported id:%d", __FUNCTION__, id);
    Q_ASSERT(0);
    break;
  }

  return ret;
}


void
XICAttribute::setValue(ushort id, const QByteArray& data)
{
  QDataStream ds(data, IO_ReadOnly);
  ds.setByteOrder(_byteorder);
  char unused[4];

  switch (id) {
  case 1:
    Q_ASSERT(data.size() == sizeof(Window));
    ds >> _clientwin;
    break;

  case 2:
    while ( !ds.atEnd() ) {
      ushort id, len;
      ds >> id >> len;
      QByteArray attr(len);
      ds.readRawBytes(attr.data(), len);
      ds.readRawBytes((char*)unused, pad(len));    // unused
      setValuePreeditAttr(id, attr);
    }
    break;
    
  case 3:
    while ( !ds.atEnd() ) {
      ushort id, len;
      ds >> id >> len;
      QByteArray attr(len);  
      ds.readRawBytes(attr.data(), len);
      ds.readRawBytes((char*)unused, pad(len));    // unused
      setValueStatusAttr(id, attr);
    }
    break;
      
  case 4:
    Q_ASSERT(data.size() == sizeof(ulong));
    ds >> _filterevents;
    break;

  case 5:
    Q_ASSERT(data.size() == sizeof(Window));
    ds >> _focuswin;
    break;;

  default:
    qDebug("%s:unsupported id:%d", __FUNCTION__, id);
    Q_ASSERT(0);
    break;
  }
}



void
XICAttribute::setValuePreeditAttr(ushort id, const QByteArray& data)
{
  QDataStream ds(data, IO_ReadOnly);
  ds.setByteOrder(_byteorder); 
  QByteArray fs;
  ushort len;

  qDebug("%s id:%d data size:%d", __FUNCTION__, id, data.size());
  switch (id) {
  case 6:
    ds >> len;
    fs.resize(len);
    ds.readRawBytes(fs.data(), len);
    _fontset_pree = QString(fs);
    qDebug("Preedit Attributes FontSet:%d :%s", _fontset_pree.length(), _fontset_pree.data());
    break;
    
  case 7:
    Q_ASSERT(data.size() == sizeof(XPoint));
    ds >> _spot_pree.x >> _spot_pree.y;
    break;
  
  case 8:
    Q_ASSERT(data.size() == sizeof(XRectangle));
    ds >> _areand_pree.x >> _areand_pree.y;
    ds >> _areand_pree.width >> _areand_pree.height;
    break;
  
  case 9:
    Q_ASSERT(data.size() == sizeof(XRectangle));
    ds >> _area_pree.x >> _area_pree.y;
    ds >> _area_pree.width >> _area_pree.height;
    break;
  
  case 10:
    Q_ASSERT(data.size() == sizeof(ulong));
    ds >> _fg_pree;
    break;
  
  case 11:
    Q_ASSERT(data.size() == sizeof(ulong));
    ds >> _bg_pree;
    break;
  
  case 12:
    Q_ASSERT(data.size() == sizeof(Pixmap));
    ds >> _bgpix_pree;
    break;
  
  case 13:
    Q_ASSERT(data.size() == sizeof(Colormap));
    ds >> _color_pree;
    break;
  
  case 14:
    Q_ASSERT(data.size() == sizeof(Atom));
    ds >> _stdclr_pree;
    break;
  
  case 15:
    Q_ASSERT(data.size() == sizeof(int));
    ds >> _line_pree;
    break;
  
  case 16:
    Q_ASSERT(data.size() == sizeof(Cursor));
    ds >>  _cur_pree;
    break;
  
  default:
    Q_ASSERT(0);
    break;
  }
}


void
XICAttribute::setValueStatusAttr(ushort id, const QByteArray& data)
{
  QDataStream ds(data, IO_ReadOnly);
  ds.setByteOrder(_byteorder);
  QByteArray fs;
  ushort len;

  qDebug("%s id:%d data size:%d", __FUNCTION__, id, data.size());
  switch (id) {
  case 6:
    ds >> len;
    fs.resize(len);
    ds.readRawBytes(fs.data(), len);
    _fontset_stat = QString(fs);
    qDebug("Status Attributes FontSet:%d:%s", _fontset_stat.length(), _fontset_stat.data());
    break;
    
  case 7:
    Q_ASSERT(data.size() == sizeof(XPoint));
    ds >> _spot_stat.x >> _spot_stat.y;
    break;
    
  case 8:
    Q_ASSERT(data.size() == sizeof(XRectangle));
    ds >> _areand_stat.x >> _areand_stat.y;
    ds >> _areand_stat.width >> _areand_stat.height;
    break;
    
  case 9:
    Q_ASSERT(data.size() == sizeof(XRectangle));
    ds >> _area_stat.x >> _area_stat.y;
    ds >> _area_stat.width >> _area_stat.height;
    break;
    
  case 10:
    Q_ASSERT(data.size() == sizeof(ulong));
    ds >> _fg_stat;
    break;
    
  case 11:
    Q_ASSERT(data.size() == sizeof(ulong));
    ds >> _bg_stat;
    break;
    
  case 12:
    Q_ASSERT(data.size() == sizeof(Pixmap));
    ds >> _bgpix_stat;
    break;
    
  case 13:
    Q_ASSERT(data.size() == sizeof(Colormap));
    ds >> _color_stat; 
    break;
    
  case 14:
    Q_ASSERT(data.size() == sizeof(Atom));
    ds >> _stdclr_stat;
    break;
    
  case 15:
    Q_ASSERT(data.size() == sizeof(int));
    ds >> _line_stat;
    break;
    
  case 16:
    Q_ASSERT(data.size() == sizeof(Cursor));
    ds >> _cur_stat;
    break;
    
  default:
    Q_ASSERT(0);
    break;
  }
}
