#ifndef PREEDITAREA_H
#define PREEDITAREA_H

#include <qlabel.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qcolor.h>

class PreeditArea : public QLabel {
public:
  PreeditArea();
  ~PreeditArea();

  void showText(const QPoint& p, const QStringList& strlist = QStringList());
  void showInputingString(const QPoint& p, const QString& str = QString());
  void showConvertingPhases(const QPoint& p, const QStringList& strlist = QStringList());
  void showChangingPhaseLength(const QPoint& p, const QStringList& strlist = QStringList());  
  void setFont(const QFont &);
  void hide();

private:
  QLabel*  _otherphases;      // ѴԤʸ
  QColor   _normal_fgclr;     // ʸ
  QColor   _normal_bgclr;     // طʿ
  QColor   _attention_fgclr;  // ʸʸ
  QColor   _attention_bgclr;  // ʸطʿ
  QColor   _changing_fgcolr;  // ʸĹѹʸ
  QColor   _changing_bgcolr;  // ʸĹѹطʿ
};

#endif // PREEDITAREA_H

