#include "kimeraapp.h"
#include "inputmethod.h"

InputMethod* KimeraApp::inpmethod = 0;

KimeraApp::KimeraApp(int &argc, char **argv) : QApplication(argc, argv) { }


//
// Returns a pointer to the application global inputmethod.
//
InputMethod* 
KimeraApp::inputmethod()
{
  if ( !inpmethod ) {
    inpmethod = new InputMethod();
    Q_CHECK_PTR( inpmethod );
    qAddPostRoutine( cleanup_ptr );   // delete later
  }
  
  return inpmethod;
}


void
KimeraApp::cleanup_ptr()
{
  delete inpmethod;
  inpmethod = 0;
}


bool 
KimeraApp::x11EventFilter(XEvent* event)
{
  if ( !inpmethod ) return FALSE;

  if (event->type == ClientMessage) {
    ClientMessageEvent e(event);
    sendEvent(inpmethod, &e);
    return FALSE;

  } else if (event->type >= SelectionClear && event->type <= SelectionNotify) {
    SelectionEvent e(event);
    sendEvent(inpmethod, &e);
    return TRUE;
  } 
  
  return FALSE;
}
