#ifndef CONFIG_H
#define CONFIG_H

#include <qsettings.h>

class Config {
 public:
  static void readDefault();
  static QString readEntry(const QString& key, const QString& def = QString::null, bool *ok = 0);
  static bool readBoolEntry(const QString& key, bool def = 0, bool *ok = 0);
  static bool writeEntry(const QString& key, const QString& value);
  static bool writeEntry(const QString& key, bool value);

 protected:
  static void init();

 private:
  static QSettings settings;
};

#endif
