#include "config.h"
#include <qapplication.h>
#include <qdir.h>
#include <qfile.h>

const QString KIMERACONF = "/kimera/0.7/";

QSettings Config::settings(QSettings::Ini);

QString
Config::readEntry(const QString& key, const QString& def, bool *ok)
{
  init();
  return settings.readEntry(KIMERACONF + key, def, ok);
}


bool
Config::readBoolEntry(const QString& key, bool def, bool *ok)
{
  init();
  return settings.readBoolEntry(KIMERACONF + key, def, ok);
}


bool 
Config::writeEntry(const QString& key, const QString& value)
{
  init();
  return settings.writeEntry(KIMERACONF + key, value);
}


bool 
Config::writeEntry(const QString& key, bool value)
{
  init();
  return settings.writeEntry(KIMERACONF + key, value);
}


void
Config::init()
{
  static bool initdone = FALSE;

  if ( initdone ) return;

  QString strconfdir = QString(getenv("HOME")) + "/.kimera/";
  QDir confdir(strconfdir);
  
  if ( !confdir.exists() ) {
    confdir.mkdir(confdir.path());
  }
  
  settings.insertSearchPath(QSettings::Unix, confdir.path());
  
  QFile rcfile(strconfdir + "kimerarc");
  if ( !rcfile.exists() ) {
    // Default setting
    settings.writeEntry(KIMERACONF + "_cmbstartkey", QObject::tr("Kanji"));
    settings.writeEntry(KIMERACONF + "_cmbinputmode", QObject::tr("Ҥ餬"));
    settings.writeEntry(KIMERACONF + "_cmbinputmethod", QObject::tr("޻"));
    
    settings.writeEntry(KIMERACONF + "_cmbspacekey", QObject::tr("Ⱦ"));
    settings.writeEntry(KIMERACONF + "_cmbtenkey", QObject::tr("Ⱦ"));
    settings.writeEntry(KIMERACONF + "_cmbtouten", QObject::tr(""));
    settings.writeEntry(KIMERACONF + "_cmbkuten", QObject::tr(""));
    settings.writeEntry(KIMERACONF + "_cmbsymbol", QObject::tr(""));
    settings.writeEntry(KIMERACONF + "_cmbbracket", QObject::tr("֡"));
  
    settings.writeEntry(KIMERACONF + "_cmbkanjisys", QObject::tr("canna"));
    settings.writeEntry(KIMERACONF + "_chkremote", FALSE);
    settings.writeEntry(KIMERACONF + "_edtsvrname", "");
    settings.writeEntry(KIMERACONF + "_edtport", "");
  }

  initdone = TRUE;
}
