
#include "KThumbnailManagerDialog.h"


KThumbnailManagerDialog::KThumbnailManagerDialog()
  : KDialogBase(KDialogBase::Plain,I18N_NOOP("KThumbnailManager"),Cancel,Cancel)
{
    thumbnailmanager = new ThumbnailManager();
    QFrame *frame = plainPage();
    QGridLayout *lay = new QGridLayout(frame,0,0,5);
    widget = new KThumbnailManagerDialogBase(frame);
    lay->addWidget(widget,0,0);
    //widget->show();
    connect(thumbnailmanager,SIGNAL(changed()),SLOT(updatebar()));
//    connect(thumbnailmanager,SIGNAL(eofl()),SLOT(updatebar()));
    connect(thumbnailmanager,SIGNAL(eofl()),SLOT(finish()));
    connect(this,SIGNAL(cancelClicked()),SLOT(cancel()));
    connect(thumbnailmanager,SIGNAL(changed()),SLOT(goNext()));

}


KThumbnailManagerDialog::~KThumbnailManagerDialog()
{
}



void KThumbnailManagerDialog::updatebar()
{
    // ץ쥹СSLOT
    unsigned int value = thumbnailmanager->progress();
    widget->Progress->setValue(value);
    // 100%λ˥٥빹ȥե
    // QPtrList<ThumbnailList>ΥХե롣
    if ((value != 100) || (value == 0)) emit updatelabel();
}

void KThumbnailManagerDialog::updatelabel()
{
    // ٥빹SLOT
    QString text;
    unsigned int s = thumbnailmanager->getPrcessingThumbnail()->getIconsize();
    text = thumbnailmanager->getPrcessingThumbnail()->getFilename();
    text += "\n";
    text += i18n("Iconsize:");
        switch(s) {
        case ICON_XXL:
            text += "xxl";
            break;
        case ICON_LARGE:
            text += "large";
            break;
        case ICON_MED:
            text += "med";
            break;
        case ICON_SMALL:
            text += "small";
            break;
        default:
            text += QString::number(s);
    }
    widget->Status->setText(text);
}


void KThumbnailManagerDialog::finish()
{
    // λSLOT
    widget->Status->setText(i18n("Complete."));
    emit complete();
}


void KThumbnailManagerDialog::cancel()
{
    // 󥻥SLOT
    widget->Status->setText(i18n("Cancel."));
    emit complete();
}

void KThumbnailManagerDialog::goNext()
{
    // եSLOT(פ)
    kdDebug() << "goNext" << endl;
}


#include "KThumbnailManagerDialog.moc"





