/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_MOZ_EMBED_H__
#define __KZ_MOZ_EMBED_H__

#include <gtk/gtk.h>
#include <gtkmozembed.h>
#include "kazehakase.h"
#include "kz-embed-event.h"
#include "egg-menu-merge.h"

G_BEGIN_DECLS

#define KZ_TYPE_MOZ_EMBED		(kz_moz_embed_get_type ())
#define KZ_MOZ_EMBED(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_MOZ_EMBED, KzMozEmbed))
#define KZ_MOZ_EMBED_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_MOZ_EMBED, KzMozEmbedClass))
#define KZ_IS_MOZ_EMBED(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_MOZ_EMBED))
#define KZ_IS_MOZ_EMBED_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_MOZ_EMBED))
#define KZ_MOZ_EMBED_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_MOZ_EMBED, KzMozEmbedClass))

typedef struct _KzMozEmbed	KzMozEmbed;
typedef struct _KzMozEmbedClass	KzMozEmbedClass;
typedef struct _KzMozEmbedPriv	KzMozEmbedPriv;

struct _KzMozEmbed
{
	/* embedding widget */
	GtkMozEmbed parent;

	/* image popup window */
	GtkWidget *popup_window;
	
	/* location and title */
	gchar *location;
	gchar *title;

	gint load_started; /* count of currently active connections */
	gint load_percent;
	gint bytes_loaded;
	gint max_bytes_loaded;
	gboolean  is_loading;
	const gchar *load_status_message;
	
	KzMozEmbedPriv *priv;
};

struct _KzMozEmbedClass
{
	GtkMozEmbedClass parent_class;

	/* signal */
	void (*favicon)        (KzMozEmbed *kzembed, const gchar *uri);	
	void (*destroy_embed)  (KzMozEmbed *kzembed);	
};


GtkType      kz_moz_embed_get_type           (void);
GtkWidget   *kz_moz_embed_new                (const gchar  *url);

void         kz_moz_embed_load_url           (KzMozEmbed   *kzembed,
					      const gchar  *url);
void         kz_moz_embed_view_source        (KzMozEmbed   *kzembed);

#define      kz_moz_embed_is_loading(embed) \
                 (KZ_IS_MOZ_EMBED(embed) ? KZ_MOZ_EMBED(embed)->is_loading : FALSE)

const gchar *kz_moz_embed_get_title          (KzMozEmbed   *kzembed);
const gchar *kz_moz_embed_get_location       (KzMozEmbed   *kzembed);
gchar       *kz_moz_embed_ensure_title       (KzMozEmbed   *kzembed);
gchar       *kz_moz_embed_get_link_message   (KzMozEmbed   *kzembed);

gdouble      kz_moz_embed_get_progress       (KzMozEmbed   *kzembed);

gboolean     kz_moz_embed_can_cut_selection  (KzMozEmbed   *kzembed);
gboolean     kz_moz_embed_can_copy_selection (KzMozEmbed   *kzembed);
gboolean     kz_moz_embed_can_paste          (KzMozEmbed   *kzembed);
void         kz_moz_embed_cut_selection      (KzMozEmbed   *kzembed);
void         kz_moz_embed_copy_selection     (KzMozEmbed   *kzembed);
void         kz_moz_embed_paste              (KzMozEmbed   *kzembed);
void         kz_moz_embed_select_all         (KzMozEmbed   *kzembed);

gchar       *kz_moz_embed_get_selection_string(KzMozEmbed   *kzembed);

gboolean     kz_moz_embed_find               (KzMozEmbed   *embed,
					      const char   *keyword,
					      gboolean      backward);

gboolean     kz_moz_embed_selection_is_collapsed
					     (KzMozEmbed   *kzembed);

gboolean     kz_moz_embed_get_links          (KzMozEmbed   *kzembed,
					      GList       **list,
					      gboolean      selected_only);

void         kz_moz_embed_add_ui             (KzMozEmbed   *kzembed,
					      EggMenuMerge *ui,
					      KzUILevel     level);
void         kz_moz_embed_remove_ui          (KzMozEmbed   *kzembed);

glong        kz_moz_embed_get_key_event_info (KzMozEmbed   *kzembed,
					      gpointer      event,
					      KzEmbedEventKey **info);
glong        kz_moz_embed_get_mouse_event_info
					     (KzMozEmbed   *kzembed,
					      gpointer      event,
					      KzEmbedEventMouse **info);

void         kz_moz_embed_copy_page          (KzMozEmbed   *kzembed,
					      KzMozEmbed   *dkzembed);
gboolean     kz_moz_embed_shistory_copy      (KzMozEmbed   *source,
					      KzMozEmbed   *dest,
					      gboolean      back_history,
					      gboolean      forward_history,
					      gboolean      set_current);
gboolean     kz_moz_embed_shistory_get_pos   (KzMozEmbed *kzembed,
					      int *pos, int *count);
void         kz_moz_embed_shistory_get_nth   (KzMozEmbed *kzembed, 
					      int nth,
					      gboolean is_relative,
					      char **aUrl,
					      char **aTitle);

void         kz_moz_embed_reload             (KzMozEmbed   *kzembed,
					      gint32 flags);
void         kz_moz_embed_stop_load          (KzMozEmbed   *kzembed);
void         kz_moz_embed_go_back            (KzMozEmbed   *kzembed);
void         kz_moz_embed_go_forward         (KzMozEmbed   *kzembed);
void         kz_moz_embed_go_up              (KzMozEmbed   *kzembed);

gboolean     kz_moz_embed_can_go_back     (KzMozEmbed *kzembed);
gboolean     kz_moz_embed_can_go_forward  (KzMozEmbed *kzembed);
gboolean     kz_moz_embed_can_go_up       (KzMozEmbed *kzembed);
gboolean     kz_moz_embed_can_go_index    (KzMozEmbed *kzembed);
gboolean     kz_moz_embed_can_go_contents (KzMozEmbed *kzembed);
gboolean     kz_moz_embed_can_go_start    (KzMozEmbed *kzembed);
gboolean     kz_moz_embed_can_go_prev     (KzMozEmbed *kzembed);
gboolean     kz_moz_embed_can_go_next     (KzMozEmbed *kzembed);

void         kz_moz_embed_go_index     (KzMozEmbed *kzembed);
void         kz_moz_embed_go_contents  (KzMozEmbed *kzembed);
void         kz_moz_embed_go_start     (KzMozEmbed *kzembed);
void         kz_moz_embed_go_next      (KzMozEmbed *kzembed);
void         kz_moz_embed_go_prev      (KzMozEmbed *kzembed);

gboolean     kz_moz_embed_get_lock     (KzMozEmbed *kzembed);
void         kz_moz_embed_set_lock     (KzMozEmbed *kzembed,
					gboolean    lock);

gchar       *kz_moz_embed_get_body_text       (KzMozEmbed *kzembed);
gchar       *kz_moz_embed_get_selection_source(KzMozEmbed *kzembed);

void         kz_moz_embed_set_encoding (KzMozEmbed *kzembed,
					const char *encoding);
void         kz_moz_embed_get_encoding (KzMozEmbed *kzembed,
					char **encoding,
					gboolean *forced);

gboolean impl_save (KzMozEmbed *embed);

G_END_DECLS

#endif /* __KZ_MOZ_EMBED_H__ */
