/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KAZEHAKASE_H__
#define __KAZEHAKASE_H__

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif /* HAVE_CONFIG_H */

#include <string.h>
#include <glib.h>
#include "kz-profile.h"
#include "bookmarks/kz-root-bookmark.h"

G_BEGIN_DECLS

#define KAZEHAKASE_URI "http://kazehakase.sourceforge.jp/"


typedef enum {
	KZ_UI_LEVEL_INVALID  = 0,
	KZ_UI_LEVEL_BEGINNER = 1,
	KZ_UI_LEVEL_MEDIUM   = 2,
	KZ_UI_LEVEL_EXPERT   = 4,
	KZ_UI_LEVEL_CUSTOM   = 8,
	KZ_UI_LEVEL_ALL      = 0xFFFF
} KzUILevel;


KzUILevel    kz_ui_level           (void);
KzUILevel    kz_ui_level_from_str  (const gchar *level);
const gchar *kz_ui_level_to_str    (KzUILevel level);
const gchar *kz_ui_level_to_suffix (KzUILevel level);


extern KzProfile      *kz_global_profile;
extern KzProfile      *kz_session;
extern KzProfile      *kz_proxy;
extern KzRootBookmark *kz_bookmarks;


#define KZ_CONF_GET(s, k, v, t)					\
	kz_profile_get_value(kz_global_profile,			\
			     s, k, &(v), sizeof(v),		\
			     KZ_PROFILE_VALUE_TYPE_##t)
#define KZ_CONF_SET(s, k, v, t)					\
	kz_profile_set_value(kz_global_profile,			\
			     s, k, &(v), sizeof(v),		\
			     KZ_PROFILE_VALUE_TYPE_##t)
#define KZ_CONF_GET_STR(s, k)					\
	kz_profile_get_string(kz_global_profile, s, k)
#define KZ_CONF_SET_STR(s, k, v)				\
	 kz_profile_set_value(kz_global_profile,		\
			      s, k,				\
			      (gchar *)v,			\
			      strlen((gchar *)v) + 1,		\
			      KZ_PROFILE_VALUE_TYPE_STRING)
#define NIKU _("niku")


G_END_DECLS

#endif /* __KAZEAKASE_H__ */
