/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-editor.h,v 1.9 2004/03/21 12:29:08 makeinu Exp $
 */

#ifndef __KZ_BOOKMARK_EDITOR_H__
#define __KZ_BOOKMARK_EDITOR_H__

#include <gtk/gtk.h>
#include "kz-bookmark.h"
#include "egg-menu-merge.h"
#include "kz-favicon.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_EDITOR			(kz_bookmark_editor_get_type ())
#define KZ_BOOKMARK_EDITOR(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_EDITOR, KzBookmarkEditor))
#define KZ_BOOKMARK_EDITOR_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_BOOKMARK_EDITOR, KzBookmarkEditorClass))
#define KZ_IS_BOOKMARK_EDITOR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_EDITOR))
#define KZ_IS_BOOKMARK_EDITOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_BOOKMARK_EDITOR))
#define KZ_BOOKMARK_EDITOR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_BOOKMARK_EDITOR, KzBookmarkEditorClass))

typedef struct _KzBookmarkEditor	KzBookmarkEditor;
typedef struct _KzBookmarkEditorClass	KzBookmarkEditorClass;
typedef struct _KzBookmarkEditorPriv	KzBookmarkEditorPriv;

struct _KzBookmarkEditor
{
	GtkWindow   parent;

	GtkWidget  *vbox;
	GtkWidget  *hpaned, *vpaned;
	GtkWidget  *scrolledwin[2];
	GtkWidget  *folder_view;
	GtkWidget  *bookmarks_view;
	GtkWidget  *content_view;
	GtkWidget  *statusbar;

	KzBookmark *root_folder;
	KzBookmark *current_folder;

	/* other objects */
	EggActionGroup *action_group;
	EggMenuMerge   *menu_merge;

	KzBookmarkEditorPriv *priv;
};

struct _KzBookmarkEditorClass
{
	GtkWindowClass parent_class;
};

GtkType     kz_bookmark_editor_get_type           (void);
GtkWidget  *kz_bookmark_editor_new                (KzBookmark       *bookmark);

void        kz_bookmark_editor_set_current        (KzBookmarkEditor *editor,
						   KzBookmark       *bookmark);
void        kz_bookmark_editor_set_tree_mode      (KzBookmarkEditor *editor,
						   gboolean          tree_mode);

/* folder tree view */
void        kz_bookmark_editor_folder_view_select (KzBookmarkEditor *editor,
						   KzBookmark       *folder);
void        kz_bookmark_editor_bookmarks_view_select(KzBookmarkEditor *editor,
						     KzBookmark *bookmark);

void        kz_bookmark_editor_store_state        (KzBookmarkEditor *editor);
void        kz_bookmark_editor_restore_state      (KzBookmarkEditor *editor);

/* bookmarks view */
GList      *kz_bookmark_editor_get_selected_list  (KzBookmarkEditor *editor);

G_END_DECLS

#endif /* __KZ_BOOKMARK_EDITOR_H__ */
