/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_PREFS_WIN_H__
#define __KZ_PREFS_WIN_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_PREFS_WIN		(kz_prefs_win_get_type ())
#define KZ_PREFS_WIN(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PREFS_WIN, KzPrefsWin))
#define KZ_PREFS_WIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_PREFS_WIN, KzPrefsWinClass))
#define KZ_IS_PREFS_WIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PREFS_WIN))
#define KZ_IS_PREFS_WIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_PREFS_WIN))
#define KZ_PREFS_WIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_PREFS_WIN, KzPrefsWinClass))

typedef struct _KzPrefsWin           KzPrefsWin;
typedef struct _KzPrefsWinClass      KzPrefsWinClass;
typedef struct _KzPrefsWinPriv       KzPrefsWinPriv;
typedef struct _KzPrefsWinPageEntry  KzPrefsWinPageEntry;

struct _KzPrefsWin
{
	GtkDialog dialog;

	GtkWidget *paned;
	GtkWidget *scrolled_window;
	GtkWidget *tree_view;
	GtkWidget *notebook;

	KzPrefsWinPriv *priv;
};

struct _KzPrefsWinClass
{
	GtkDialogClass parent_class;
};

struct _KzPrefsWinPageEntry
{
	const gchar *path;

	gint priority_hint;

	GtkWidget     *(*create)          (void);
	void           (*response)        (GtkWidget *widget,
					   gint     response);
};

GtkType    kz_prefs_win_get_type          (void);
GtkWidget *kz_prefs_win_new               (void);

GtkWidget *kz_prefs_ui_utils_create_title (const gchar *title);

G_END_DECLS

#endif /* __KZ_PREFS_WIN_H__ */
