/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_GESTURE_H__
#define __KZ_GESTURE_H__

#include <glib-object.h>
#include <egg-action.h>

G_BEGIN_DECLS

#define KZ_TYPE_GESTURE			(kz_gesture_get_type ())
#define KZ_GESTURE(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_GESTURE, KzGesture))
#define KZ_GESTURE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_GESTURE, KzGestureClass))
#define KZ_IS_GESTURE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_GESTURE))
#define KZ_IS_GESTURE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_GESTURE))
#define KZ_GESTURE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_GESTURE, KzGestureClass))

typedef struct _KzGesture KzGesture;
typedef struct _KzGestureClass KzGestureClass;
typedef struct _KzGestureDefTable KzGestureDefTable;
typedef struct _KzGestureItem KzGestureItem;
typedef struct _KzGestureItems KzGestureItems;

typedef enum {
	KZ_GESTURE_MOTION_TERMINATOR,
	KZ_GESTURE_MOTION_UP,
	KZ_GESTURE_MOTION_DOWN,
	KZ_GESTURE_MOTION_LEFT,
	KZ_GESTURE_MOTION_RIGHT,
	KZ_GESTURE_N_MOTIONS
} KzGestureMotion;

struct _KzGesture
{
	GObject parent;

	KzGestureMotion  sequence[32];
	gint             sequence_len;
	gint             max_sequence_len;
	gint             current_mode;
	gint             prev_x, prev_y;
	gint             x, y;
	gboolean         started;
	gint             threshold;

	KzGestureItems  *items;
};

struct _KzGestureClass
{
	GObjectClass parent_class;

	/* -- signals (draft) -- */
	void (*start)        (KzGesture *gesture);
	void (*stack_motion) (KzGesture *gesture,
			      KzGestureMotion motion);
	void (*perform)      (KzGesture *gesture);
};

struct _KzGestureItem
{
	EggAction       *action;
	gint             mode;
	KzGestureMotion *sequence;
};

struct _KzGestureItems
{
	GSList *list;
	gint ref_count;
};

GType        kz_gesture_get_type                 (void);
KzGesture   *kz_gesture_new                      (void);

void         kz_gesture_set_items              (KzGesture *gesture,
						KzGestureItems *items);

gboolean     kz_gesture_start                  (KzGesture *gesture,
						gint mode,
						gint x, gint y);
gboolean     kz_gesture_perform                (KzGesture *gesture);
void         kz_gesture_cancel                 (KzGesture *gesture);
gboolean     kz_gesture_is_started             (KzGesture *gesture);
void         kz_gesture_update_position        (KzGesture *gesture,
						gint x, gint y);
void         kz_gesture_create_gesture_string  (KzGesture *gesture,
						gchar buf[], gint len);
const gchar *kz_gesture_get_matched_label      (KzGesture *gesture);


KzGestureItems *kz_gesture_items_new           (void);
KzGestureItems *kz_gesture_items_ref           (KzGestureItems *items);
void            kz_gesture_items_unref         (KzGestureItems *items);
void            kz_gesture_items_add_action    (KzGestureItems *items,
						EggAction *action,
						gint mode,
						const KzGestureMotion *sequence);

#if 0 /* API draft */
gboolean   kz_gesture_def_table_regist_func    (KzGestureDefTable *table,
						gint mode,
						GFunc func,
						gpointer data,
						GDestroyNotify *notify,
						KzGestureMotion sequence[]);

void       kz_gesture_set_definition_table     (KzGesture *gesture,
						KzGestureDefTable *table);
gboolean   kz_gesture_is_matched               (KzGesture +gesture);
void       kz_gesture_get_current_position     (KzGesture *gesture,
					        gint *x, gint *y);
gboolean   kz_gesture_get_curent_sequence      (KzGesture *gesture,
					        KzGesture *sequence[],
					        gint *len);
void       kz_gesture_set_mode                 (KzGesture *gesture,
					        gint mode);
void       kz_gesture_set_threshold            (KzGesture *gesture,
					        gint threshold);
#endif /* API draft */

G_END_DECLS

#endif /* __KZ_GESTURE_H__ */
