/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_general.h"


#define DATA_KEY "PrefsGeneral::info"


static GtkWidget     *prefs_general_create          (void);
static void           prefs_general_response        (GtkWidget *widget,
						     gint       response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:            "/General",
	priority_hint:   0,
	create:          prefs_general_create,
	response:        prefs_general_response,
};


typedef struct _PrefsGeneral
{
	GtkWidget     *main_vbox;
} PrefsGeneral;


static void
prefs_general_destroy (gpointer data)
{
	PrefsGeneral *prefsui = data;

	g_free(prefsui);
}


static GtkWidget *
prefs_general_create (void)
{
	PrefsGeneral *prefsui = g_new0(PrefsGeneral, 1);
	GtkWidget *main_vbox, *vbox, *hbox, *frame;
	GtkWidget *label, *entry;

	main_vbox = gtk_vbox_new(FALSE, 0);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full(G_OBJECT(main_vbox), DATA_KEY,
			       prefsui, prefs_general_destroy);

	label = kz_prefs_ui_utils_create_title("General");
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);

	vbox = gtk_vbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), vbox,
			   TRUE, TRUE, 0);
	gtk_widget_show(vbox);

	/*
	 *  Start Page
	 */
	frame = gtk_frame_new("Start page");
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(hbox), 5);
	gtk_container_add(GTK_CONTAINER(frame), hbox);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic("_Location: ");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
	gtk_widget_show(label);

	entry = gtk_entry_new();
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), entry);
	gtk_box_pack_start(GTK_BOX(hbox), entry, TRUE, TRUE, 2);
	gtk_widget_show(entry);

	return main_vbox;
}



static void
prefs_general_response (GtkWidget *widget, gint response)
{
}


KzPrefsWinPageEntry *
prefs_general_get_entry (void)
{
	return &prefs_entry;
}
