/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "prefs_font.h"


#define DATA_KEY "PrefsFont::info"


static GtkWidget *prefs_font_create   (void);
static void       prefs_font_response (GtkWidget *widget, gint response);


static KzPrefsWinPageEntry prefs_entry =
{
	path:          "/Font",
	priority_hint: 0,
	create:        prefs_font_create,
	response:      prefs_font_response,
};


typedef struct _PrefsFont
{
	GtkAccelGroup *accel_group;
	GtkWidget     *main_vbox;
} PrefsFont;


static void
prefs_font_destroy (gpointer data)
{
	PrefsFont *prefsui = data;

	g_object_unref(prefsui->accel_group);
	g_free(prefsui);
}


static GtkWidget *
prefs_font_create (void)
{
	PrefsFont *prefsui = g_new0(PrefsFont, 1);
	GtkWidget *main_vbox, *vbox, *hbox;
	GtkWidget *frame, *table, *label, *menu, *combo;

	prefsui->accel_group = gtk_accel_group_new();

	main_vbox = gtk_vbox_new (FALSE, 5);
	prefsui->main_vbox = main_vbox;
	g_object_set_data_full (G_OBJECT(main_vbox),
				DATA_KEY, prefsui,
				(GDestroyNotify) prefs_font_destroy);

	label = kz_prefs_ui_utils_create_title("Font");
	gtk_box_pack_start(GTK_BOX(main_vbox), label,
			   FALSE, FALSE, 0);
	gtk_widget_show(label);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 5);
	gtk_box_pack_start(GTK_BOX(main_vbox), vbox,
			   TRUE, TRUE, 0);
	gtk_widget_show(vbox);

	/*
	 *  Fonts for
	 */
	frame = gtk_frame_new(NULL);
	gtk_frame_set_label_align(GTK_FRAME(frame), 0.03, 0.5);
	gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_frame_set_label_widget(GTK_FRAME(frame), hbox);
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic("_Fonts for: ");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	menu = gtk_option_menu_new();
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), menu);
	gtk_box_pack_start(GTK_BOX(hbox), menu, FALSE, FALSE, 0);
	gtk_widget_show(menu);

	table = gtk_table_new(3, 2, FALSE);
	gtk_container_set_border_width(GTK_CONTAINER(table), 5);
	gtk_container_add(GTK_CONTAINER(frame), table);
	gtk_widget_show(table);

	/*
	 *  Propotional
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach(GTK_TABLE(table), hbox,
			 0, 1, 0, 1,  /* xpos, ypos */
			 GTK_FILL, 0,
			 2, 2);       /* padding x, y  */
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic("_Propotional: ");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	menu = gtk_option_menu_new();
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), menu);
	gtk_table_attach(GTK_TABLE(table), menu,
			 1, 2, 0, 1,
			 GTK_EXPAND | GTK_FILL, 0,
			 2, 2);
	gtk_widget_show(menu);

	/* font size */
	label = gtk_label_new_with_mnemonic("Si_ze:");
	gtk_table_attach(GTK_TABLE(table), label,
			 2, 3, 0, 1,  /* xpos, ypos */
			 GTK_FILL, 0,
			 4, 2);       /* padding x, y  */
	gtk_widget_show(label);

	combo = gtk_combo_new();
	gtk_widget_set_size_request(combo, 80, -1);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), GTK_COMBO(combo)->entry);
	gtk_table_attach(GTK_TABLE(table), combo,
			 3, 4, 0, 1,
			 GTK_FILL, 0,
			 2, 2);
	gtk_widget_show(combo);

	/*
	 *  Serif
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach(GTK_TABLE(table), hbox,
			 0, 1, 1, 2,  /* xpos, ypos */
			 GTK_FILL, 0,
			 2, 2);       /* padding x, y  */
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic("_Serif: ");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	combo = gtk_combo_new();
	gtk_widget_set_size_request(combo, 90, -1);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), GTK_COMBO(combo)->entry);
	gtk_table_attach(GTK_TABLE(table), combo,
			 1, 2, 1, 2,
			 GTK_EXPAND | GTK_FILL, 0,
			 2, 2);
	gtk_widget_show(combo);

	/*
	 *  Sans Serif
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach(GTK_TABLE(table), hbox,
			 0, 1, 2, 3,  /* xpos, ypos */
			 GTK_FILL, 0,
			 2, 2);       /* padding x, y  */
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic("Sa_ns Serif: ");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	combo = gtk_combo_new();
	gtk_widget_set_size_request(combo, 90, -1);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), GTK_COMBO(combo)->entry);
	gtk_table_attach(GTK_TABLE(table), combo,
			 1, 2, 2, 3,
			 GTK_EXPAND | GTK_FILL, 0,
			 2, 2);
	gtk_widget_show(combo);

	/*
	 *  Monospace
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach(GTK_TABLE(table), hbox,
			 0, 1, 3, 4,  /* xpos, ypos */
			 GTK_FILL, 0,
			 2, 2);       /* padding x, y  */
	gtk_widget_show(hbox);

	label = gtk_label_new_with_mnemonic("_Monospace: ");
	gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	combo = gtk_combo_new();
	gtk_widget_set_size_request(combo, 90, -1);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), GTK_COMBO(combo)->entry);
	gtk_table_attach(GTK_TABLE(table), combo,
			 1, 2, 3, 4,
			 GTK_EXPAND | GTK_FILL, 0,
			 2, 2);
	gtk_widget_show(combo);

	/* font size */
	label = gtk_label_new_with_mnemonic("Siz_e:");
	gtk_table_attach(GTK_TABLE(table), label,
			 2, 3, 3, 4,  /* xpos, ypos */
			 GTK_FILL, 0,
			 4, 2);       /* padding x, y  */
	gtk_widget_show(label);

	combo = gtk_combo_new();
	gtk_widget_set_size_request(combo, 80, -1);
	gtk_label_set_mnemonic_widget(GTK_LABEL(label), GTK_COMBO(combo)->entry);
	gtk_table_attach(GTK_TABLE(table), combo,
			 3, 4, 3, 4,
			 GTK_FILL, 0,
			 2, 2);
	gtk_widget_show(combo);

	/*
	 *  Minimam font size
	 */
	hbox = gtk_hbox_new(FALSE, 0);
	gtk_table_attach(GTK_TABLE(table), hbox,
			 0, 4, 5, 6,  /* xpos, ypos */
			 GTK_FILL, 0,
			 2, 4);       /* padding x, y  */
	gtk_widget_show(hbox);

	combo = gtk_combo_new();
	gtk_widget_set_size_request(combo, 80, -1);
	gtk_box_pack_end(GTK_BOX(hbox), combo, FALSE, FALSE, 0);
	gtk_widget_show(combo);

	label = gtk_label_new("M_inimum font size: ");
	gtk_label_set_use_underline(GTK_LABEL(label), TRUE);
	gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);

	gtk_label_set_mnemonic_widget(GTK_LABEL(label), GTK_COMBO(combo)->entry);

	return main_vbox;
}



static void
prefs_font_response (GtkWidget *widget, gint response)
{
}


KzPrefsWinPageEntry *
prefs_font_get_entry (void)
{
	return &prefs_entry;
}
