/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */

/*
 *  Copyright (C) 2006 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-rb-ext.h"

#define _SELF(obj) RVAL2KZAPP(obj)

static KzApp *kz_rb_app = NULL;
static VALUE  kz_rb_rb_app = Qnil;

KzApp *
_kz_rb_get_app(void)
{
    return kz_rb_app;
}

static VALUE
rb_kz_app_s_get_instance(VALUE self)
{
    return kz_rb_rb_app;
}

static VALUE
rb_kz_app_get_window_list(VALUE self)
{
    GList *list;
    list = (GList *)kz_app_get_window_list(_SELF(self));
    return GLIST2ARY(list);
}

void
_kz_rb_app_init(VALUE mKz, KzApp *app)
{
    VALUE cKzApp;

    cKzApp = G_DEF_CLASS(KZ_TYPE_APP, "App", mKz);

    kz_rb_app = app;
    kz_rb_rb_app = GOBJ2RVAL(kz_rb_app);
    rb_ivar_set(cKzApp, rb_intern("instance"), kz_rb_rb_app);
    rb_define_singleton_method(cKzApp, "instance", rb_kz_app_s_get_instance, 0);

    rb_define_method(cKzApp, "window_list", rb_kz_app_get_window_list, 0);

    G_DEF_SETTERS(cKzApp);
}
