/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_PASSWORD_MANAGER_DIALOG_H__
#define __KZ_PASSWORD_MANAGER_DIALOG_H__

#include <gtk/gtk.h>

#include "kz-window.h"

G_BEGIN_DECLS

#define KZ_TYPE_PASSWORD_MANAGER_DIALOG		   (kz_password_manager_dialog_get_type ())
#define KZ_PASSWORD_MANAGER_DIALOG(obj)		   (G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_PASSWORD_MANAGER_DIALOG, KzPasswordManagerDialog))
#define KZ_PASSWORD_MANAGER_DIALOG_CLASS(klass)	   (G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_PASSWORD_MANAGER_DIALOG, KzPasswordManagerDialogClass))
#define KZ_IS_PASSWORD_MANAGER_DIALOG(obj)	   (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_PASSWORD_MANAGER_DIALOG))
#define KZ_IS_PASSWORD_MANAGER_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_PASSWORD_MANAGER_DIALOG))
#define KZ_PASSWORD_MANAGER_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_PASSWORD_MANAGER_DIALOG, KzPasswordManagerDialogClass))

typedef struct _KzPasswordManagerDialog           KzPasswordManagerDialog;
typedef struct _KzPasswordManagerDialogClass      KzPasswordManagerDialogClass;

typedef struct
{
        gchar *host;
        gchar *username;
} PasswordInfo;

struct _KzPasswordManagerDialog
{
	GtkDialog parent;

	KzWindow     *kz;

	GtkWidget    *scrolled_window;
	GtkTreeView  *tree_view;
	GtkListStore *list_store;
};

struct _KzPasswordManagerDialogClass
{
	GtkDialogClass parent_class;
};

GType            kz_password_manager_dialog_get_type (void) G_GNUC_CONST;
GtkWidget       *kz_password_manager_dialog_new      (KzWindow   *kz);

G_END_DECLS

#endif /* __KZ_PASSWORD_MANAGER_DIALOG_H__ */
