/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */

/*
 *  Copyright (C) 2006 Kouhei Sutou <kou@cozmixng.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-rb-ext.h"

#define _SELF(obj) (KZ_STATUSBAR(RVAL2GOBJ(obj)))
#define RVAL2GTKWIDGET(obj) (GTK_WIDGET(RVAL2GOBJ(obj)))
#define RVAL2GTKACTION(obj) (GTK_ACTION(RVAL2GOBJ(obj)))
#define RVAL2GNODE(obj) (GTK_GNODE(RVAL2GOBJ(obj)))
#define RVAL2KZBOOKMARK(obj) (KZ_BOOKMARK(RVAL2GOBJ(obj)))
#define RVAL2KZWINDOW(obj) (KZ_WINDOW(RVAL2GOBJ(obj)))

static VALUE
rb_kz_statusbar_new(VALUE self, VALUE kz)
{
    GtkWidget *statusbar;
    statusbar = kz_statusbar_new(RVAL2KZWINDOW(kz));
    RBGTK_INITIALIZE(self, statusbar);
    return Qnil;
}

static VALUE
rb_kz_statusbar_set_text(VALUE self, VALUE rb_text, VALUE id_or_name)
{
    gchar *text = NULL;

    if (!NIL_P(rb_text))
        text = RVAL2CSTR(rb_text);

    if (RTEST(rb_obj_is_kind_of(id_or_name, rb_cString))) {
        kz_statusbar_set_text_with_name(_SELF(self), text,
                                        RVAL2CSTR(id_or_name));
    } else {
        kz_statusbar_set_text(_SELF(self), text, NUM2UINT(id_or_name));
    }
    return Qnil;
}

static VALUE
rb_kz_statusbar_set_link_text(VALUE self, VALUE text)
{
    kz_statusbar_set_link_text(_SELF(self), RVAL2CSTR(text));
    return Qnil;
}

static VALUE
rb_kz_statusbar_set_gesture_text(VALUE self, VALUE text)
{
    kz_statusbar_set_gesture_text(_SELF(self), RVAL2CSTR(text));
    return Qnil;
}

static VALUE
rb_kz_statusbar_set_focus_to_find_area(VALUE self)
{
    kz_statusbar_set_focus_to_find_area(_SELF(self));
    return Qnil;
}


void
Init_kz_rb_statusbar(VALUE mKz)
{
    VALUE cKzStatusbar;

    cKzStatusbar = G_DEF_CLASS(KZ_TYPE_STATUSBAR, "Statusbar", mKz);

    rb_define_method(cKzStatusbar, "initialize", rb_kz_statusbar_new, 1);

    rb_define_method(cKzStatusbar, "set_text", rb_kz_statusbar_set_text, 2);
    rb_define_method(cKzStatusbar, "set_link_text",
                     rb_kz_statusbar_set_link_text, 1);
    rb_define_method(cKzStatusbar, "set_gesture_text",
                     rb_kz_statusbar_set_gesture_text, 1);
    rb_define_method(cKzStatusbar, "set_focus_to_find_area",
                     rb_kz_statusbar_set_focus_to_find_area, 0);

    G_DEF_SETTERS(cKzStatusbar);
}
