/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */

/*
 *  Copyright (C) 2006 Eriko Sato
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copyED of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-rb-ext.h"

#define _SELF(obj) (KZ_WINDOW(RVAL2GOBJ(obj)))
#define RVAL2GTKWIDGET(obj) (GTK_WIDGET(RVAL2GOBJ(obj)))
#define RVAL2GNODE(obj) (GTK_GNODE(RVAL2GOBJ(obj)))
#define RVAL2KZBOOKMARK(obj) (KZ_BOOKMARK(RVAL2GOBJ(obj)))

static ID id_default;

static VALUE
rb_kz_window_new(VALUE self, VALUE url)
{
    GtkWidget *window;
    window = kz_window_new(RVAL2CSTR(url));
    RBGTK_INITIALIZE(self, window);
    return Qnil;
}

static VALUE
rb_kz_window_get_window_list(VALUE self)
{
    GList *list;
    list = kz_window_get_window_list();
    return GLIST2ARY(list);
}

static VALUE
rb_kz_window_set_default(VALUE self, VALUE window)
{
    rb_cvar_set(self, id_default, window, Qfalse);
    return Qnil;
}

static VALUE
rb_kz_window_get_default(VALUE self)
{
    return rb_cvar_get(self, id_default);
}

static VALUE
rb_kz_window_get_from_tab(VALUE self, VALUE tab_widget)
{
    GtkWidget *widget;
    widget = kz_window_get_from_tab(RVAL2GOBJ(tab_widget));
    return GOBJ2RVAL(widget);
}

static VALUE
rb_kz_window_open_new_tab(VALUE self, VALUE url)
{
    GtkWidget *widget;
    widget = kz_window_open_new_tab(_SELF(self), RVAL2CSTR(url));
    return GOBJ2RVAL(widget);
}

static VALUE
rb_kz_window_open_new_tab_at_tail(VALUE self, VALUE url)
{
    GtkWidget *widget;
    widget = kz_window_open_new_tab_at_tail(_SELF(self), RVAL2CSTR(url));
    return GOBJ2RVAL(widget);
}

static VALUE
rb_kz_window_open_new_tab_with_parent(VALUE self, VALUE url, VALUE parent)
{
    GtkWidget *widget;
    widget = kz_window_open_new_tab_with_parent(_SELF(self),
                                                RVAL2CSTR(url),
                                                RVAL2GTKWIDGET(parent));
    return GOBJ2RVAL(widget);
}

static VALUE
rb_kz_window_close_tab(VALUE self, VALUE widget)
{
    kz_window_close_tab(_SELF(self), RVAL2GTKWIDGET(widget));
    return self;
}

static VALUE
rb_kz_window_close_all_tab(VALUE self)
{
    kz_window_close_all_tab(_SELF(self));
    return self;
}

static VALUE
rb_kz_window_reorder_tab(VALUE self, VALUE widget, VALUE position)
{
    kz_window_reorder_tab(_SELF(self), RVAL2GTKWIDGET(widget),
                          NUM2INT(position));
    return self;
}

static VALUE
rb_kz_window_move_tab(VALUE self, VALUE widget)
{
    kz_window_move_tab(_SELF(self), RVAL2GTKWIDGET(widget));
    return self;
}

static VALUE
rb_kz_window_load_url(VALUE self, VALUE url)
{
    kz_window_load_url(_SELF(self), RVAL2CSTR(url));
    return self;
}

static VALUE
rb_kz_window_store_state(VALUE self)
{
    kz_window_store_state(_SELF(self));
    return self;
}

static VALUE
rb_kz_window_restore_state(VALUE self)
{
    kz_window_restore_state(_SELF(self));
    return self;
}

static VALUE
rb_kz_window_update_gesture_items(VALUE self)
{
  kz_window_update_gesture_items(_SELF(self));
  return self;
}

static VALUE
rb_kz_window_get_title(VALUE self)
{
    const gchar *title;
    title = kz_window_get_title(_SELF(self));
    return CSTR2RVAL(title);
}

static VALUE
rb_kz_window_get_uri(VALUE self)
{
    const gchar *uri;
    uri = kz_window_get_uri(_SELF(self));
    return CSTR2RVAL(uri);
}

static VALUE
rb_kz_window_get_tab_label(VALUE self, VALUE widget)
{
    GtkWidget *Widget;
    Widget = kz_window_get_tab_label(_SELF(self),
                                     RVAL2GTKWIDGET(widget));
    return GOBJ2RVAL(Widget);
}

static VALUE
rb_kz_window_get_tree(VALUE self)
{
    GNode *node;
    node = kz_window_get_tree(_SELF(self));
    return GOBJ2RVAL(node);
}

static VALUE
rb_kz_window_get_mouse_event_info(VALUE self)
{
    const KzEmbedEventMouse *event_mouse;
    event_mouse = kz_window_get_mouse_event_info(_SELF(self));
    return EVENTMOUSE2RVAL((KzEmbedEventMouse *)event_mouse);
}

static VALUE
rb_kz_window_append_closed_tab(VALUE self, VALUE bookmark)
{
    kz_window_append_closed_tab(_SELF(self), RVAL2KZBOOKMARK(bookmark));
    return self;
}


/* reader */
static VALUE
rb_kz_window_actions(VALUE self)
{
  return GOBJ2RVAL(_SELF(self)->actions);
}

static VALUE
rb_kz_window_popup_actions(VALUE self)
{
  return GOBJ2RVAL(_SELF(self)->popup_actions);
}

static VALUE
rb_kz_window_tabpop_actions(VALUE self)
{
  return GOBJ2RVAL(_SELF(self)->tabpop_actions);
}

static VALUE
rb_kz_window_menu_merge(VALUE self)
{
  return GOBJ2RVAL(_SELF(self)->menu_merge);
}

static VALUE
rb_kz_window_statusbar(VALUE self)
{
  return GOBJ2RVAL(_SELF(self)->statusbar);
}



static VALUE
rb_kz_window_nth_page(VALUE self, VALUE n)
{
  return GOBJ2RVAL(KZ_WINDOW_NTH_PAGE(_SELF(self), NUM2INT(n)));
}

static VALUE
rb_kz_window_current_page(VALUE self)
{
  return GOBJ2RVAL(KZ_WINDOW_CURRENT_PAGE(_SELF(self)));
}

void
Init_kz_rb_window(VALUE mKz)
{
    VALUE cKzWindow;

    id_default = rb_intern("@@default");

    cKzWindow = G_DEF_CLASS(KZ_TYPE_WINDOW, "Window", mKz);

    rb_define_singleton_method(cKzWindow, "set_default",
                               rb_kz_window_set_default, 1);
    rb_alias(rb_singleton_class(cKzWindow),
             rb_intern("default="), rb_intern("set_default"));
    rb_define_singleton_method(cKzWindow, "default",
                               rb_kz_window_get_default, 0);

    rb_define_singleton_method(cKzWindow, "get_from_tab",
                               rb_kz_window_get_from_tab, 1);

    rb_define_method(cKzWindow, "initialize", rb_kz_window_new, 1);

    rb_define_method(cKzWindow, "window_list",
                     rb_kz_window_get_window_list, 0);
    rb_define_method(cKzWindow, "open_new_tab",
                     rb_kz_window_open_new_tab, 1);
    rb_define_method(cKzWindow, "open_new_tab_at_tail",
                     rb_kz_window_open_new_tab_at_tail, 1);
    rb_define_method(cKzWindow, "open_new_tab_with_parent",
                     rb_kz_window_open_new_tab_with_parent, 2);
    rb_define_method(cKzWindow, "close_tab", rb_kz_window_close_tab, 1);
    rb_define_method(cKzWindow, "close_all_tab",
                     rb_kz_window_close_all_tab, 0);
    rb_define_method(cKzWindow, "reorder_tab",
                     rb_kz_window_reorder_tab, 2);
    rb_define_method(cKzWindow, "move_tab", rb_kz_window_move_tab, 1);
    rb_define_method(cKzWindow, "load_url", rb_kz_window_load_url, 1);
    rb_define_method(cKzWindow, "store_state",
                     rb_kz_window_store_state, 0);
    rb_define_method(cKzWindow, "restore_state",
                     rb_kz_window_restore_state, 0);
    rb_define_method(cKzWindow, "update_gesture_items",
                     rb_kz_window_update_gesture_items, 0);
    rb_define_method(cKzWindow, "title", rb_kz_window_get_title, 0);
    rb_define_method(cKzWindow, "uri", rb_kz_window_get_uri, 0);
    rb_define_method(cKzWindow, "get_tab_label",
                     rb_kz_window_get_tab_label, 1);
    rb_define_method(cKzWindow, "tree", rb_kz_window_get_tree, 0);

    rb_define_method(cKzWindow, "mouse_event_info",
                     rb_kz_window_get_mouse_event_info, 0);
    rb_define_method(cKzWindow, "append_closed_tab",
                     rb_kz_window_append_closed_tab, 1);


    /* reader */
    rb_define_method(cKzWindow, "actions", rb_kz_window_actions, 0);
    rb_define_method(cKzWindow, "popup_actions",
                     rb_kz_window_popup_actions, 0);
    rb_define_method(cKzWindow, "tabpop_actions",
                     rb_kz_window_tabpop_actions, 0);
    rb_define_method(cKzWindow, "menu_merge", rb_kz_window_menu_merge, 0);
    rb_define_method(cKzWindow, "statusbar", rb_kz_window_statusbar, 0);

    rb_define_method(cKzWindow, "current_page", rb_kz_window_current_page, 0);
    rb_define_method(cKzWindow, "nth_page", rb_kz_window_nth_page, 1);


    G_DEF_SETTERS(cKzWindow);
}
