/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmarks-sidebar.h,v 1.1.1.1 2005/03/27 12:58:43 poincare Exp $
 */

#include "kz-sidebar.h"

#include "kz-bookmarks-view.h"

#ifndef __KZ_BOOKMARKS_SIDEBAR_H__
#define __KZ_BOOKMARKS_SIDEBAR_H__

#define KZ_TYPE_BOOKMARKS_SIDEBAR		(kz_bookmarks_sidebar_get_type ())
#define KZ_BOOKMARKS_SIDEBAR(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARKS_SIDEBAR, KzBookmarksSidebar))
#define KZ_BOOKMARKS_SIDEBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_BOOKMARKS_SIDEBAR, KzBookmarksSidebarClass))
#define KZ_IS_BOOKMARKS_SIDEBAR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARKS_SIDEBAR))
#define KZ_IS_BOOKMARKS_SIDEBAR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_BOOKMARKS_SIDEBAR))
#define KZ_BOOKMARKS_SIDEBAR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_BOOKMARKS_SIDEBAR, KzBookmarksSidebarClass))

typedef struct _KzBookmarksSidebar	KzBookmarksSidebar;
typedef struct _KzBookmarksSidebarClass	KzBookmarksSidebarClass;
typedef struct _KzBookmarksSidebarPriv	KzBookmarksSidebarPriv;
typedef struct _KzBookmarksSidebarItem	KzBookmarksSidebarItem;

struct _KzBookmarksSidebar
{
	GtkVBox parent;

	KzSidebar        *sidebar;

	KzBookmarksView  *view;
};

struct _KzBookmarksSidebarClass
{
	GtkVBoxClass parent_class;
};

KzSidebarEntry   *kz_bookmarks_sidebar_get_entry (gint idx);

GType		  kz_bookmarks_sidebar_get_type  (void) G_GNUC_CONST;
GtkWidget        *kz_bookmarks_sidebar_new       (KzSidebar *sidebar);

#endif /* __KZ_BOOKMARKS_SIDEBAR_H__ */
