/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-root-bookmark.h,v 1.1.1.1 2005/03/27 12:58:27 poincare Exp $
 */

#ifndef __KZ_ROOT_BOOKMARK_H__
#define __KZ_ROOT_BOOKMARK_H__

#include "kz-bookmark.h"
#include "kz-history.h"

G_BEGIN_DECLS

#define KZ_TYPE_ROOT_BOOKMARK		(kz_root_bookmark_get_type ())
#define KZ_ROOT_BOOKMARK(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_ROOT_BOOKMARK, KzRootBookmark))
#define KZ_ROOT_BOOKMARK_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_ROOT_BOOKMARK, KzRootBookmarkClass))
#define KZ_IS_ROOT_BOOKMARK(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_ROOT_BOOKMARK))
#define KZ_IS_ROOT_BOOKMARK_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_ROOT_BOOKMARK))
#define KZ_ROOT_BOOKMARK_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_ROOT_BOOKMARK, KzRootBookmarkClass))

typedef struct _KzRootBookmark      KzRootBookmark;
typedef struct _KzRootBookmarkClass KzRootBookmarkClass;
typedef struct _KzRootBookmarkPriv  KzRootBookmarkPriv;

struct _KzRootBookmark
{
	KzBookmark parent;

	KzBookmark *menu;
	KzBookmark *bookmark_bars;
	KzHistory  *history;

	KzBookmark *clip;
	
	KzBookmark *smarts;
	/* ??? */
	KzBookmark *sessions;
	KzBookmark *current_session;
	KzBookmark *tab_groups;

	KzRootBookmarkPriv *priv;
};

struct _KzRootBookmarkClass
{
	KzBookmarkClass parent_class;

	/* -- signals -- */
};

GType		kz_root_bookmark_get_type	      (void) G_GNUC_CONST;

KzRootBookmark *kz_root_bookmark_new		      (const gchar *menu_file,
						       const gchar *sys_menu_file,
						       const gchar *clip_file,
						       const gchar *sys_clip_file);
void		kz_root_bookmark_set_menu_file	      (KzRootBookmark *root,
						       const gchar    *file,
						       const gchar    *subfile);
void		kz_root_bookmark_set_clip_file	      (KzRootBookmark *root,
						       const gchar    *file,
						       const gchar    *subfile);
void		kz_root_bookmark_add_bookmark_bar_file(KzRootBookmark *root,
						       const gchar    *file,
						       const gchar    *subfile);
void	        kz_root_bookmark_add_smartbookmark_file
						      (KzRootBookmark *root,
						       const gchar    *file,
						       const gchar    *subfile);
void	        kz_root_bookmark_add_current_session_file
						      (KzRootBookmark *root,
						       const gchar    *file);
void		kz_root_bookmark_set_history_file     (KzRootBookmark *root,
						       const gchar    *file);

void		kz_root_bookmark_save_all	      (KzRootBookmark *root);

/*
 *  * RootBookmarkFolder
 *     |
 *     +-- Bookmark Menu Folder
 *     |    |
 *     |    +-- ......
 *     |
 *     +-- Bookmark Bars Folder
 *     |    |
 *     |    +-- Bookmark Bar 0
 *     |    |
 *     |    +-- Bookmark Bar 1
 *     |    |
 *     |    +-- ......
 *     |
 *     +-- History
 *     |    |
 *     |    +-- ......
 *     |
 *     +-- Sessions
 *     |    |
 *     |    +-- Session 0
 *     |    |
 *     |    +-- Session 1
 *     |    |
 *     |    +-- ......
 *     |
 *     +-- Current session
 *     |    | 
 *     |    +-- Window 0
 *     |    |    |
 *     |    |    +-- Tab 0
 *     |    |    |
 *     |    |    +-- Tab 1
 *     |    |    |
 *     |    |    +-- ......
 *     |    |
 *     |    +-- Window 1
 *     |         | 
 *     |         +-- Tab 0
 *     |         |
 *     |         +-- Tab 1
 *     |         |
 *     |         +-- ...... 
 *     |
 *     +-- Tab Groups
 *          |
 *          +-- Tab Group 0
 *          |
 *          +-- Tab Group 1
 *          |
 *          +-- ......
 *
 */

G_END_DECLS

#endif /* __KZ_ROOT_BOOKMARK_H__ */
