/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundatxml_rpcn; either versxml_rpcn 2, or (at your optxml_rpcn)
 *  any later versxml_rpcn.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundatxml_rpcn, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_XML_RPC_H__
#define __KZ_XML_RPC_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define KZ_TYPE_XML_RPC		(kz_xml_rpc_get_type ())
#define KZ_XML_RPC(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_XML_RPC, KzXMLRPC))
#define KZ_XML_RPC_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_XML_RPC, KzXMLRPCClass))
#define KZ_IS_XML_RPC(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_XML_RPC))
#define KZ_IS_XML_RPC_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_XML_RPC))
#define KZ_XML_RPC_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_XML_RPC, KzXMLRPCClass))


typedef struct _KzXMLRPC KzXMLRPC;
typedef struct _KzXMLRPCClass KzXMLRPCClass;
typedef struct _KzXMLRPCPrivate KzXMLRPCPrivate;


struct _KzXMLRPC
{
	GObject parent;

	KzXMLRPCPrivate *priv;
};

struct _KzXMLRPCClass
{
	GObjectClass parent_class;

	/* -- signals -- */
	void      (*xml_rpc_completed)   (KzXMLRPC *xmlrpc, GError *error);
};


GType      kz_xml_rpc_get_type 	       (void);
KzXMLRPC  *kz_xml_rpc_new              (const gchar *uri);

void       kz_xml_rpc_call             (KzXMLRPC *xmlrpc, 
		 			const gchar *method_name,
		 			const gchar *param,
		 			...);
const GList *kz_xml_rpc_get_results      (KzXMLRPC *xmlrpc);

G_END_DECLS

#endif /* __KZ_XML_RPC_H__ */
