/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2002 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  Global actions for main window.
 */

#ifndef __KZ_ACTIONS_H__
#define __KZ_ACTIONS_H__

#ifdef HAVE_CONFIG_H
#	include "config.h"
#endif /* HAVE_CONFIG_H */

#include <gtk/gtk.h>
#include "kz-window.h"
#include "kz-embed.h"
#include "kz-bookmark.h"

G_BEGIN_DECLS

extern GtkActionEntry kz_actions[];
extern const gint     kz_actions_len;

GtkActionGroup *kz_actions_create_group              (KzWindow      *kz,
						      GtkAccelGroup *accel_group);

void            kz_actions_set_sensitive             (KzWindow      *kz,
						      KzEmbed       *kzembed);
void            kz_actions_set_tab_sensitive         (KzWindow      *kz,
						      KzEmbed       *kzembed);
void            kz_actions_set_selection_sensitive   (KzWindow      *kz,
						      KzEmbed       *kzembed);

KzBookmark     *kz_actions_get_bookmark_for_action   (KzWindow      *kz);
void            kz_actions_set_bookmark_for_action   (KzWindow      *kz,
						      KzBookmark    *bookmark);
void            kz_actions_popup_bookmark_menu_modal (KzWindow      *kz,
						      KzBookmark    *bookmark,
						      guint          button,
						      guint          time);

void            kz_actions_insert_smartbookmark      (KzWindow      *kz,
						      KzBookmark    *bookmark,
						      KzBookmark    *child,
						      KzBookmark    *sibling);
void            kz_actions_remove_smartbookmark      (KzWindow      *kz,
						      KzBookmark    *bookmark,
						      KzBookmark    *child);
void            kz_actions_update_smartbookmarks     (KzWindow      *kz,
						      KzBookmark    *bookmark);

G_END_DECLS

#endif /* __KZ_ACTIONS_H__ */
