unit untTopicDownloadThread;

interface

uses
  Classes, SysUtils, Dialogs, SyncObjs,
  untStreamTool, untTool,
  untBBSCore, untTopic, untGlobal, untOption,
  IdComponent, RegExpr,
  untBBSSub, untBoard, jconvert, untBBSFramework,
  untBBS2ch, untBBS2chKako, IdThreadMgr, IdThread;

type
  TTopicDownloadThread = class
  published
  protected
    FBBSGetTopic    : TBBSGetTopic;
    FTopic         : TTopic;
    FNoDownload     : Boolean;
    FTopicStateType : TTopicStateType;
    FDatFile        : TextFile;
    FNewMessage     : TTopicMessage;
    FBuffer         : TMemoryStream;
    FBufferReader   : TStreamReader;
    FReadPosition   : int64;
    FMessageCount   : integer;
    FNoFirstLine    : Boolean;
    FDatValue       : string;
    FRegex          : TRegExpr;
    FReadCgi        : boolean;
    FBufferLine     : string;
    FReceivedIndex  : integer;
    FCritSec        : TCriticalSection;
    FNewDat         : string;
    FNewMsgCount    : integer;
    FNoBrowser      : boolean;
    FError          : boolean;
    FErrorString    : string;
    FReseted        : boolean;
    FLoadedIndex    : integer;
    FThreadMgr: TIdThreadMgr;
    procedure LoadLog;
    procedure BBS_DownloadProcess (Sender : TObject);
    procedure BBS_DownloadComplete(Sender : TObject);
    procedure BBS_Error(Sender : TObject; ErrorCode : TFrameworkErrorType; ErrorString : string);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
    function  ParseDat(line : string; var Title : string) : TTopicMessage;
    procedure AddNewArticles;
    procedure RaiseMessageReceivedEvent;
    procedure SetNoDownload(const Value: Boolean);
    procedure SetTopic(const Value: TTopic);
    procedure SetThreadMgr(const Value: TIdThreadMgr);
  public
    property  Topic : TTopic read FTopic write SetTopic;
    property  NoDownload : Boolean read FNoDownload write SetNoDownload;
    property  ThreadMgr : TIdThreadMgr read FThreadMgr write SetThreadMgr;
    procedure Run;
  end;

implementation

{ TTopicDownloadThread }

procedure TTopicDownloadThread.Run;
var
  Board  : TOnlineBoard;
  newmsg : integer;
  logpath        : string;
label
  StartDownload,
  Finish;
begin

  // BeforRun

  FTopic := Topic;
  FTopic.CountUp;
  FNoDownload := NoDownload;
  FCritSec    := TCriticalSection.Create;

  if Topic.NewMessageCount < 0 then
    newmsg := 0
  else
    newmsg := Topic.NewMessageCount;
  FLoadedIndex := Topic.GotMessageCount - newmsg;
  Board := TOnlineBoard(Topic.Board);
  FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, Topic.TopicId);

  // Run

  FTopic.IsDownloadingTopic := true;
  FTopic.CheckWriteFolder;
  FNewMsgCount := 0;
  FNoBrowser   := not Assigned(FTopic.OnMessageReceived);

  // Oǂݍ
  LoadLog();

  {
  if FNoBrowser = false then
  begin
    FTopic.NewMessageCount := 0;
  end;
  }

StartDownload:

  if FNoDownload = false then
  begin

//    if Terminated = true then goto Finish;

    // ʐMJn
    FReceivedIndex := -1;
    FBBSGetTopic.OnReceived         := BBS_DownloadProcess;
    FBBSGetTopic.OnComplete         := BBS_DownloadComplete;
    FBBSGetTopic.OnStatusTextChange := BBS_StatusTextChange;
    FBBSGetTopic.OnError            := BBS_Error;
    FBBSGetTopic.LastModified       := FTopic.LastModified;
    FBBSGetTopic.DatSize            := FTopic.DatSize;
    FBBSGetTopic.GotMessageCount    := FTopic.GotMessageCount;
    FBBSGetTopic.Get;

    if FBBSGetTopic is TBBS2chGetTopic then
      if TBBS2chGetTopic(FBBSGetTopic).Freezed then
      begin
        FBBSGetTopic.Free;
        Board := TOnlineBoard(FTopic.Board);
        FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, FTopic.TopicId, btKako);
        goto StartDownload;
      end;

    if gSessionId <> '' then
      if FBBSGetTopic is TBBS2chKakoGetTopic then
        if TBBS2chKakoGetTopic(FBBSGetTopic).IsExists = false then
        begin
          FBBSGetTopic.Free;
          Board := TOnlineBoard(FTopic.Board);
          FBBSGetTopic := CreateBBSGetTopic(Board.Server, Board.BoardName, FTopic.TopicId, btDolib);
          goto StartDownload;
        end;

  end;

Finish:

end;

procedure TTopicDownloadThread.BBS_DownloadProcess(Sender: TObject);
begin

  FCritSec.Enter;

  //Synchronize(AddNewArticles);
  AddNewArticles;

  FCritSec.Leave;

end;

procedure TTopicDownloadThread.BBS_DownloadComplete(Sender: TObject);
var
  logpath : string;
begin

    // L^
    FTopic.LastModified    := FBBSGetTopic.LastModified;
    FTopic.DatSize         := FBBSGetTopic.DatSize;
    FTopic.GotMessageCount := FTopic.GotMessageCount + FNewMsgCount;
    FTopic.MessageCount    := FTopic.GotMessageCount;

    if FNewMsgCount > 0 then
      FTopic.LastReadDate  := DateTimeToStr(Now());

    if FNoBrowser then
      FTopic.NewMessageCount := FTopic.NewMessageCount + FNewMsgCount
    else
      FTopic.NewMessageCount := 0;
      
    //FTopic.GotMessageCount := FTopic.MessageList.Count;

    if FError = false then
    begin
      FTopic.DownloadState := dsNone;

      if FNewMsgCount = 0 then
        FTopic.StatusText := 'VȂ'
      else
        FTopic.StatusText := IntToStr(FNewMsgCount) + '̃XM';
    end else
      FTopic.StatusText := FErrorString;


      

  // DATt@C̏o
  logpath := FTopic.LocalDir + FTopic.TopicId + '.d';
  AssignFile(FDatFile, logpath);
  if FileExists(logpath) = false then ReWrite(FDatFile);
  Append(FDatFile);
  Write(FDatFile, FNewDat);
  CloseFile(FDatFile);

  FTopic.SaveIdx();

  FTopic.DownloadState := dsNone;
  FTopic.IsDownloadingTopic := false;

  // AfterRun

  FTopic.CountDown;
  FBBSGetTopic.Free;

end;

procedure TTopicDownloadThread.RaiseMessageReceivedEvent;
begin
  if Assigned(FTopic.OnMessageReceived) then
    FTopic.OnMessageReceived(FTopic);
end;

function TTopicDownloadThread.ParseDat(line: string; var Title : string): TTopicMessage;
var
  items : TStringArray;
  msgName     : string;
  msgEmail    : string;
  msgRestStr  : string;
  msgBody     : string;
  msg         : TTopicMessage;
begin

  items := Split(line, '<>');
  if Length(items) > 3 then
  begin
    msgName    := items[0];
    msgEmail   := items[1];
    msgRestStr := items[2];
    msgBody    := items[3];
  end;

  Title := '';
  if Length(items) > 4 then
    Title :=items[4]; 

  msg := TTopicMessage.Create;
  msg.PostName  := msgName;
  msg.PostEmail := msgEmail;
  msg.RestStr   := msgRestStr;
  msg.Body      := msgBody;

  result := msg

end;

procedure TTopicDownloadThread.LoadLog;
var
  localloaded : boolean;
  I, J        : Integer;
  msg         : TTopicMessage;
  logpath     : string;
  lines       : TStringList;
  items       : TStringArray;
  msgName     : string;
  msgEmail    : string;
  msgRestStr  : string;
  msgBody     : string;
  msgs        : TList;
  Title       : string;
begin

  SetLength(items, 0);

  localloaded := false;
  if FTopic.IsLoadedLocalDat = false then
  begin

    lines := TStringList.Create;

    logpath := FTopic.LocalDir + FTopic.TopicId + '.d';
    if FileExists(logpath) = true then
    begin

      if FNoBrowser = false then
      begin

        // [Jǂݍ
        lines.LoadFromFile(logpath);
        for I := 0 to lines.Count - 1 do
        begin
          msg := ParseDat(lines[I], Title);
          FTopic.AddNewMessage(msg);
          if msg.Index > FLoadedIndex then
            msg.IsNewMessage := true;
          if (I = 0) and (Title <> '') then
            FTopic.Title := Title; 

        end;
        localloaded := true;
      end;

    end else
    begin

      localloaded := true;

      // Of[^AÂ``
      // ÔȂ炻炩ǂݍ
      logpath := FTopic.LocalDir + FTopic.TopicId + '.dat';
      if FileExists(logpath) = true then
      begin
        FTopic.OldLog := true;

        lines.LoadFromFile(logpath);
        for I := 0 to lines.Count - 1 do
        begin
          items := Split(lines[I], ',');
          for J := 0 to 3 do
            items[J] := StringReplace(items[J], 'M', ',', [rfReplaceAll]);

          msgName    := items[0];
          msgEmail   := items[1];
          msgRestStr := items[2];
          msgBody    := items[3];

          if FNoBrowser = false then
          begin
            msg := TTopicMessage.Create;
            msg.PostName  := msgName;
            msg.PostEmail := msgEmail;
            msg.RestStr   := msgRestStr;
            msg.Body      := msgBody;
            FTopic.AddNewMessage(msg);
          end;

          FNewDat := FNewDat    +
                     msgName    + '<>'
                   + msgEmail   + '<>'
                   + msgRestStr + '<>'
                   + msgBody    + #13#10;

        end;
      end;
    end;
    if localloaded then
      FTopic.IsLoadedLocalDat := true;

    lines.Free;    
  end;

  if FTopic.IsLoadedLocalDat then
  begin
    msgs := FTopic.MessageList.LockList;
  	FTopic.Gotmessagecount := msgs.Count;
    FTopic.MessageList.UnlockList;
  end;

  RaiseMessageReceivedEvent;
  FTopic.DownloadState := dsDatLoaded;

end;

procedure TTopicDownloadThread.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin
  FTopic.StatusText := StatusText;
end;

procedure TTopicDownloadThread.BBS_Error(Sender: TObject;
  ErrorCode: TFrameworkErrorType; ErrorString: string);
begin
  FTopic.StatusText := ErrorString;
  FError := true;
  FErrorString := ErrorString;

end;

procedure TTopicDownloadThread.AddNewArticles;
var
  I   : integer;
  msg : TTopicMessage;
  Title : string;
begin

  if FBBSGetTopic.Reset then
    if FReseted = false then
    begin
      FTopic.EraseMessageList;
      FReseted := true;
    end;
  
  for I := FReceivedIndex + 1 to FBBSGetTopic.ArticleList.Count - 1 do
  begin

    if FTopic.IsLoadedLocalDat then
    begin
      try
        msg := ParseDat(FBBSGetTopic.ArticleList[I], Title);
        msg.IsNewMessage := true;
        FTopic.AddNewMessage(msg);

        if (msg.Index = 1) and (Title <> '') then
          FTopic.Title := Title; 

      except on Exception do ;
      end;
    end;

    Inc(FNewMsgCount);
    FNewDat := FNewDat + FBBSGetTopic.ArticleList[I] + #13#10;

    FReceivedIndex := I;
  end;

  if FNoBrowser = false then
    RaiseMessageReceivedEvent;

end;

procedure TTopicDownloadThread.SetNoDownload(const Value: Boolean);
begin
  FNoDownload := Value;
end;

procedure TTopicDownloadThread.SetTopic(const Value: TTopic);
begin
  FTopic := Value;
end;

procedure TTopicDownloadThread.SetThreadMgr(const Value: TIdThreadMgr);
begin
  FThreadMgr := Value;
end;

end.
