unit untOption;

interface

uses
  IniFiles, SysUtils, Forms, Registry, Graphics,
  untCrypt,
  untTool;

const
  APP_USERAGENT    = 'Monazilla/1.00 hage/1.00 (88000)';
  APP_2chUA        = 'katju88';
  DIR_LOG          = 'log\';
  FILE_BOARDALIAS  = 'board.alias';

type
  TBrowserType = (ubIE = 0 , ubDoe = 1);

var

  // O[oIvV
  gBoardListUrl  : string;         // {[hXgURL
  gWriteProxyUse : Boolean;        // ݂ɃvLVg
  gWriteProxy    : string;         // ݗpvLV
  gReadProxyUse  : Boolean;        // ǂݍ݂ɃvLVg
  gReadProxy     : string;         // ǂݍݗpvLV
  gHeaderHtml    : string;         // uEUowb_HTML
  gResHtml       : string;         // uEUoXHTML
  gNewResHtml    : string;         // uEUoVXHTML
  gViewLimit     : Integer;        // \X
  gDefaultSage   : Boolean;        // ftHg"sage"ݒ肷邩
  gBrowserType   : TBrowserType;   // uEU
  gUserAgent     : string;         // User-Agent
  gAlwaysNewTab  : Boolean;        // ɐV^uŊJ
  gMultiLineTab  : Boolean;        // ^u𕡐s\邩
  gAutoLogin     : boolean;        // NɃOC邩
  gUserId        : string;         // [U[ID
  gPassword      : string;         // pX[h
  gSavePassword  : boolean;        // pX[hۑ邩
  gAutoFocus     : boolean;

  gOffLineMode  : Boolean;         // ItC[h쒆
  gSessionID    : string;          // OCZbVID

  // CAEg֘A
  gMainFormWindowState : Integer;  // MainForm WindowState
  gMainFormWidth       : Integer;  // MainForm Width
  gMainFormHeight      : Integer;  // MainForm Height
  gMainFormLeft        : Integer;
  gMainFormTop         : Integer;
  gMainFormStyleType3  : Boolean;
  gMainFormStyleSub1   : Boolean;
  gMainFormStyleSub2   : Boolean;
  gMainFormStyleSub3   : Boolean;
  gBoardListBoxWidth   : Integer;  // BoardListBox  Width  size
  gBoardListNoColor    : Boolean;
  gBoardListOneCategory: Boolean;
  gTopicListViewWidth  : Integer;  // TopicListView Width  size
  gTopicListViewHeight : Integer;  // TopicListView Height size
  gTopicListViewColumnOrders : string;
  gTopicListViewColumnWidths : string;
  gTopicListViewColumnPadding : Integer;
  gTopicListViewColumnFontSize : Integer;
  gTopicListViewGridLines      : boolean;
  gCoolBarBandId       : string;
  gCoolBarBandWidth    : string;
  gCoolBarBandBreak    : string;

  // OuEUݒ 
  gUseDefaultBrowser : Boolean; 
  gBrowserPath       : string; 
  gInsertURL         : string;

  //݃tH[֘A
  gNameListFile    : string; 
  gMailListFile    : string; 
  gWriteFormWidth  : Integer; 
  gWriteFormHeight : Integer; 
  gWriteFormLeft   : Integer; 
  gWriteFormTop    : Integer;
  gKoteHan         : string; 
  gKoteMail        : string;

  // XꗗF֘A 
  gTopicListColorUse      : Boolean; 
  gTopicListNotGotColor   : TColor; 
  gTopicListFavoriteColor : TColor; 
  gTopicListNewMesColor   : TColor; 
  gTopicListNoNewMesColor : TColor; 
  gTopicListNewTopicColor : TColor;

  procedure ReadOption();
  procedure WriteOption();

implementation

const
  FILE_OPTIONINI     = 'katju88.ini';
  FILE_HEADERHTML    = 'Header.htm';
  FILE_RESHTML       = 'Res.htm';
  FILE_NEWRESHTML    = 'NewRes.htm';
  FILE_NAMELIST      = 'namelist.txt'; 
  FILE_MAILLIST      = 'maillist.txt';
  SEC_MAIN           = 'Main';
  SEC_PROXY          = 'Proxy';
  SEC_MAINFORM       = 'MainForm';
  SEC_BOARDLISTBOX   = 'BoardListBox';
  SEC_TOPICLISTVIEW  = 'TopicListView';
  SEC_COOLBAR        = 'CoolBar';
  SEC_KATJU88        = 'katju88';
  SEC_LOGIN          = 'Login';
  SEC_WRITEFORM      = 'WriteForm';
  SEC_BROWSER        = 'Browser';
  KEY_USERAGENT      = 'UserAgent';
  KEY_BOARDLISTURL   = 'BoardListUrl';
  KEY_WRITEPROXYUSE  = 'WriteProxyUse';
  KEY_WRITEPROXY     = 'WriteProxy';
  KEY_READPROXYUSE   = 'ReadProxyUse';
  KEY_READPROXY      = 'ReadProxy';
  KEY_WINDOWSTATE    = 'WindowState';
  KEY_WIDTH          = 'Width';
  KEY_HEIGHT         = 'Height';
  KEY_TOP            = 'Top';
  KEY_LEFT           = 'Left';
  KEY_STYLETYPE3     = 'StyleType3';
  KEY_STYLESUB1      = 'StyleSub1';
  KEY_STYLESUB2      = 'StyleSub2';
  KEY_STYLESUB3      = 'StyleSub3';
  KEY_VIEWLIMIT      = 'ViewLimit';
  KEY_COLUMNWIDTHS   = 'ColumnWidths';
  KEY_COLUMNORDERS   = 'ColumnOrders';
  KEY_COLUMNPADDING  = 'ColumnPadding'; 
  KEY_COLUMNFONTSIZE = 'ColumnFontSize'; 
  KEY_DEFAULTSAGE    = 'DefaultSage';
  KEY_BANDID         = 'BandId';
  KEY_BANDWIDTH      = 'BandWidth';
  KEY_BANDBREAK      = 'BandBreak';
  KEY_BROWSERTYPE    = 'BrowserType';
  KEY_ALWAYSNEWTAB   = 'AlwaysNewTab';
  KEY_MULTILINETAB   = 'MultiLineTab';
  KEY_AUTOLOGIN      = 'AutoLogin';
  KEY_USERID         = 'UserId';
  KEY_PASSWORD       = 'Password';
  KEY_SAVEPASSWORD   = 'SavePassword';
  KEY_GRIDLINES      = 'GridLines';
  KEY_NAMELIST       = 'NameListFile'; 
  KEY_MAILLIST       = 'MailListFile';
  KEY_NoColor        = 'NoColor'; 
  KEY_ONECATEGORY    = 'OneCategory';
  KEY_KOTEHAN        = 'KoteHan'; 
  KEY_KOTEMAIL       = 'KoteMail';
  KEY_USEDEFBROWSER  = 'UseDefBrowser';
  KEY_BROWSERPATH    = 'BrowserPath';
  KEY_INSERTURL      = 'InsertUrl';
  KEY_AUTOFOCUS      = 'AutoFocus';
  KEY_USECOLOR       = 'UseColor'; 
  KEY_CLNOTGOT       = 'NotGotColor'; 
  KEY_CLFAVORITE     = 'FavoriteColor'; 
  KEY_CLNEWMES       = 'NewMessageColor'; 
  KEY_CLNONEWMES     = 'NoNewMessageColor'; 
  KEY_CLNEWTOPIC     = 'NewTopicColor';

{  O[o֐  }

// -----------------------------------------------------
// ֐ : ReadOption
// @ : IvV̓ǂݍ
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure ReadOption();
var
  OptionIni : TIniFile;
  strPath   :string;
begin

  OptionIni      := TIniFile.Create(AppPath(FILE_OPTIONINI));

  // Main
  gBoardListUrl  := OptionIni.ReadString(SEC_MAIN, KEY_BOARDLISTURL, 'http://www6.ocn.ne.jp/~mirv/2chmenu.html');
  gViewLimit     := OptionIni.ReadInteger(SEC_MAIN, KEY_VIEWLIMIT, 50);
  gDefaultSage   := OptionIni.ReadBool(SEC_MAIN, KEY_DEFAULTSAGE, false);
  gBrowserType   := TBrowserType(OptionIni.ReadInteger(SEC_MAIn, KEY_BROWSERTYPE, 0));
  gUserAgent     := OptionIni.ReadString(SEC_MAIN, KEY_USERAGENT, APP_USERAGENT);
  gAlwaysNewTab  := OptionIni.ReadBool(SEC_MAIN, KEY_ALWAYSNEWTAB, false);
  gMultiLineTab  := OptionIni.ReadBool(SEC_MAIN, KEY_MULTILINETAB, false);
  gAutoFocus     := OptionIni.ReadBool(SEC_MAIN, KEY_AUTOFOCUS, true);

  // Proxy
  gWriteProxyUse := OptionIni.ReadBool(  SEC_PROXY, KEY_WRITEPROXYUSE, false);
  gWriteProxy    := OptionIni.ReadString(SEC_PROXY, KEY_WRITEPROXY,    '');
  gReadProxyUse  := OptionIni.ReadBool(  SEC_PROXY, KEY_READPROXYUSE,  false);
  gReadProxy     := OptionIni.ReadString(SEC_PROXY, KEY_READPROXY,     '');

  // MainForm Layout
  gMainFormWindowState := OptionIni.ReadInteger(SEC_MAINFORM, KEY_WINDOWSTATE, Integer(wsNormal));
  gMainFormWidth       := OptionIni.ReadInteger(SEC_MAINFORM, KEY_WIDTH,  600);
  gMainFormHeight      := OptionIni.ReadInteger(SEC_MAINFORM, KEY_HEIGHT, 500);
  gMainFormLeft        := OptionIni.ReadInteger(SEC_MAINFORM, KEY_LEFT,   10);
  gMainFormTop         := OptionIni.ReadInteger(SEC_MAINFORM, KEY_TOP,    10);
  gMainFormStyleType3  := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLETYPE3, false);
  gMainFormStyleSub1   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB1,  false);
  gMainFormStyleSub2   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB2,  false);
  gMainFormStyleSub3   := OptionIni.ReadBool(SEC_MAINFORM, KEY_STYLESUB3,  false);
  gBoardListBoxWidth   := OptionIni.ReadInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,  120);
  gBoardListNoColor    := OptionIni.ReadBool(SEC_BOARDLISTBOX, KEY_NoColor, false);
  gBoardListOneCategory:= OptionIni.ReadBool(SEC_BOARDLISTBOX, KEY_ONECATEGORY, False);
  gTopicListViewWidth  := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,  300);
  gTopicListViewHeight := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT, 100);
  gTopicListViewColumnOrders := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, '');
  gTopicListViewColumnWidths := OptionIni.ReadString(SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, '');
  gTopicListViewColumnPadding := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_COLUMNPADDING, 2); 
  gTopicListViewColumnFontSize := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_COLUMNFONTSIZE, 9); 
  gTopicListViewGridLines      := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_GRIDLINES, false);
  gCoolBarBandId             := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDID, '');
  gCoolBarBandWidth          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDWIDTH, '');
  gCoolBarBandBreak          := OptionIni.ReadString(SEC_COOLBAR, KEY_BANDBREAK, '');

  // OuEUݒ 
  gUseDefaultBrowser := OptionIni.ReadBool  (SEC_BROWSER, KEY_USEDEFBROWSER, True); 
  gBrowserPath       := OptionIni.ReadString(SEC_BROWSER, KEY_BROWSERPATH,   ''); 
  gInsertURL         := OptionIni.ReadString(SEC_BROWSER, KEY_INSERTURL,     '');

  // wb_pHTML
  strPath := AppPath(FILE_HEADERHTML);
  if FileExists(strPath) = true then
    gHeaderHtml := GetFile(strPath)
  else
    gHeaderHtml := '<html lang="ja"><body><font face="lr oSVbN"><dl>';

  // X\pHTML
  strPath := AppPath(FILE_RESHTML);
  if FileExists(strPath) = true then
    gResHtml := GetFile(strPath)
  else
    gResHtml := '<dt>&NUMBER OF<font color="forestgreen">&MAILNAME</font> eF&DATE</dt><dd>&MESSAGE<BR></dd><br>';

  // VX\pHTML
  strPath := AppPath(FILE_NEWRESHTML);
  if FileExists(strPath) = true then
    gNewResHtml := GetFile(strPath)
  else
    gNewResHtml := '<dt><b>&NUMBER</b> OF<font color="forestgreen">&MAILNAME</font> eF&DATE</dt><dd>&MESSAGE<BR></dd><br>';

  // Dolib֘A
  gAutoLogin    := OptionIni.ReadBool  (SEC_LOGIN, KEY_AUTOLOGIN,    false);
  gUserId       := Decrypt(OptionIni.ReadString(SEC_LOGIN, KEY_USERID,  ''));
  gPassword     := Decrypt(OptionIni.ReadString(SEC_LOGIN, KEY_PASSWORD,''));
  gSavePassword := OptionIni.ReadBool  (SEC_LOGIN, KEY_SAVEPASSWORD, false);

  // ݊֘A 
  gNameListFile    := OptionIni.ReadString(SEC_WRITEFORM, KEY_NAMELIST, FILE_NAMELIST); 
  gMailListFile    := OptionIni.ReadString(SEC_WRITEFORM, KEY_MAILLIST, FILE_MAILLIST); 
  gWriteFormWidth  := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_WIDTH,  450); 
  gWriteFormHeight := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_HEIGHT, 370); 
  gWriteFormLeft   := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_LEFT,   385); 
  gWriteFormTop    := OptionIni.ReadInteger(SEC_WRITEFORM, KEY_TOP,    180);
  gKoteHan         := OptionIni.ReadString (SEC_WRITEFORM, KEY_KOTEHAN,  '');
  gKoteMail        := OptionIni.ReadString (SEC_WRITEFORM, KEY_KOTEMAIL, '');

  // XꗗF֘A 
  gTopicListColorUse      := OptionIni.ReadBool   (SEC_TOPICLISTVIEW, KEY_USECOLOR,   True); 
  gTopicListNotGotColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNOTGOT,   clBlack);
  gTopicListFavoriteColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLFAVORITE, clBlack);
  gTopicListNewMesColor   := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNEWMES,   16711680);
  gTopicListNoNewMesColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNONEWMES, clBlack);
  gTopicListNewTopicColor := OptionIni.ReadInteger(SEC_TOPICLISTVIEW, KEY_CLNEWTOPIC, 4227327);

  OptionIni.Free;

end;

// -----------------------------------------------------
// ֐ : WriteOption
// @ : IvV̕ۑ
// @ : Ȃ
// ߂l : Ȃ
// l@ : Ȃ
// -----------------------------------------------------
procedure WriteOption();
var
  OptionIni : TIniFile;
begin

  OptionIni := TIniFile.Create(AppPath(FILE_OPTIONINI));

  // Main
  OptionIni.WriteString(SEC_MAIN, KEY_BOARDLISTURL, gBoardListUrl);
  OptionIni.WriteInteger(SEC_MAIN, KEY_VIEWLIMIT, gViewLimit);
  OptionIni.WriteBool(SEC_MAIN, KEY_DEFAULTSAGE, gDefaultSage);
  OptionIni.WriteInteger(SEC_MAIn, KEY_BROWSERTYPE, Integer(gBrowserType));
  //OptionIni.WriteString(SEC_MAIN, KEY_USERAGENT, gUserAgent);
  OptionIni.WriteBool(SEC_MAIN, KEY_ALWAYSNEWTAB, gAlwaysNewTab);
  OptionIni.WriteBool(SEC_MAIN, KEY_MULTILINETAB, gMultiLineTab);
  OptionIni.WriteBool(SEC_MAIN, KEY_AUTOFOCUS, gAutoFocus);

  // Proxy
  OptionIni.WriteBool(  SEC_PROXY, KEY_WRITEPROXYUSE, gWriteProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_WRITEPROXY,    gWriteProxy);
  OptionIni.WriteBool(  SEC_PROXY, KEY_READPROXYUSE,  gReadProxyUse);
  OptionIni.WriteString(SEC_PROXY, KEY_READPROXY,     gReadProxy);

  // MainForm Layout
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_WINDOWSTATE, gMainFormWindowState);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_WIDTH,       gMainFormWidth);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_HEIGHT,      gMainFormHeight);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_LEFT,        gMainFormLeft);
  OptionIni.WriteInteger(SEC_MAINFORM, KEY_TOP,         gMainFormTop);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLETYPE3, gMainFormStyleType3);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB1,  gMainFormStyleSub1);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB2,  gMainFormStyleSub2);
  OptionIni.WriteBool(SEC_MAINFORM, KEY_STYLESUB3,  gMainFormStyleSub3);
  OptionIni.WriteInteger(SEC_BOARDLISTBOX,  KEY_WIDTH,        gBoardListBoxWidth);
  OptionIni.WriteBool(SEC_BOARDLISTBOX, KEY_NOCOLOR,    gBoardListNoColor); 
  OptionIni.WriteBool(SEC_BOARDLISTBOX, KEY_ONECATEGORY, gBoardListOneCategory);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_WIDTH,        gTopicListViewWidth);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_HEIGHT,       gTopicListViewHeight);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNWIDTHS, gTopicListViewColumnWidths);
  OptionIni.WriteString (SEC_TOPICLISTVIEW, KEY_COLUMNORDERS, gTopicListViewColumnOrders);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_COLUMNPADDING, gTopicListViewColumnPadding);
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_COLUMNFONTSIZE, gTopicListViewColumnFontSize);
  OptionIni.WriteBool   (SEC_TOPICLISTVIEW, KEY_GRIDLINES, gTopicListViewGridLines);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDID, gCoolBarBandId);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDWIDTH, gCoolBarBandWidth);
  OptionIni.WriteString(SEC_COOLBAR, KEY_BANDBREAK, gCoolBarBandBreak);

  // OuEUݒ 
  OptionIni.WriteBool  (SEC_BROWSER, KEY_USEDEFBROWSER, gUseDefaultBrowser); 
  OptionIni.WriteString(SEC_BROWSER, KEY_BROWSERPATH,   gBrowserPath); 
  OptionIni.WriteString(SEC_BROWSER, KEY_INSERTURL,     gInsertURL);

  // Dolib֘A
  OptionIni.WriteBool  (SEC_LOGIN, KEY_AUTOLOGIN,    gAutoLogin);
  OptionIni.WriteString(SEC_LOGIN, KEY_USERID,       Crypt(gUserId));
  OptionIni.WriteBool  (SEC_LOGIN, KEY_SAVEPASSWORD, gSavePassword);
  if gSavePassword then
    OptionIni.WriteString(SEC_LOGIN, KEY_PASSWORD,   Crypt(gPassword))
  else
    OptionIni.DeleteKey(SEC_LOGIN, KEY_PASSWORD);

  // ݊֘A 
  OptionIni.WriteString(SEC_WRITEFORM, KEY_NAMELIST, gNameListFile); 
  OptionIni.WriteString(SEC_WRITEFORM, KEY_MAILLIST, gMailListFile); 
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_WIDTH,  gWriteFormWidth); 
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_HEIGHT, gWriteFormHeight); 
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_LEFT,   gWriteFormLeft); 
  OptionIni.WriteInteger(SEC_WRITEFORM, KEY_TOP,    gWriteFormTop);
  OptionIni.WriteString (SEC_WRITEFORM, KEY_KOTEHAN,  gKoteHan); 
  OptionIni.WriteString (SEC_WRITEFORM, KEY_KOTEMAIL, gKoteMail);

  // XꗗF֘A 
  OptionIni.WriteBool   (SEC_TOPICLISTVIEW, KEY_USECOLOR,   gTopicListColorUse); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNOTGOT,   gTopicListNotGotColor); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLFAVORITE, gTopicListFavoriteColor); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNEWMES,   gTopicListNewMesColor); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNONEWMES, gTopicListNoNewMesColor); 
  OptionIni.WriteInteger(SEC_TOPICLISTVIEW, KEY_CLNEWTOPIC, gTopicListNewTopicColor);

  OptionIni.Free;

end;


end.
