unit untLogSweeper;

// ݌v~XB
// ƂŒ܂B

interface

uses
  Contnrs, SysUtils, StrUtils, Dialogs,
  untBoard, untTopic,
  untOption, untTool, Math;

type

  TLogInfo = class
  public
    Path : string;
    Size : integer;
    LastUpdate : TDateTime;
  end;

  TLogSweeper = class
  private
    FLogList : TObjectList;
    FAllSize : integer;
    FNoEraseMarkTopic: boolean;
    FLimitSize: integer;
    procedure MoveDir(const path: string);
    function  GetLogInfo(path : string) : TLogInfo;
    procedure FindLogInfo(path : string; var Found : Boolean;
                                         var Index : integer);
    procedure SetLimitSize(const Value: integer);
    procedure SetNoEraseMarkTopic(const Value: boolean);
  public
    property    NoEraseMarkTopic : boolean read FNoEraseMarkTopic write SetNoEraseMarkTopic;
    property    LimitSize        : integer read FLimitSize write SetLimitSize;
    constructor Create();
    destructor  Destroy; override;
    procedure Execute;
  end;

implementation

{ TLogSweeper }

function SortCompare(Item1, Item2: Pointer): Integer;
var
  Log1, Log2 : TLogInfo;
begin

  Log1 := Item1;
  Log2 := Item2;

  result := CompareValue(Log1.LastUpdate, Log2.LastUpdate);

end;

procedure TLogSweeper.Execute;
begin

  FLogList := TObjectList.Create;
  FAllSize := 0;

  MoveDir(AppPath(DIR_LOG));
  FLogList.Sort(SortCompare); 

  // wTCYɎ܂悤ɍ폜
  while FAllSize > FLimitSize do
  begin
    


  end;

  FLogList.Free;

end;



procedure TLogSweeper.MoveDir(const path: string);
var 
  searchRec  : TSearchRec;
  RecUpdate  : TDateTime;
  foundPath  : string;
  filepath   : string;
  LogInfo    : TLogInfo;
begin

  if FindFirst(path +  '\*.*', faAnyFile, searchRec) = 0 then
  begin
    repeat
      if (searchRec.Name <> '.') and (searchRec.Name <> '..') then
      begin

        foundPath := path + '\' + searchRec.Name;

        if (searchRec.Attr and faDirectory) <> 0 then
          MoveDir(foundPath);

        if AnsiEndsText('.i',   searchRec.Name) or
           AnsiEndsText('.d',   searchRec.Name) or
           AnsiEndsText('.idx', searchRec.Name) or
           AnsiEndsText('.dat', searchRec.Name) then
        begin

          filepath := ExtractFilePath(foundPath);
          LogInfo  := GetLogInfo(filepath);

          LogInfo.Size := LogInfo.Size + searchRec.Size;
          FAllSize     := FAllSize + searchRec.Size;
          RecUpdate := FileDateToDateTime(searchRec.Time);
          if RecUpdate > LogInfo.LastUpdate then
            LogInfo.LastUpdate := RecUpdate;
        end;

      end;
    until FindNext(searchRec) <> 0;
    FindClose(searchRec);
  end;

end;


function TLogSweeper.GetLogInfo(path: string): TLogInfo;
var
  found : boolean;
  index : integer;
begin

  found := false;
  index := -1;
  FindLogInfo(path, found, index);

  if found = false then
  begin
    result := TLogInfo.Create;
    result.Path := path;
    FLogList.Insert(index, result); 
  end else
    result := TLogInfo(FLogList[Index]);

end;

procedure TLogSweeper.FindLogInfo(path: string; var Found: Boolean;
  var Index: integer);
var
  BinaryMin : integer;
  BinaryMax : integer;
  DataIndex : integer;
  LogInfo   : TLogInfo;
  AddPosition : integer;
begin

  // binary search

  BinaryMin := 0;
  BinaryMax := FLogList.Count - 1;
  Found := false;
  AddPosition := 0;

  while BinaryMin <= BinaryMax do
  begin
    DataIndex := BinaryMin + (BinaryMax - BinaryMin) div 2;
    LogInfo   := TLogInfo(FLogList[DataIndex]);

    if AnsiCompareText(path, LogInfo.Path) < 0 then
    begin
      if DataIndex = 0 then break;
      BinaryMax   := DataIndex - 1;
      AddPosition := BinaryMax;
    end else if AnsiCompareText(path, LogInfo.Path) > 0 then
    begin
      BinaryMin   := DataIndex + 1;
      AddPosition := BinaryMin;
    end else
    begin
      AddPosition := DataIndex;
      Found := true;
      break;
    end;
  end;

  Index := AddPosition;

end;

constructor TLogSweeper.Create;
begin

end;

destructor TLogSweeper.Destroy;
begin

  inherited;
end;

procedure TLogSweeper.SetLimitSize(const Value: integer);
begin
  FLimitSize := Value;
end;

procedure TLogSweeper.SetNoEraseMarkTopic(const Value: boolean);
begin
  FNoEraseMarkTopic := Value;
end;

end.
