unit untBBSCore;

interface

uses
  Classes, Contnrs, SyncObjs, SysUtils, Forms,
  untTopic, untBoard, untTaskThread;

type

  TBoardStateType = (bsTopicReceived, bsWriteDone);
  TBoardStateChangeEvent = procedure(Board : TBoard; EventType : TBoardStateType) of object;

  TTopicStateType = (stStatusText, stDownloadState);
  TTopicStateChangeEvent = procedure(Topic : TTopic; EventType : TTopicStateType) of object;

  TBBSCore = class
  private
    FTopicCache             : TStringList;
    FTopicErase             : TList;
    FBoardStateChangeEvents : array of TBoardStateChangeEvent;
    FCritSec                : TCriticalSection;
    FTaskList               : TThreadList;
    FDefaultTopicChangeDownloadStateFunction: TNotifyEvent;
    procedure SetDefaultTopicChangeDownloadStateFunction(
      const Value: TNotifyEvent);
  public
    constructor Create;
    destructor  Destroy; override;
    procedure AddBoardStateChangeEvent(Item: TBoardStateChangeEvent);
    procedure RemoveBoardStateChangeEvent(Item : TBoardStateChangeEvent);
    procedure RaiseBoardStateChangeEvent(Board : TBoard; EventType : TBoardStateType);
    procedure FreeTopic(TopicPath: string);
    procedure LoadTopic(Topic: TTopic);

    function  GetTopic(Board : TOnlineBoard; TopicId: string): TTopic;
    function  GetTopicByURL(URL : string) : TTopic;
    procedure DownloadTopic(Topic : TTopic);
    function  PostArticle(Board: TOnlineBoard; TopicId, PostName, PostEmail,
              PostBody: string) : TThread;
    procedure MakeTopic(Board : TOnlineBoard; Title, PostName, PostEmail, PostBody : string);

    property  DefaultTopicChangeDownloadStateFunction : TNotifyEvent read FDefaultTopicChangeDownloadStateFunction write SetDefaultTopicChangeDownloadStateFunction;
    procedure DownloadBoard(OnlineBoard: TOnlineBoard);
    procedure LoadAllSubscribedTopics(Board : TAllSubscribedTopics);
  end;

implementation

uses
  untTopicDownloadThread,
  untTopicPostThread,
  untBoardDownloadThread,
  untGlobal;

//  \bh 

{ --------------------------------------------------------
  ֐: Create
  pr  : RXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
constructor TBBSCore.Create;
begin
  FCritSec := TCriticalSection.Create;
  FTaskList := TThreadList.Create;
  FTopicCache := TStringList.Create;
  FTopicErase := TList.Create;
  FTopicCache.Sorted := true;

end;

{ --------------------------------------------------------
  ֐: Destroy
  pr  : fXgN^
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
destructor TBBSCore.Destroy;
var
  I : integer;
begin

  for I := 0 to FTopicCache.Count - 1 do
    TTopic(FTopicCache.Objects[I]).Destroy;

  for I := 0 to FTopicErase.Count - 1 do
    TTopic(FTopicErase[I]).Free;

  FTaskList.Free;
  FTopicCache.Free;
  FTopicErase.Free;
  FCritSec.Free;

  inherited;
end;

{ --------------------------------------------------------
  ֐: GetTopic
  pr  : gsbN̎擾
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
function TBBSCore.GetTopic(Board : TOnlineBoard; TopicId: string): TTopic;
var
  I         : Integer;
  Index     : Integer;
  newtopic  : TTopic;
  topicPath : string;
begin
  FCritSec.Enter;

  // ݔ
  for I := 0 to FTopicErase.Count - 1 do
    TTopic(FTopicErase[I]).Free;
  FTopicErase.Clear;

  // LbVǂݎ
  newtopic := nil;
  topicPath := IntToStr(Board.BoardId) + ':' + TopicId;
  Index := FTopicCache.IndexOf(TopicPath);
  if Index > - 1 then
  begin
    newtopic := TTopic(FTopicCache.Objects[Index]);
  end;

  // VgsbN
  if newtopic = nil then
  begin
    newtopic := TTopic.Create(Board, TopicId);
    newtopic.DefaultTopicChangeDownloadStateFunction := FDefaultTopicChangeDownloadStateFunction;
    Index := FTopicCache.Add(topicPath);
    FTopicCache.Objects[Index] := newtopic;
  end;

  result := newtopic;

  FCritSec.Leave;
end;

{ --------------------------------------------------------
  ֐: GetTopicByURL
  pr  : gsbN̎擾
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
function TBBSCore.GetTopicByURL(URL: string): TTopic;
begin

  result := nil;

end;

procedure TBBSCore.FreeTopic(TopicPath: string);
var
  Index : integer;
  Topic : TTopic;
begin

  Index := FTopicCache.IndexOf(TopicPath);
  if Index > - 1 then
  begin

    Topic := TTopic(FTopicCache.Objects[Index]);
    FTopicErase.Add(Topic);
    FTopicCache.Objects[Index] := nil;
  end;
end;

{ --------------------------------------------------------
  ֐: DownloadBoard
  pr  : gsbNXg̃_E[h
    : OnlineBoard - Ώۂ̃{[h
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.DownloadBoard(OnlineBoard: TOnlineBoard);
begin

  if OnlineBoard.IsDownloading = false then
  begin
    OnlineBoard.IsDownloading := true;

    gTaskMgr.DownloadBoard(OnlineBoard); 

  end;

end;

{ --------------------------------------------------------
  ֐: LoadAllSubscribedTopics
  pr  : SX̓ǂ݂
    : Board - Ώۂ̃{[h
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.LoadAllSubscribedTopics(Board: TAllSubscribedTopics);
begin

  if Board.IsDownloading = false then
  begin
    Board.IsDownloading := true;

    gTaskMgr.AllSubscribedTopics(Board); 

  end;

end;

{ --------------------------------------------------------
  ֐: DownloadTopic
  pr  : gsbÑ_E[h
    : Topic - _E[hΏۂ̃gsbN
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.DownloadTopic(Topic: TTopic);
begin

  //FCritSec.Enter;

  if Topic.IsDownloadingTopic = false then
  begin
    Topic.IsDownloadingTopic := true;

    Topic.DownloadState := dsStarting;
    //Application.ProcessMessages;

    gTaskMgr.DownloadTopic(Topic);

  end;

  //FCritSec.Leave;

end;

{ --------------------------------------------------------
  ֐: LoadTopic
  pr  : Oǂނ
    : Topic - OǂݑΏۂ̃gsbN
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.LoadTopic(Topic: TTopic);
begin

  FCritSec.Enter;

  if Topic.IsDownloadingTopic = false then
  begin
    Topic.IsDownloadingTopic := true;

    gTaskMgr.DownloadTopic(Topic); 

  end;

  FCritSec.Leave;

end;


{ --------------------------------------------------------
  ֐: PostArticle
  pr  : bZ[W̓e
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
function TBBSCore.PostArticle(Board: TOnlineBoard; TopicId, PostName, PostEmail,
  PostBody: string) : TThread;
var
  PostThread : TTopicPostThread;
begin

  //if Topic.IsPosingArticle = false then
  //begin

    // epXbh𗧂グ
    PostThread := TTopicPostThread.Create(Board, TopicId, '', PostName, PostEmail, PostBody);
    PostThread.Priority := tpLower;
    PostThread.FreeOnTerminate := true;
    result := PostThread;

  //end;

end;

{ --------------------------------------------------------
  ֐: MakeTopic
  pr  : gsbN̍쐬
    : Ȃ
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.MakeTopic(Board: TOnlineBoard; Title, PostName, PostEmail,
  PostBody: string);
var
  PostThread : TTopicPostThread;
begin

  // epXbh𗧂グ
  PostThread := TTopicPostThread.Create(Board, '', Title, PostName, PostEmail, PostBody);
  PostThread.Priority := tpLower;
  PostThread.Resume;
  
end;


{ --------------------------------------------------------
  ֐: AddTopicStateChangeEvent
  pr  : gsbNXVCxgւ̓o^
    : Item -
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
{
procedure TBBSCore.AddTopicStateChangeEvent(Item: TTopicStateChangeEvent);
var
  intLength : integer;
begin

  intLength := Length(FTopicStateChangeEvents);
  SetLength(FTopicStateChangeEvents, intLength + 1);
  FTopicStateChangeEvents[intLength] := Item;

  //FTopicStateChangeEvents.Add(Item);
end;
}

{ --------------------------------------------------------
  ֐: RemoveTopicStateChangeEvent
  pr  : gsbNXVCxg폜
    : Item -
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
{
procedure TBBSCore.RemoveTopicStateChangeEvent(
  Item: TTopicStateChangeEvent);
var
  I : Integer;
  intMax : integer;
  Index : integer;
begin

  intMax := Length(FTopicStateChangeEvents) - 1;
  for I := 0 to intMax do
    if @FTopicStateChangeEvents[I] = @Item then
    begin
      FTopicStateChangeEvents[I] := FTopicStateChangeEvents[intMax];
      break;
    end;

  SetLength(FTopicStateChangeEvents, intMax);

end;
{

{ --------------------------------------------------------
  ֐: RaiseTopicStateChangeEvent
  pr  : Cxg̔s
    : Topic     - gsbN
  @@@: EventType - Cxg̎
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
{
procedure TBBSCore.RaiseTopicStateChangeEvent(Topic: TTopic;
  EventType: TTopicStateType);
var
  I : integer;
begin

  FCritSec.Enter;

  for I := 0 to Length(FTopicStateChangeEvents) - 1 do
  begin
    Application.ProcessMessages;
    if Assigned(FTopicStateChangeEvents[I]) then
      TTopicStateChangeEvent(FTopicStateChangeEvents[I])(Topic, EventType);
  end;

  FCritSec.Leave;

end;
}

{ --------------------------------------------------------
  ֐: AddBoardStateChangeEvent
  pr  : {[hXVCxgւ̓o^
    : Item -
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.AddBoardStateChangeEvent(Item: TBoardStateChangeEvent);
var
  intLength : integer;
begin

  intLength := Length(FBoardStateChangeEvents);
  SetLength(FBoardStateChangeEvents, intLength + 1);
  FBoardStateChangeEvents[intLength] := Item;

  //FBoardStateChangeEvents.Add(Item);
end;

{ --------------------------------------------------------
  ֐: RemoveBoardStateChangeEvent
  pr  : {[hXVCxg폜
    : Item - 
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.RemoveBoardStateChangeEvent(
  Item: TBoardStateChangeEvent);
var
  I : Integer;
  intMax : integer;
begin

  intMax := Length(FBoardStateChangeEvents) - 1;
  for I := 0 to intMax do
    if @FBoardStateChangeEvents[I] = @Item then
    begin
      FBoardStateChangeEvents[I] := FBoardStateChangeEvents[intMax];
      break;
    end;

  SetLength(FBoardStateChangeEvents, intMax);

end;

{ --------------------------------------------------------
  ֐: RaiseBoardStateChangeEvent
  pr  : Cxg̔s
    : Board     - gsbN
  @@@: EventType - Cxg̎
  ߂l: Ȃ
  l  : Ȃ
  ------------------------------------------------------ }
procedure TBBSCore.RaiseBoardStateChangeEvent(Board: TBoard;
  EventType: TBoardStateType);
var
  I : integer;
begin

  for I := 0 to Length(FBoardStateChangeEvents) - 1 do
    if Assigned(FBoardStateChangeEvents[I]) then
      TBoardStateChangeEvent(FBoardStateChangeEvents[I])(Board, EventType);

end;

procedure TBBSCore.SetDefaultTopicChangeDownloadStateFunction(
  const Value: TNotifyEvent);
begin
  FDefaultTopicChangeDownloadStateFunction := Value;
end;


end.
