unit untWriteForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, OleCtrls, SHDocVw, StdCtrls, untTopic,
  untGlobal, MSHTML, untBBSCore, untBoard, untOption, SHDocVw_TLB, ExtCtrls,
  untTopicPostThread, untBBSFramework, StrUtils, untKakikomi, untTool;

type
  TWriteForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    PreviewSheet: TTabSheet;
    Label1: TLabel;
    TitleEdit: TEdit;
    Label2: TLabel;
    NameComboBox: TComboBox;
    Label3: TLabel;
    EmailComboBox: TComboBox;
    BodyMemo: TMemo;
    SageCheckBox: TCheckBox;
    WriteButton: TButton;
    CancelButton: TButton;
    TabSheet3: TTabSheet;
    WebBrowser1: TWebBrowser;
    PreviewBrowser: TWebBrowser;
    Timer1: TTimer;
    Timer2: TTimer;
    Timer3: TTimer;
    Timer4: TTimer;
    Timer5: TTimer;
    procedure FormDeactivate(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure WriteButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SageCheckBoxClick(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure PreviewBrowserNavigateComplete2(Sender: TObject;
      const pDisp: IDispatch; var URL: OleVariant);
    procedure TitleEditChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ComboBoxKeyDown(Sender: TObject; var Key: Word; 
      Shift: TShiftState);
  private
    { Private 錾 }
    FKakikomi   : TKakikomi;
    FMakeTopicMode : Boolean;
    FFormHeight    : Integer;
    FTopic         : TTopic;
    FBoard         : TOnlineBoard;
    FShowing       : Boolean;
    FDefaultMail   : string;
    FWaitInitializePreview : Boolean;
    FChangeText            : Boolean;
    FPostThread : TTopicPostThread;
    procedure BBS_Complete(Sender : TObject);
    procedure BBS_Error(Sender : TObject; ErrorCode : TFrameworkErrorType; ErrorString : string);
    procedure BBS_StatusTextChange(Sender : TObject; StatusText : string);
    function  ExistNewEntry(comboBox : TComboBox) : Boolean; 
    procedure LoadList(comboBox : TComboBox; listFile : String); 
    procedure SaveList(comboBox : TComboBox; listFile : String);
    procedure ViewInit();
  public
    { Public 錾 }
    procedure SetTopic(Topic : TTopic; ResAt : integer = 0);
    procedure SetBoard(Board : TOnlineBoard);
  end;

var
  WriteForm: TWriteForm;

implementation

{$R *.dfm}

procedure TWriteForm.FormDeactivate(Sender: TObject);
begin
  //
  if FShowing then
  begin
    FFormHeight := self.Height;
    self.Height := 0;
  end;

end;

procedure TWriteForm.FormActivate(Sender: TObject);
begin
  if FShowing then
    self.Height := FFormHeight;
end;

procedure TWriteForm.FormCreate(Sender: TObject); 
const 
  KAKIKOMI : string = 'kakikomi.txt'; 
begin 
  FKakikomi := TKakikomi.Create(AppPath(KAKIKOMI));

  FShowing := false;
  FChangeText := true; 
  NameComboBox.Text  := ''; 
  EmailComboBox.Text := ''; 

  self.Height := gWriteFormHeight;
  self.Width  := gWriteFormWidth;
  self.Left   := gWriteFormLeft;
  self.Top    := gWriteFormTop;
  FFormHeight := self.Height;

  LoadList(NameComboBox,  gNameListFile); 
  LoadList(EmailComboBox, gMailListFile); 

end; 

procedure TWriteForm.FormDestroy(Sender: TObject); 
begin 
  if FTopic <> nil then 
    FTopic.CountDown; 

  SaveList(NameComboBox,  gNameListFile);
  SaveList(EmailComboBox, gMailListFile);
  FKakikomi.Free;
  
end; 

procedure TWriteForm.WriteButtonClick(Sender: TObject); 
begin 

  WriteButton.Enabled := false;

  if EmailComboBox.Text = 'sage' then 
    gDefaultSage := true 
  else if EmailComboBox.Text = '' then 
    gDefaultSage := false; 

  if FMakeTopicMode = false then 
  begin 
    FTopic.WroteName  := NameComboBox.Text; 
    FTopic.WroteEmail := EmailComboBox.Text; 
    FTopic.SaveIdx; 
    FPostThread := TTopicPostThread(gBBSCore.PostArticle(FBoard, FTopic.TopicId, NameComboBox.Text, EmailComboBox.Text, BodyMemo.Text)); 
  end else 
  begin 
    gBBSCore.MakeTopic(FBoard, TitleEdit.Text, NameComboBox.Text, EmailComboBox.Text, BodyMemo.Text); 
  end; 

  FPostThread.OnComplete         := BBS_Complete; 
  FPostThread.OnStatusTextChange := BBS_StatusTextChange; 
  FPostThread.OnError            := BBS_Error; 
  FPostThread.Resume; 

  if ExistNewEntry(NameComboBox) then 
  begin 
    NameComboBox.Items.Add(NameComboBox.Text); 
    SaveList(NameComboBox, gNameListFile); 
  end; 

  if ExistNewEntry(EmailComboBox) and not SageCheckBox.Checked then 
  begin 
    EmailComboBox.Items.Add(EmailComboBox.Text); 
    SaveList(EmailComboBox, gMailListFile); 
  end; 

end;

procedure TWriteForm.SetTopic(Topic: TTopic; ResAt : integer = 0);
begin

  if self.Visible = true then
  begin

    if ResAt > 0 then
      if FTopic = Topic then
        BodyMemo.Text := BodyMemo.Text +  '>>' + IntToStr(ResAt) + #13#10;
      

    self.Show;
    exit;
  end;

  Topic.CountUp;
  FMakeTopicMode := false;
  FTopic := Topic;
  FBoard := TOnlineBoard(Topic.Board);
  self.Caption := 'u' + FTopic.Title + 'vɃX';

  TitleEdit.Text := FTopic.Title;
  TitleEdit.Enabled := false;

  if FTopic.WroteName <> '' then
    NameComboBox.Text := FTopic.WroteName
  else
    NameComboBox.Text := gKoteHan;

  if (FTopic.WroteEmail <> '') and (FTopic.WroteEmail <> 'sage') then 
    FDefaultMail := FTopic.WroteEmail 
  else 
    FDefaultMail := gKoteMail;

  if ResAt = 0 then
    BodyMemo.Text := ''
  else
    BodyMemo.Text := '>>' + IntToStr(ResAt) + #13#10;

  ViewInit;

end;

procedure TWriteForm.SetBoard(Board: TOnlineBoard);
begin

  if self.Visible = true then
  begin
    self.Show;
    exit;
  end;

  FMakeTopicMode := true;
  FBoard := Board;
  self.Caption := 'u' + FBoard.DisplayName + 'vɐVKXbh';

  TitleEdit.Text := '';
  TitleEdit.Enabled := true;

  NameComboBox.Text  := gKoteHan;
  FDefaultMail := gKoteMail ; 

  BodyMemo.Text := '';

  ViewInit;

end;

procedure TWriteForm.ViewInit;
begin

  if EmailComboBox.Text = '' then
    if gDefaultSage = true then
      EmailComboBox.Text := 'sage';
  SageCheckBox.Checked := (EmailComboBox.Text = 'sage');
  SageCheckBoxClick(SageCheckBox);
  WriteButton.Enabled := true;

  Self.Height := FFormHeight;
  self.Show;
  FShowing := true;

end;


procedure TWriteForm.CancelButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TWriteForm.SageCheckBoxClick(Sender: TObject);
begin

  FChangeText := true;
  if SageCheckBox.Checked then
  begin
    EmailComboBox.Text := 'sage';
    EmailComboBox.Enabled := false;
  end else
  begin
    EmailComboBox.Text := FDefaultMail;
    EmailComboBox.Enabled := true;    
  end;
    
end;

procedure TWriteForm.PageControl1Change(Sender: TObject);

  function ToHtml(Text : string) : string;
  begin
    Text  := StringReplace(Text, '<', '&lt;', [rfReplaceAll]);
    Text  := StringReplace(Text, '>', '&gt;', [rfReplaceAll]);
    result := Text;
  end;

var
  Preview   : string;
  PostName  : string;
  PostEmail : string;
  MailName  : string;
  Body      : string;
  I         : Integer;
begin
  //

  if PageControl1.ActivePage = PreviewSheet then
    if FChangeText then
    begin
      FChangeText := false;

      FWaitInitializePreview := true;
      PreviewBrowser.Navigate('about:blank');

      // o܂ő҂
      for I := 0 to 100 do
        if FWaitInitializePreview = false then
          break
        else
          Application.ProcessMessages;

      if NameComboBox.Text <> '' then
        PostName := ToHtml(NameComboBox.Text)
      else
        PostName := 'vr[̖';
      PostEmail := ToHtml(EmailComboBox.Text);
      if PostEmail <> '' then
        MailName := '<a href="mailto:' + PostEmail + '"><b>' + PostName + '</b></a>'
      else
        MailName := '<font color=green><b>' + PostName + '</b></font>';

      Body := ToHtml(BodyMemo.Text);
      Body := StringReplace(Body, #13#10, '<BR>', [rfReplaceAll]);

      Preview  := '<html><head><meta http-equiv="Content-Type" content="text/html; ' +
                  'charset=Shift_JIS"></head><body bgcolor=#efefef text=black ' +
                  'link=blue alink=red vlink=#660099>' +
                  '<font face="lr oSVbN"><dl>' +
                  '<dt>1 F' + MailName + ' F00/00/00 00:00<dd>' + Body + '<br></dd><br>';

      OleVariant(PreviewBrowser.Document as IHTMLDocument2).write(Preview);
    end;

end;

procedure TWriteForm.PreviewBrowserNavigateComplete2(Sender: TObject;
  const pDisp: IDispatch; var URL: OleVariant);
begin
  FWaitInitializePreview := false;
end;

procedure TWriteForm.TitleEditChange(Sender: TObject);
begin
  FChangeText := true;
end;

procedure TWriteForm.BBS_Complete(Sender: TObject);
begin
  if FMakeTopicMode = false then
  begin
    FTopic.LastWriteDate := DateTimeToStr(Now());
    FTopic.SaveIdx;
    gBBSCore.DownloadTopic(FTopic);
  end;
  FKakikomi.Write(FTopic.LastWriteDate, FTopic.Title, FTopic.BrowserUrl, FTopic.WroteName, FTopic.WroteEmail, BodyMemo.Text);

  Close;
end;

procedure TWriteForm.BBS_Error(Sender: TObject;
  ErrorCode: TFrameworkErrorType; ErrorString: string);
begin
  ShowMessage(ErrorString);
  WriteButton.Enabled := true;
end;

procedure TWriteForm.BBS_StatusTextChange(Sender: TObject;
  StatusText: string);
begin
  self.Caption := StatusText;
end;

procedure TWriteForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin

  FShowing := false;
  if self.Height <> 0 then
  begin
    gWriteFormHeight:= FFormHeight;
    gWriteFormWidth := Width;
    gWriteFormLeft  := Left;
    gWriteFormTop   := Top;
  end;
  
end;

// ɃXgɂ邩ǂ 
function TWriteForm.ExistNewEntry(comboBox : TComboBox) : Boolean; 
begin 
  if (comboBox.Text <> '') and (comboBox.Items.IndexOf(comboBox.Text) = -1) then 
    Result := True 
  else 
    Result := False; 
end; 

procedure TWriteForm.LoadList(comboBox : TComboBox; listFile : String); 
begin 
  if FileExists(gNameListFile) and AnsiEndsText('.txt', listFile) then 
  begin 
    comboBox.items.LoadFromFile(listFile); 
  end; 
end; 

procedure TWriteForm.SaveList(comboBox : TComboBox; listFile : String); 
var 
  i : Integer; 
  stringList : TStringList; 
begin 
  // ςȃt@CgȂ悤Ɋgq .txt  
  if AnsiEndsText('.txt', listFile) then 
  begin 
    stringList := TStringList.Create; 
    for i := 0 to comboBox.Items.Count - 1 do 
    begin 
      // 󔒍s͏ 
      if comboBox.Items[i] <> '' then 
       stringList.Add(comboBox.Items[i]); 
    end; 
    stringList.SaveToFile(listFile); 
    stringList.Free; 
  end; 
end; 

// [Delete] L[ŃGg폜 
procedure TWriteForm.ComboBoxKeyDown(Sender: TObject; var Key: Word; 
  Shift: TShiftState); 
var 
  comboBox  : TComboBox; 
  itemIndex : Integer; 
begin 
  if (Sender is TComboBox) and (Key = VK_DELETE) then 
  begin 
    comboBox  := TComboBox(Sender); 
    itemIndex := comboBox.ItemIndex; 
    comboBox.Items.Delete(itemIndex); 
  end; 
end;

end.
