unit untOptionForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, untOption, untTool, untColorButton;

type
  TOptionForm = class(TForm)
    TabSheet5: TTabSheet; 
    TopicListColorGroupBox: TGroupBox; 
    TopicListColorCheckBox: TCheckBox; 
    FavoriteLabel: TLabel; 
    NotGotTopicLabel: TLabel; 
    NewMessageLabel: TLabel; 
    NoNewMessageLabel: TLabel; 
    NewTopicLabel: TLabel;
    PageControl1: TPageControl;
    TabSheet2: TTabSheet;
    OKButton: TButton;
    CancelButton: TButton;
    TabSheet1: TTabSheet;
    GroupBox1: TGroupBox;
    UseReadProxyCheckBox: TCheckBox;
    ReadProxyEdit: TEdit;
    UseWriteProxyCheckBox: TCheckBox;
    WriteProxyEdit: TEdit;
    Label1: TLabel;
    UserAgentEdit: TEdit;
    AlwaysNewTabCheckBox: TCheckBox;
    MultiLineTabCheckBox: TCheckBox;
    ViewLimitComboBox: TComboBox;
    Label2: TLabel;
    GroupBox2: TGroupBox;
    Label3: TLabel;
    BoardListNoColorCheckBox: TCheckBox;
    BoardListOneCategoryCheckBox: TCheckBox;
    Edit1: TEdit;
    TabSheet3: TTabSheet;
    UseDefaultBrowserCheckBox: TCheckBox;
    Label4: TLabel;
    BrowserPathEdit: TEdit;
    BrowseBrowserPathButton: TButton;
    TabSheet4: TTabSheet;
    Label5: TLabel;
    KoteHanEdit: TEdit;
    Label6: TLabel;
    KoteMailEdit: TEdit;
    GroupBox3: TGroupBox;
    CheckBox4: TCheckBox;
    Edit5: TEdit;
    Label7: TLabel;
    CheckBox5: TCheckBox;
    OpenDialog1: TOpenDialog;
    AutoFocusCheckBox: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure OKButtonClick(Sender: TObject);
    procedure UseDefaultBrowserCheckBoxClick(Sender: TObject);
    procedure BrowseBrowserPathButtonClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject); 
    procedure TopicListColorCheckBoxClick(Sender: TObject);
  private
    { Private 錾 }
    FNotGotColorButton : TColorButton; 
    FFavoriteColorButton : TColorButton; 
    FNewMesColorButton : TColorButton; 
    FNoNewMesColorButton : TColorButton; 
    FNewTopicColorButton : TColorButton;
  public
    { Public 錾 }
  end;

var
  OptionForm: TOptionForm;

implementation

{$R *.dfm}

procedure TOptionForm.FormCreate(Sender: TObject);
var
  I : integer;
begin

  FNotGotColorButton := TColorButton.Create(TopicListColorGroupBox); 
  FNotGotColorButton.Left     := NotGotTopicLabel.Left + NotGotTopicLabel.Width + 20; 
  FNotGotColorButton.Top      := NotGotTopicLabel.Top - 2; 
  FNotGotColorButton.Color    := gTopicListNotGotColor; 
  FNotGotColorButton.TabOrder := 2; 
  FNotGotColorButton.TabStop  := True; 
  NotGotTopicLabel.FocusControl := FNotGotColorButton; 

  FFavoriteColorButton := TColorButton.Create(TopicListColorGroupBox); 
  FFavoriteColorButton.Left     := FavoriteLabel.Left + FavoriteLabel.Width + 20; 
  FFavoriteColorButton.Top      := FavoriteLabel.Top - 2; 
  FFavoriteColorButton.Color    := gTopicListFavoriteColor; 
  FFavoriteColorButton.TabOrder := 3; 
  FFavoriteColorButton.TabStop  := True; 
  FavoriteLabel.FocusControl := FFavoriteColorButton; 

  FNewMesColorButton := TColorButton.Create(TopicListColorGroupBox); 
  FNewMesColorButton.Left     := NewMessageLabel.Left + NewMessageLabel.Width + 20; 
  FNewMesColorButton.Top      := NewMessageLabel.Top - 2; 
  FNewMesColorButton.Color    := gTopicListNewMesColor; 
  FNewMesColorButton.TabOrder := 4; 
  FNewMesColorButton.TabStop  := True; 
  NewMessageLabel.FocusControl := FNewMesColorButton; 

  FNoNewMesColorButton := TColorButton.Create(TopicListColorGroupBox); 
  FNoNewMesColorButton.Left     := NoNewMessageLabel.Left + NoNewMessageLabel.Width + 20; 
  FNoNewMesColorButton.Top      := NoNewMessageLabel.Top - 2; 
  FNoNewMesColorButton.Color    := gTopicListNoNewMesColor; 
  FNoNewMesColorButton.TabOrder := 5; 
  FNoNewMesColorButton.TabStop  := True; 
  NoNewMessageLabel.FocusControl := FNoNewMesColorButton; 

  FNewTopicColorButton := TColorButton.Create(TopicListColorGroupBox); 
  FNewTopicColorButton.Left     := NewTopicLabel.Left + NewTopicLabel.Width + 20; 
  FNewTopicColorButton.Top      := NewTopicLabel.Top - 2; 
  FNewTopicColorButton.Color    := gTopicListNewTopicColor; 
  FNewTopicColorButton.TabOrder := 6; 
  FNewTopicColorButton.TabStop  := True; 
  NewTopicLabel.FocusControl := FNewTopicColorButton; 

  TopicListColorCheckBox.Checked := gTopicListColorUse;

  TopicListColorCheckBoxClick(TopicListColorCheckBox);

  UseReadProxyCheckBox.Checked  := gReadProxyUse;
  ReadProxyEdit.Text            := gReadProxy;
  UseWriteProxyCheckBox.Checked := gWriteProxyUse;
  WriteProxyEdit.Text           := gWriteProxy;
  UserAgentEdit.Text            := gUserAgent;
  AlwaysNewTabCheckBox.Checked  := gAlwaysNewTab;
  MultiLineTabCheckBox.Checked  := gMultiLineTab;
  BoardListNoColorCheckBox.Checked := gBoardListNoColor;
  BoardListOneCategoryCheckBox.Checked := gBoardListOneCategory;
  UseDefaultBrowserCheckBox.Checked    := gUseDefaultBrowser;
  BrowserPathEdit.Text          := gBrowserPath;
  KoteHanEdit.Text              := gKoteHan;
  KoteMailEdit.Text             := gKoteMail;
  AutoFocusCheckBox.Checked     := gAutoFocus;

  if gViewLimit = 0 then
    ViewLimitComboBox.ItemIndex := 5
  else
    for I := 0 to ViewLimitComboBox.Items.Count - 1 do
      if ViewLimitComboBox.Items[I] = IntToStr(gViewLimit) then
      begin
        ViewLimitComboBox.ItemIndex := I;
      end;

  UseDefaultBrowserCheckBoxClick(UseDefaultBrowserCheckBox);

  {
  if gBrowserType = ubIE then
    IERadioButton.Checked := true
  else
    DoeradioButton.Checked := true;

  UserIdEdit.Text   := gUserId;
  PasswordEdit.Text := gPassword;
  AutoLoginCheckBox.Checked    := gAutoLogin;
  SavePasswordCheckBox.Checked := gSavePassword;
  }

end;

procedure TOptionForm.CancelButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TOptionForm.OKButtonClick(Sender: TObject);
begin

  gTopicListColorUse := TopicListColorCheckBox.Checked; 
  gTopicListNotGotColor := FNotGotColorButton.Color; 
  gTopicListFavoriteColor := FFavoriteColorButton.Color; 
  gTopicListNewMesColor := FNewMesColorButton.Color; 
  gTopicListNoNewMesColor := FNoNewMesColorButton.Color; 
  gTopicListNewTopicColor := FNewTopicColorButton.Color;

  gReadProxyUse  := UseReadProxyCheckBox.Checked;
  gReadProxy     := ReadProxyEdit.Text;
  gWriteProxyUse := UseWriteProxyCheckBox.Checked;
  gWriteProxy    := WriteProxyEdit.Text;
  gUserAgent     := UserAgentEdit.Text;
  gAlwaysNewTab  := AlwaysNewTabCheckBox.Checked;
  gMultiLineTab  := MultiLineTabCheckBox.Checked;
  gBoardListNoColor := BoardListNoColorCheckBox.Checked;
  gBoardListOneCategory := BoardListOneCategoryCheckBox.Checked;
  gUseDefaultBrowser := UseDefaultBrowserCheckBox.Checked;
  gBrowserPath       := BrowserPathEdit.Text;
  gKoteHan           := KoteHanEdit.Text;
  gKoteMail          := KoteMailEdit.Text;
  gAutoFocus         := AutoFocusCheckBox.Checked;

  if ViewLimitComboBox.ItemIndex = 5 then
    gViewLimit := 0
  else
    gViewLimit := StrToIntNeo(ViewLimitComboBox.Items[ViewLimitComboBox.ItemIndex]);

  {
  if IERadioButton.Checked then
    gBrowserType := ubIE
  else
    gBrowserType := ubDoe;

  gUserId       := UserIdEdit.Text;
  gPassword     := PasswordEdit.Text;
  gAutoLogin    := AutoLoginCheckBox.Checked;
  gSavePassword := SavePasswordCheckBox.Checked;
  }

  WriteOption();
  Close;

end;

procedure TOptionForm.UseDefaultBrowserCheckBoxClick(Sender: TObject);
begin
  //
  BrowserPathEdit.Enabled         := not UseDefaultBrowserCheckBox.Checked;
  BrowseBrowserPathButton.Enabled := not UseDefaultBrowserCheckBox.Checked;

end;

procedure TOptionForm.BrowseBrowserPathButtonClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
    BrowserPathEdit.Text := OpenDialog1.FileName; 
end;

procedure TOptionForm.FormDestroy(Sender: TObject); 
begin 
  FNotGotColorButton.Free; 
  FFavoriteColorButton.Free; 
  FNewMesColorButton.Free; 
  FNoNewMesColorButton.Free; 
end;

procedure TOptionForm.TopicListColorCheckBoxClick(Sender: TObject); 
begin 
  if TopicListColorCheckBox.Checked then 
  begin 
    TopicListColorGroupBox.Enabled := True; 
    NotGotTopicLabel.Enabled := True; 
    FavoriteLabel.Enabled := True; 
    NewMessageLabel.Enabled := True; 
    NoNewMessageLabel.Enabled := True; 
    NewTopicLabel.Enabled := True; 
    FNotGotColorButton.Enabled := True; 
    FFavoriteColorButton.Enabled := True; 
    FNewMesColorButton.Enabled := True; 
    FNoNewMesColorButton.Enabled := True; 
    FNewTopicColorButton.Enabled := True; 
  end 
  else begin 
    TopicListColorGroupBox.Enabled := False; 
    NotGotTopicLabel.Enabled := False; 
    FavoriteLabel.Enabled := False; 
    NewMessageLabel.Enabled := False; 
    NoNewMessageLabel.Enabled := False; 
    NewTopicLabel.Enabled := False; 
    FNotGotColorButton.Enabled := False; 
    FFavoriteColorButton.Enabled := False; 
    FNewMesColorButton.Enabled := False; 
    FNoNewMesColorButton.Enabled := False; 
    FNewTopicColorButton.Enabled := False; 
  end; 
end;

end.
