unit untBBS2ch;

interface

uses
  Classes, Dialogs, SysUtils, Forms,
  IdComponent, IdTCPConnection, IdTCPClient, IdHTTP,
  IdCookieManager,
  RegExpr, DzURL, 
  untStreamTool, untTool,
  untBBSFramework,
  untOption, untGlobal,
  untHttp, untLog;

type

  TBBS2chGetTopic = class(TBBSGetTopic)
  private
    FHttp         : TAsyncHttp;
    FError        : boolean;
    FURL          : string;
    FNoFirstLine  : boolean;
    FReadPosition : integer;
    FFreezed: boolean;
    procedure HttpReceived(Sender: TObject);
    procedure HttpStatus(ASender: TObject; const AStatus: TIdStatus; const AStatusText: string);
    procedure HttpComplete(Sender: TObject);
    procedure SetFreezed(const Value: boolean);
  public
    property    Freezed : boolean read FFreezed write SetFreezed;
    procedure   Get(); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBS2chPostArticle = class(TBBSPostArticle)
  private
    FServer  : string;
    FBoardId : string;
    FTopicId : string;
  public
    procedure   Post(PostName, PostEmail, Body : string); override;
    constructor Create(Server, BoardId, TopicId : string);
    destructor  Destroy; override;
  end;

  TBBS2chGetTopicList = class(TBBSGetTopicList)
  private
    FServer       : string;
    FBoardId      : string;
    FReadPosition : integer;
    FWriteEvent   : TMemoryStreamEx;
    FBuffer : TMemoryStream;
    FBufferReader : TStreamReader;
    procedure HttpReceived(const Buff; Count : int64);
  public
    procedure   Get(); override;
    constructor Create(Server, BoardId : string);
  end;

implementation

{ TBBS2chGetTopic }

constructor TBBS2chGetTopic.Create(Server, BoardId, TopicId : string);
begin
  inherited Create();

  FURL := 'http://' + Server + '/' + BoardId + '/dat/' + TopicId + '.dat';

  FHttp := TAsyncHttp.Create;
  FHttp.FreeOnTerminate := false;
  FHttp.OnReceived := HttpReceived;
  FHttp.OnStatus   := HttpStatus;
  FHttp.OnComplete := HttpComplete;

end;

destructor TBBS2chGetTopic.Destroy;
begin

  FHttp.OnReceived := nil;
  //FHttp.Terminate;
  FHttp.Free;

  inherited;
end;

procedure TBBS2chGetTopic.Get;
var
  contentsize : integer;
begin
  inherited;

  FReadPosition := 0;

  if FDatSize > 0 then FHttp.StartRange := FDatSize - 1;
  FNoFirstLine := true;
  FError := false;

  FHttp.Get(FURL);

end;

procedure TBBS2chGetTopic.HttpComplete(Sender: TObject);
var
  contentsize : integer;
begin

  if (FHttp.ResponseCode < 200) or
     (FHttp.ResponseCode > 299) then
  begin
    RaiseError(etDatFreezed, 'DAT܂');
    FFreezed := true;
  end;

  FLastModified := FHttp.LastModified;
  contentsize   := FHttp.ContentLength;

  if contentsize > 0 then
    if FDatSize = 0 then
      FDatSize := contentsize
    else
      FDatSize := FDatSize + contentsize - 1;

  if Assigned(FOnComplete) then FOnComplete(self);

end;

procedure TBBS2chGetTopic.HttpReceived(Sender: TObject);
var
  line   : string;
  RegExp : TRegExpr;
  I      : Integer;
begin

  if Application.Terminated then
  begin
    FError := true;
    //FHttp.Disconnect;
  end;

  if FError then exit;

  RegExp := TRegExpr.Create;
  RegExp.Expression := '^(.*?)<>(.*?)<>(.*?)<>(.*?)<>(.*?)';

  for I := FReadPosition to FHttp.ReceivedLines.Count - 1 do
  begin
    FReadPosition := I + 1;
    line := FHttp.ReceivedLines[I];

    // Ol܂`FbN
    if FNoFirstLine then
    begin
      FNoFirstLine := false;
      if FDatSize > 0 then
        if line = '' then
        begin
          continue;
        end else
        begin
          FError := true;
          RaiseError(etAbone, '폜ځ[ŃOl܂悤ł');
          exit;
        end;
      end;

    // sǉ
    if RegExp.Exec(line) then
      FArticleList.Add(line)
    else begin
      RaiseError(etParse, '̓G[');
      FArticleList.Add('<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>' +
                       '<FONT COLOR="Gray">[Ă܂]</FONT><>');
    end;

  end;

  Regexp.Free;

  if Assigned(OnReceived) then OnReceived(self);

end;

procedure TBBS2chGetTopic.HttpStatus(ASender: TObject;
  const AStatus: TIdStatus; const AStatusText: string);
begin
  

end;

procedure TBBS2chGetTopic.SetFreezed(const Value: boolean);
begin
  FFreezed := Value;
end;

{ TBBS2chPostArticle }

constructor TBBS2chPostArticle.Create(Server, BoardId, TopicId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;
  FTopicId := TopicId;
end;

destructor TBBS2chPostArticle.Destroy;
begin

  inherited;
end;

procedure TBBS2chPostArticle.Post(PostName, PostEmail, Body: string);
var
  PostData  : TStringList;
  intTime   : integer;
  response  : string;
  ErrorMsg  : string;
  writedata : string;
  compdata  : string;
begin

  FHttp.Request.Referer := 'http://' + FServer + '/' + FBoardId  + '/index2.html';
  FHttp.CookieManager   := TIdCookieManager.Create(nil);
  FHttp.HTTPOptions := [];
  FHttp.Request.CustomHeaders.Add('Cookie: NAME=' + UrlEncode(PostName)
                               + '&Cookie: MAIL=' + UrlEncode(PostEmail) +';');

  PostData := TStringList.Create;
  writedata := 'submit='  + UrlEncode('') + '&' +
               'FROM='    + UrlEncode(PostName)   + '&' +
               'mail='    + UrlEncode(PostEmail)  + '&' +
               'MESSAGE=' + UrlEncode(Body)       + '&' +
               'bbs='     + FBoardId              + '&' +
               'key='     + FTopicId;

  if gSessionid <> '' then
    writedata := writedata + '&sid=' + UrlEncode(gSessionid);

  intTime := Round((Now() - EncodeDate(1970, 1, 1)) * 86400 - 32400);
  compdata := writedata + '&' + 'time=' + IntToStr(intTime);
  PostData.Add(compdata);

  response := FHttp.Post('http://' + FServer + '/test/bbs.cgi', PostData);
  if Pos('݂܂', response) = 0 then
  begin

    PostData.Free;
    PostData := TStringList.Create;

    intTime := Round((FHttp.Response.Date - EncodeDate(1970, 1, 1)) * 86400) - 32400 - 100;
    compdata := writedata + '&' + 'time=' + IntToStr(intTime);
    PostData.Add(compdata);

    response := FHttp.Post('http://' + FServer + '/test/bbs.cgi', PostData);
    if Pos('݂܂', response) = 0 then
    begin
      ErrorMsg := CopyMiddle(response, '<b>', '</b>');
    end;
  end;

  PostData.Free;
  FHttp.CookieManager.Free;
  FHttp.CookieManager := nil;

  if ErrorMsg <> '' then
    RaiseError(etPostArticle, ErrorMsg)
  else
    if Assigned(FOnComplete) then FOnComplete(self);

end;

{ TBBS2chGetTopicList }

constructor TBBS2chGetTopicList.Create(Server, BoardId: string);
begin
  inherited Create();

  FServer  := Server;
  FBoardId := BoardId;

end;

procedure TBBS2chGetTopicList.Get;
begin
  inherited;

  try
    FWriteEvent := TMemoryStreamEx.Create();
    FWriteEvent.OnWrite := HttpReceived;
    FBuffer       := TMemoryStream.Create();
    FBufferReader := TStreamReader.Create(FBuffer);
    FHttp.Get('http://' + FServer + '/' + FBoardId + '/subject.txt', FWriteEvent);
  finally
    FBufferReader.Free;
    FBuffer.Free;
    FWriteEvent.Free;
  end;

end;

procedure TBBS2chGetTopicList.HttpReceived(const Buff; Count: int64);
var
  line  : string;
  Regex : TRegExpr;
  BoardDir    : string; 
  SubjectFile : string; 
  fs : TFileStream;
begin

  if gTopicListColorUse and (FTopicList.Count = 0) then 
  begin 
    if not gFolderAlias.GetFolderPath(FServer, FBoardId, 'subjects', BoardDir) then 
    begin 
      if not FileExists(BoardDir) then 
        CreateFullDir(BoardDir); 

      SubjectFile := BoardDir + 'subjects'; 
      if not FileExists(SubjectFile) then 
      begin 
        try 
          fs := TFileStream.Create(SubjectFile, fmCreate or fmShareDenyNone); 
          fs.Free; 
        except 
          on EFCreateError do begin 
          // Create  Free ̊Ԃɕʂ̃Xbh荞ރP[XH肦H 
          end; 
        end; 
        // 쐬ɂ UNIXTIME  EPOCTIME  
        FileSetDate(SubjectFile, DateTimeToFileDate(EncodeDate(1970, 1, 1))); 
      end 
      else 
        FileSetDate(SubjectFile, DateTimeToFileDate(FHttp.Response.LastModified)); 
// LastModified ȂT[o悤Ȃ炱 
//      FileSetDate(SubjectFile, DateTimeToFileDate(FHttp.Response.Date)); 
    end; 
  end;

  Regex := TRegExpr.Create;

  // sPʂ
  FBuffer.Seek(0, soFromEnd);
  FBuffer.Write(Buff, Count);
  FBuffer.Seek(FReadPosition, soFromBeginning);

  while FBufferReader.ReadLine(line) do
  begin
    FReadPosition := FBuffer.Position;

    Regex.Expression := '^(.+?)\.dat<>(.*) \((.+?)\)$';
    if Regex.Exec(line) then
    begin
      AddNewLine(line);
    end else
    begin
      RaiseError(etParse, '̓G[');
    end;

    if Assigned(OnReceived) then OnReceived(self);
  end;

  Regex.Free;

end;


end.
